/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.java19modules;

import com.intellij.codeInspection.BaseJavaLocalInspectionTool;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaModuleReferenceElement;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiRequiresStatement;
import com.intellij.psi.impl.light.LightJavaModule;
import com.intellij.psi.util.PsiUtil;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaRequiresAutoModuleInspection
extends BaseJavaLocalInspectionTool {
    public boolean TRANSITIVE_ONLY = true;

    @Nullable
    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionsBundle.message((String)"inspection.requires.auto.module.option", (Object[])new Object[0]), (InspectionProfileEntry)this, "TRANSITIVE_ONLY");
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/codeInspection/java19modules/JavaRequiresAutoModuleInspection", "buildVisitor"));
        }
        Object object = !PsiUtil.isModuleFile((PsiFile)holder.getFile()) ? PsiElementVisitor.EMPTY_VISITOR : new JavaElementVisitor(){

            public void visitRequiresStatement(PsiRequiresStatement statement2) {
                PsiElement target2;
                PsiPolyVariantReference reference;
                super.visitRequiresStatement(statement2);
                PsiJavaModuleReferenceElement refElement = statement2.getReferenceElement();
                if (refElement != null && (reference = refElement.getReference()) != null && (target2 = reference.resolve()) instanceof LightJavaModule) {
                    if (!JavaRequiresAutoModuleInspection.this.TRANSITIVE_ONLY) {
                        holder.registerProblem((PsiElement)refElement, InspectionsBundle.message((String)"inspection.requires.auto.module.message", (Object[])new Object[0]), new LocalQuickFix[0]);
                    } else if (statement2.hasModifierProperty("transitive")) {
                        holder.registerProblem((PsiElement)refElement, InspectionsBundle.message((String)"inspection.requires.auto.module.transitive", (Object[])new Object[0]), new LocalQuickFix[0]);
                    }
                }
            }
        };
        if (object == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/java19modules/JavaRequiresAutoModuleInspection", "buildVisitor"));
        }
        return object;
    }
}

