/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.javaDoc;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.quickfix.ImportClassFix;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemDescriptorBase;
import com.intellij.codeInspection.javaDoc.JavaDocReferenceInspectionBase;
import com.intellij.ide.DataManager;
import com.intellij.ide.util.FQNameCellRenderer;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.PopupChooserBuilder;
import com.intellij.openapi.util.AsyncResult;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.proximity.PsiProximityComparator;
import com.intellij.ui.components.JBList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.swing.JList;
import org.jetbrains.annotations.NotNull;

public class JavaDocReferenceInspection
extends JavaDocReferenceInspectionBase {
    @Override
    protected LocalQuickFix createAddQualifierFix(PsiJavaCodeReferenceElement reference) {
        List<PsiClass> classesToImport = new ImportClassFix(reference).getClassesToImport();
        return classesToImport.isEmpty() ? null : new AddQualifierFix(classesToImport);
    }

    @Override
    protected RenameReferenceQuickFix createRenameReferenceQuickFix(Set<String> unboundParams) {
        return new RenameReferenceQuickFix(unboundParams);
    }

    private class AddQualifierFix
    implements LocalQuickFix {
        private final List<PsiClass> originalClasses;

        public AddQualifierFix(List<PsiClass> originalClasses) {
            this.originalClasses = originalClasses;
        }

        @NotNull
        public String getFamilyName() {
            String string = QuickFixBundle.message("add.qualifier", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/javaDoc/JavaDocReferenceInspection$AddQualifierFix", "getFamilyName"));
            }
            return string;
        }

        public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor) {
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/javaDoc/JavaDocReferenceInspection$AddQualifierFix", "applyFix"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/codeInspection/javaDoc/JavaDocReferenceInspection$AddQualifierFix", "applyFix"));
            }
            PsiElement element = PsiTreeUtil.getParentOfType((PsiElement)descriptor.getPsiElement(), PsiJavaCodeReferenceElement.class);
            if (element instanceof PsiJavaCodeReferenceElement) {
                PsiJavaCodeReferenceElement referenceElement = (PsiJavaCodeReferenceElement)element;
                Collections.sort(this.originalClasses, new PsiProximityComparator(referenceElement.getElement()));
                JBList list2 = new JBList((Object[])this.originalClasses.toArray(new PsiClass[this.originalClasses.size()]));
                list2.setCellRenderer(new FQNameCellRenderer());
                Runnable runnable2 = () -> this.lambda$applyFix$0(element, (JList)list2, project2, referenceElement);
                AsyncResult asyncResult = DataManager.getInstance().getDataContextFromFocus();
                asyncResult.doWhenDone(arg_0 -> AddQualifierFix.lambda$applyFix$1((JList)list2, runnable2, arg_0));
            }
        }

        private static /* synthetic */ void lambda$applyFix$1(JList list2, Runnable runnable2, DataContext dataContext) {
            new PopupChooserBuilder(list2).setTitle(QuickFixBundle.message("add.qualifier.original.class.chooser.title", new Object[0])).setItemChoosenCallback(runnable2).createPopup().showInBestPositionFor(dataContext);
        }

        private /* synthetic */ void lambda$applyFix$0(PsiElement element, JList list2, final @NotNull Project project2, final PsiJavaCodeReferenceElement referenceElement) {
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/javaDoc/JavaDocReferenceInspection$AddQualifierFix", "lambda$applyFix$0"));
            }
            if (!element.isValid()) {
                return;
            }
            final int index = list2.getSelectedIndex();
            if (index < 0) {
                return;
            }
            new WriteCommandAction(project2, new PsiFile[]{element.getContainingFile()}){

                protected void run(@NotNull Result result2) throws Throwable {
                    if (result2 == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/codeInspection/javaDoc/JavaDocReferenceInspection$AddQualifierFix$1", "run"));
                    }
                    PsiClass psiClass = (PsiClass)AddQualifierFix.this.originalClasses.get(index);
                    if (psiClass.isValid()) {
                        PsiDocumentManager.getInstance((Project)project2).commitAllDocuments();
                        referenceElement.bindToElement((PsiElement)psiClass);
                    }
                }
            }.execute();
        }
    }

    private static class RenameReferenceQuickFix
    implements LocalQuickFix {
        private final Set<String> myUnboundParams;

        public RenameReferenceQuickFix(Set<String> unboundParams) {
            this.myUnboundParams = unboundParams;
        }

        @NotNull
        public String getFamilyName() {
            if ("Change to ..." == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/javaDoc/JavaDocReferenceInspection$RenameReferenceQuickFix", "getFamilyName"));
            }
            return "Change to ...";
        }

        public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor) {
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/javaDoc/JavaDocReferenceInspection$RenameReferenceQuickFix", "applyFix"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/codeInspection/javaDoc/JavaDocReferenceInspection$RenameReferenceQuickFix", "applyFix"));
            }
            AsyncResult asyncResult = DataManager.getInstance().getDataContextFromFocus();
            asyncResult.doWhenDone(dataContext -> {
                if (descriptor == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/codeInspection/javaDoc/JavaDocReferenceInspection$RenameReferenceQuickFix", "lambda$applyFix$0"));
                }
                if (project2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/javaDoc/JavaDocReferenceInspection$RenameReferenceQuickFix", "lambda$applyFix$0"));
                }
                Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
                assert (editor != null);
                TextRange textRange = ((ProblemDescriptorBase)descriptor).getTextRange();
                editor.getSelectionModel().setSelection(textRange.getStartOffset(), textRange.getEndOffset());
                String word = editor.getSelectionModel().getSelectedText();
                if (word == null || StringUtil.isEmptyOrSpaces((String)word)) {
                    return;
                }
                ArrayList<LookupElementBuilder> items = new ArrayList<LookupElementBuilder>();
                for (String variant : this.myUnboundParams) {
                    items.add(LookupElementBuilder.create((String)variant));
                }
                LookupManager.getInstance(project2).showLookup(editor, items.toArray(new LookupElement[items.size()]));
            });
        }
    }
}

