/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.reflectiveAccess;

import com.intellij.codeInsight.daemon.JavaErrorMessages;
import com.intellij.codeInsight.daemon.impl.analysis.JavaModuleGraphUtil;
import com.intellij.codeInsight.daemon.impl.quickfix.AddRequiredModuleFix;
import com.intellij.codeInspection.BaseJavaBatchLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiPackageAccessibilityStatement;
import com.intellij.psi.impl.source.resolve.reference.impl.JavaReflectionReferenceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class Java9ReflectionClassVisibilityInspection
extends BaseJavaBatchLocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        PsiJavaModule javaModule;
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/codeInspection/reflectiveAccess/Java9ReflectionClassVisibilityInspection", "buildVisitor"));
        }
        PsiFile file2 = holder.getFile();
        if (PsiUtil.isLanguageLevel9OrHigher((PsiElement)file2) && (javaModule = JavaModuleGraphUtil.findDescriptorByElement((PsiElement)file2)) != null) {
            JavaElementVisitor javaElementVisitor = new JavaElementVisitor(){

                public void visitMethodCallExpression(PsiMethodCallExpression expression2) {
                    super.visitMethodCallExpression(expression2);
                    if (JavaReflectionReferenceUtil.isCallToMethod(expression2, "java.lang.Class", "forName") || JavaReflectionReferenceUtil.isCallToMethod(expression2, "java.lang.ClassLoader", "loadClass")) {
                        Java9ReflectionClassVisibilityInspection.checkClassVisibility(expression2, holder, javaModule);
                    }
                }
            };
            if (javaElementVisitor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/reflectiveAccess/Java9ReflectionClassVisibilityInspection", "buildVisitor"));
            }
            return javaElementVisitor;
        }
        PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
        if (psiElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/reflectiveAccess/Java9ReflectionClassVisibilityInspection", "buildVisitor"));
        }
        return psiElementVisitor;
    }

    private static void checkClassVisibility(@NotNull PsiMethodCallExpression callExpression, @NotNull ProblemsHolder holder, @NotNull PsiJavaModule javaModule) {
        PsiJavaModule otherModule;
        Project project2;
        JavaPsiFacade facade;
        PsiClass psiClass;
        PsiExpression classNameArgument;
        String className;
        if (callExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callExpression", "com/intellij/codeInspection/reflectiveAccess/Java9ReflectionClassVisibilityInspection", "checkClassVisibility"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/codeInspection/reflectiveAccess/Java9ReflectionClassVisibilityInspection", "checkClassVisibility"));
        }
        if (javaModule == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "javaModule", "com/intellij/codeInspection/reflectiveAccess/Java9ReflectionClassVisibilityInspection", "checkClassVisibility"));
        }
        PsiExpression[] arguments = callExpression.getArgumentList().getExpressions();
        if (arguments.length != 0 && (className = JavaReflectionReferenceUtil.computeConstantExpression(classNameArgument = arguments[0], String.class)) != null && (psiClass = (facade = JavaPsiFacade.getInstance((Project)(project2 = holder.getProject()))).findClass(className, callExpression.getResolveScope())) != null && (otherModule = JavaModuleGraphUtil.findDescriptorByElement((PsiElement)psiClass)) != null && otherModule != javaModule) {
            if (!JavaModuleGraphUtil.reads(javaModule, otherModule)) {
                String message2 = JavaErrorMessages.message("module.not.in.requirements", javaModule.getName(), otherModule.getName());
                holder.registerProblem((PsiElement)classNameArgument, message2, new LocalQuickFix[]{new AddRequiredModuleFix(javaModule, otherModule.getName())});
                return;
            }
            if (otherModule.hasModifierProperty("open")) {
                return;
            }
            PsiJavaFile file2 = (PsiJavaFile)PsiTreeUtil.getParentOfType((PsiElement)psiClass, PsiJavaFile.class);
            if (file2 != null) {
                String packageName = file2.getPackageName();
                if (Java9ReflectionClassVisibilityInspection.isPackageAccessible(otherModule.getOpens(), packageName, javaModule)) {
                    return;
                }
                boolean publicApi = Java9ReflectionClassVisibilityInspection.isPublicApi(psiClass);
                if (publicApi && Java9ReflectionClassVisibilityInspection.isPackageAccessible(otherModule.getExports(), packageName, javaModule)) {
                    return;
                }
                String message3 = JavaErrorMessages.message(publicApi ? "module.package.not.exported" : "module.package.not.open", otherModule.getName(), packageName, javaModule.getName());
                holder.registerProblem((PsiElement)classNameArgument, message3, new LocalQuickFix[0]);
            }
        }
    }

    private static boolean isPackageAccessible(@NotNull Iterable<PsiPackageAccessibilityStatement> statements, @NotNull String packageName, @NotNull PsiJavaModule javaModule) {
        if (statements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statements", "com/intellij/codeInspection/reflectiveAccess/Java9ReflectionClassVisibilityInspection", "isPackageAccessible"));
        }
        if (packageName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageName", "com/intellij/codeInspection/reflectiveAccess/Java9ReflectionClassVisibilityInspection", "isPackageAccessible"));
        }
        if (javaModule == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "javaModule", "com/intellij/codeInspection/reflectiveAccess/Java9ReflectionClassVisibilityInspection", "isPackageAccessible"));
        }
        for (PsiPackageAccessibilityStatement statement2 : statements) {
            List moduleNames;
            if (!packageName.equals(statement2.getPackageName()) || !(moduleNames = statement2.getModuleNames()).isEmpty() && !moduleNames.contains(javaModule.getName())) continue;
            return true;
        }
        return false;
    }

    private static boolean isPublicApi(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/codeInspection/reflectiveAccess/Java9ReflectionClassVisibilityInspection", "isPublicApi"));
        }
        if (psiClass.hasModifierProperty("public") || psiClass.hasModifierProperty("protected")) {
            PsiElement parent = psiClass.getParent();
            return parent instanceof PsiJavaFile || parent instanceof PsiClass && Java9ReflectionClassVisibilityInspection.isPublicApi((PsiClass)parent);
        }
        return false;
    }
}

