/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.sameParameterValue;

import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.sameParameterValue.SameParameterValueInspectionBase;
import com.intellij.codeInspection.unusedSymbol.VisibilityModifierChooser;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.LabeledComponent;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.changeSignature.ChangeSignatureProcessor;
import com.intellij.refactoring.changeSignature.ParameterInfoImpl;
import com.intellij.refactoring.safeDelete.JavaSafeDeleteProcessor;
import com.intellij.refactoring.ui.ConflictsDialog;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.refactoring.util.InlineUtil;
import com.intellij.util.Consumer;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SameParameterValueInspection
extends SameParameterValueInspectionBase {
    private static final Logger LOG = Logger.getInstance(SameParameterValueInspectionBase.class);

    @Nullable
    public JComponent createOptionsPanel() {
        LabeledComponent component = LabeledComponent.create((JComponent)new VisibilityModifierChooser(() -> true, this.highestModifier, (Consumer<String>)((Consumer)newModifier -> {
            this.highestModifier = newModifier;
        })), (String)"Methods to report:", (String)"West");
        JPanel panel2 = new JPanel(new GridBagLayout());
        panel2.add((Component)component, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 23, 12, (Insets)JBUI.emptyInsets(), 0, 0));
        return panel2;
    }

    @Override
    protected LocalQuickFix createFix(String paramName, String value2) {
        return new InlineParameterValueFix(paramName, value2);
    }

    public static class InlineParameterValueFix
    implements LocalQuickFix {
        private final String myValue;
        private final String myParameterName;

        private InlineParameterValueFix(String parameterName, String value2) {
            this.myValue = value2;
            this.myParameterName = parameterName;
        }

        public String toString() {
            return this.getParamName() + " " + this.getValue();
        }

        @NotNull
        public String getName() {
            String string = InspectionsBundle.message((String)"inspection.same.parameter.fix.name", (Object[])new Object[]{this.myParameterName, StringUtil.unquoteString((String)this.myValue)});
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/sameParameterValue/SameParameterValueInspection$InlineParameterValueFix", "getName"));
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionsBundle.message((String)"inspection.same.parameter.fix.family.name", (Object[])new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/sameParameterValue/SameParameterValueInspection$InlineParameterValueFix", "getFamilyName"));
            }
            return string;
        }

        public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor) {
            PsiExpression defToInline;
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/sameParameterValue/SameParameterValueInspection$InlineParameterValueFix", "applyFix"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/codeInspection/sameParameterValue/SameParameterValueInspection$InlineParameterValueFix", "applyFix"));
            }
            PsiElement element = descriptor.getPsiElement();
            PsiMethod method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)element, PsiMethod.class);
            if (method == null) {
                return;
            }
            PsiParameter parameter = (PsiParameter)PsiTreeUtil.getParentOfType((PsiElement)element, PsiParameter.class, (boolean)false);
            if (parameter == null) {
                PsiParameter[] parameters2;
                for (PsiParameter psiParameter : parameters2 = method.getParameterList().getParameters()) {
                    if (!Comparing.strEqual((String)psiParameter.getName(), (String)this.myParameterName)) continue;
                    parameter = psiParameter;
                    break;
                }
            }
            if (parameter == null) {
                return;
            }
            if (!CommonRefactoringUtil.checkReadOnlyStatus((Project)project2, (PsiElement)parameter)) {
                return;
            }
            try {
                defToInline = JavaPsiFacade.getInstance((Project)project2).getElementFactory().createExpressionFromText(this.myValue, (PsiElement)parameter);
            }
            catch (IncorrectOperationException e) {
                return;
            }
            PsiParameter parameterToInline = parameter;
            InlineParameterValueFix.inlineSameParameterValue(method, parameterToInline, defToInline);
        }

        public boolean startInWriteAction() {
            return false;
        }

        public static void inlineSameParameterValue(PsiMethod method, PsiParameter parameter, PsiExpression defToInline) {
            MultiMap conflicts = new MultiMap();
            JavaSafeDeleteProcessor.collectMethodConflicts((MultiMap<PsiElement, String>)conflicts, method, parameter);
            if (!conflicts.isEmpty()) {
                if (ApplicationManager.getApplication().isUnitTestMode()) {
                    if (!BaseRefactoringProcessor.ConflictsInTestsException.isTestIgnore()) {
                        throw new BaseRefactoringProcessor.ConflictsInTestsException(conflicts.values());
                    }
                } else if (!new ConflictsDialog(parameter.getProject(), (MultiMap<PsiElement, String>)conflicts).showAndGet()) {
                    return;
                }
            }
            Collection refsToInline = ReferencesSearch.search((PsiElement)parameter).findAll();
            ApplicationManager.getApplication().runWriteAction(() -> {
                try {
                    PsiExpression[] exprs = new PsiExpression[refsToInline.size()];
                    int idx = 0;
                    for (PsiReference reference : refsToInline) {
                        if (!(reference instanceof PsiJavaCodeReferenceElement)) continue;
                        exprs[idx++] = InlineUtil.inlineVariable((PsiVariable)parameter, defToInline, (PsiJavaCodeReferenceElement)reference);
                    }
                    for (PsiExpression expr : exprs) {
                        if (expr == null) continue;
                        InlineUtil.tryToInlineArrayCreationForVarargs(expr);
                    }
                }
                catch (IncorrectOperationException e) {
                    LOG.error((Throwable)e);
                }
            });
            InlineParameterValueFix.removeParameter(method, parameter);
        }

        public static void removeParameter(PsiMethod method, PsiParameter parameter) {
            PsiParameter[] parameters2 = method.getParameterList().getParameters();
            ArrayList<ParameterInfoImpl> psiParameters = new ArrayList<ParameterInfoImpl>();
            int paramIdx = 0;
            String paramName = parameter.getName();
            for (PsiParameter param : parameters2) {
                if (!Comparing.strEqual((String)paramName, (String)param.getName())) {
                    psiParameters.add(new ParameterInfoImpl(paramIdx, param.getName(), param.getType()));
                }
                ++paramIdx;
            }
            new ChangeSignatureProcessor(method.getProject(), method, false, null, method.getName(), method.getReturnType(), psiParameters.toArray(new ParameterInfoImpl[psiParameters.size()])).run();
        }

        public String getValue() {
            return this.myValue;
        }

        public String getParamName() {
            return this.myParameterName;
        }
    }
}

