/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.streamMigration;

import com.intellij.codeInspection.streamMigration.BaseStreamApiMigration;
import com.intellij.codeInspection.streamMigration.StreamApiMigrationInspection;
import com.intellij.codeInspection.streamMigration.TerminalBlock;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import org.jetbrains.annotations.NotNull;

class CountMigration
extends BaseStreamApiMigration {
    CountMigration(boolean shouldWarn) {
        super(shouldWarn, "count()");
    }

    @Override
    PsiElement migrate(@NotNull Project project2, @NotNull PsiStatement body2, @NotNull TerminalBlock tb) {
        PsiExpression operand2;
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/streamMigration/CountMigration", "migrate"));
        }
        if (body2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "body", "com/intellij/codeInspection/streamMigration/CountMigration", "migrate"));
        }
        if (tb == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tb", "com/intellij/codeInspection/streamMigration/CountMigration", "migrate"));
        }
        PsiExpression expression2 = tb.getSingleExpression(PsiExpression.class);
        if (expression2 == null) {
            expression2 = tb.getCountExpression();
        }
        if (!((operand2 = StreamApiMigrationInspection.extractIncrementedLValue(expression2)) instanceof PsiReferenceExpression)) {
            return null;
        }
        PsiElement element = ((PsiReferenceExpression)operand2).resolve();
        if (!(element instanceof PsiLocalVariable)) {
            return null;
        }
        PsiLocalVariable var = (PsiLocalVariable)element;
        return CountMigration.replaceWithNumericAddition(tb.getMainLoop(), (PsiVariable)var, tb.generate() + ".count()", (PsiType)PsiType.LONG);
    }
}

