/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.testOnly;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.TestFrameworks;
import com.intellij.codeInspection.BaseJavaBatchLocalInspectionTool;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiImportStatementBase;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.impl.light.LightModifierList;
import com.intellij.psi.impl.source.resolve.JavaResolveUtil;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TestOnlyInspection
extends BaseJavaBatchLocalInspectionTool {
    @NotNull
    public String getDisplayName() {
        String string = InspectionsBundle.message((String)"inspection.test.only.problems.display.name", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/testOnly/TestOnlyInspection", "getDisplayName"));
        }
        return string;
    }

    @NotNull
    public String getShortName() {
        if ("TestOnlyProblems" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/testOnly/TestOnlyInspection", "getShortName"));
        }
        return "TestOnlyProblems";
    }

    @NotNull
    public String getGroupDisplayName() {
        String string = GENERAL_GROUP_NAME;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/testOnly/TestOnlyInspection", "getGroupDisplayName"));
        }
        return string;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder h, boolean isOnTheFly) {
        if (h == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "h", "com/intellij/codeInspection/testOnly/TestOnlyInspection", "buildVisitor"));
        }
        JavaElementVisitor javaElementVisitor = new JavaElementVisitor(){

            public void visitCallExpression(PsiCallExpression e) {
                TestOnlyInspection.validate((PsiElement)e, (PsiMember)e.resolveMethod(), h);
            }

            public void visitMethodReferenceExpression(PsiMethodReferenceExpression expression2) {
                PsiElement resolve2 = expression2.resolve();
                if (resolve2 instanceof PsiMethod) {
                    TestOnlyInspection.validate((PsiElement)expression2, (PsiMember)((PsiMethod)resolve2), h);
                }
            }

            public void visitReferenceExpression(PsiReferenceExpression reference) {
                PsiElement resolve2 = reference.resolve();
                if (resolve2 instanceof PsiField) {
                    TestOnlyInspection.validate((PsiElement)reference, (PsiMember)((PsiField)resolve2), h);
                }
            }

            public void visitReferenceElement(PsiJavaCodeReferenceElement reference) {
                if (reference.getParent() instanceof PsiNewExpression || reference.getParent() instanceof PsiAnonymousClass || PsiTreeUtil.getParentOfType((PsiElement)reference, PsiImportStatementBase.class) != null) {
                    return;
                }
                PsiElement resolve2 = reference.resolve();
                if (resolve2 instanceof PsiClass) {
                    TestOnlyInspection.validate((PsiElement)reference, (PsiMember)((PsiClass)resolve2), h);
                }
            }
        };
        if (javaElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/testOnly/TestOnlyInspection", "buildVisitor"));
        }
        return javaElementVisitor;
    }

    private static void validate(@NotNull PsiElement reference, @Nullable PsiMember member, ProblemsHolder h) {
        if (reference == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "com/intellij/codeInspection/testOnly/TestOnlyInspection", "validate"));
        }
        if (member == null || !TestOnlyInspection.isAnnotatedAsTestOnly(member)) {
            return;
        }
        if (TestOnlyInspection.isInsideTestOnlyMethod(reference)) {
            return;
        }
        if (TestOnlyInspection.isInsideTestOnlyField(reference)) {
            return;
        }
        if (TestOnlyInspection.isInsideTestClass(reference)) {
            return;
        }
        if (TestOnlyInspection.isUnderTestSources(reference)) {
            return;
        }
        PsiAnnotation anno = TestOnlyInspection.findVisibleForTestingAnnotation(member);
        if (anno != null) {
            String modifier = TestOnlyInspection.getAccessModifierWithoutTesting(anno);
            if (modifier == null) {
                modifier = member.hasModifierProperty("public") ? "protected" : (member.hasModifierProperty("protected") ? "packageLocal" : "private");
            }
            LightModifierList modList = new LightModifierList(member.getManager(), (Language)JavaLanguage.INSTANCE, modifier);
            if (JavaResolveUtil.isAccessible(member, member.getContainingClass(), modList, reference, null, null)) {
                return;
            }
        }
        TestOnlyInspection.reportProblem(reference, member, h);
    }

    @Nullable
    private static String getAccessModifierWithoutTesting(PsiAnnotation anno) {
        PsiElement target2;
        PsiAnnotationMemberValue ref = anno.findAttributeValue("visibility");
        if (ref instanceof PsiReferenceExpression && (target2 = ((PsiReferenceExpression)ref).resolve()) instanceof PsiEnumConstant) {
            String name2 = ((PsiEnumConstant)target2).getName();
            return "PRIVATE".equals(name2) ? "private" : ("PROTECTED".equals(name2) ? "protected" : "packageLocal");
        }
        return null;
    }

    @Nullable
    private static PsiAnnotation findVisibleForTestingAnnotation(@NotNull PsiMember member) {
        if (member == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "member", "com/intellij/codeInspection/testOnly/TestOnlyInspection", "findVisibleForTestingAnnotation"));
        }
        PsiAnnotation anno = AnnotationUtil.findAnnotation((PsiModifierListOwner)member, (String[])new String[]{"com.google.common.annotations.VisibleForTesting"});
        if (anno == null) {
            anno = AnnotationUtil.findAnnotation((PsiModifierListOwner)member, (String[])new String[]{"com.android.annotations.VisibleForTesting"});
        }
        if (anno != null) {
            return anno;
        }
        PsiClass containingClass = member.getContainingClass();
        return containingClass != null ? TestOnlyInspection.findVisibleForTestingAnnotation((PsiMember)containingClass) : null;
    }

    private static boolean isInsideTestOnlyMethod(PsiElement e) {
        return TestOnlyInspection.isAnnotatedAsTestOnly((PsiMember)TestOnlyInspection.getTopLevelParentOfType(e, PsiMethod.class));
    }

    private static boolean isInsideTestOnlyField(PsiElement e) {
        return TestOnlyInspection.isAnnotatedAsTestOnly((PsiMember)TestOnlyInspection.getTopLevelParentOfType(e, PsiField.class));
    }

    private static boolean isAnnotatedAsTestOnly(@Nullable PsiMember m) {
        if (m == null) {
            return false;
        }
        return AnnotationUtil.isAnnotated((PsiModifierListOwner)m, (String)"org.jetbrains.annotations.TestOnly", (boolean)false, (boolean)false) || TestOnlyInspection.findVisibleForTestingAnnotation(m) != null || TestOnlyInspection.isAnnotatedAsTestOnly((PsiMember)m.getContainingClass());
    }

    private static boolean isInsideTestClass(PsiElement e) {
        PsiClass c = TestOnlyInspection.getTopLevelParentOfType(e, PsiClass.class);
        return c != null && TestFrameworks.getInstance().isTestClass(c);
    }

    private static <T extends PsiElement> T getTopLevelParentOfType(PsiElement e, Class<T> c) {
        PsiElement parent = PsiTreeUtil.getParentOfType((PsiElement)e, c);
        if (parent == null) {
            return null;
        }
        PsiElement next;
        while ((next = PsiTreeUtil.getParentOfType((PsiElement)parent, c)) != null) {
            parent = next;
        }
        return (T)parent;
    }

    private static boolean isUnderTestSources(PsiElement e) {
        ProjectRootManager rm = ProjectRootManager.getInstance((Project)e.getProject());
        VirtualFile f = e.getContainingFile().getVirtualFile();
        return f != null && rm.getFileIndex().isInTestSourceContent(f);
    }

    private static void reportProblem(PsiElement e, PsiMember target2, ProblemsHolder h) {
        String message2 = InspectionsBundle.message((String)(target2 instanceof PsiClass ? "inspection.test.only.problems.test.only.class.reference" : (target2 instanceof PsiField ? "inspection.test.only.problems.test.only.field.reference" : "inspection.test.only.problems.test.only.method.call")), (Object[])new Object[0]);
        h.registerProblem(e, message2, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[0]);
    }
}

