/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ui;

import com.intellij.codeInspection.CustomSuppressableInspectionTool;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.SuppressIntentionAction;
import com.intellij.codeInspection.SuppressIntentionActionFromFix;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.lang.Language;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.util.containers.FactoryMap;
import com.intellij.util.containers.Interner;
import gnu.trove.THashMap;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InspectionViewSuppressActionHolder {
    private final Map<String, Map<ContextDescriptor, SuppressIntentionAction[]>> mySuppressActions = FactoryMap.createMap(__ -> new THashMap());
    private final Interner<Set<SuppressIntentionAction>> myActionSetInterner = new Interner();

    @NotNull
    public synchronized SuppressIntentionAction[] getSuppressActions(@NotNull InspectionToolWrapper wrapper, @NotNull PsiElement context) {
        if (wrapper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "wrapper", "com/intellij/codeInspection/ui/InspectionViewSuppressActionHolder", "getSuppressActions"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/codeInspection/ui/InspectionViewSuppressActionHolder", "getSuppressActions"));
        }
        ContextDescriptor descriptor = ContextDescriptor.from(context);
        if (descriptor == null) {
            if (SuppressIntentionAction.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ui/InspectionViewSuppressActionHolder", "getSuppressActions"));
            }
            return SuppressIntentionAction.EMPTY_ARRAY;
        }
        SuppressIntentionAction[] suppressIntentionActionArray = this.mySuppressActions.get(wrapper.getShortName()).computeIfAbsent(descriptor, __ -> {
            if (wrapper == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "wrapper", "com/intellij/codeInspection/ui/InspectionViewSuppressActionHolder", "lambda$getSuppressActions$3"));
            }
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/codeInspection/ui/InspectionViewSuppressActionHolder", "lambda$getSuppressActions$3"));
            }
            InspectionProfileEntry tool = wrapper.getTool();
            SuppressIntentionAction[] actions = tool instanceof CustomSuppressableInspectionTool ? ((CustomSuppressableInspectionTool)tool).getSuppressActions(null) : (SuppressIntentionAction[])Stream.of(tool.getBatchSuppressActions(context)).map(fix -> SuppressIntentionActionFromFix.convertBatchToSuppressIntentionAction(fix)).toArray(SuppressIntentionAction[]::new);
            return actions == null ? SuppressIntentionAction.EMPTY_ARRAY : actions;
        });
        if (suppressIntentionActionArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ui/InspectionViewSuppressActionHolder", "getSuppressActions"));
        }
        return suppressIntentionActionArray;
    }

    @NotNull
    public synchronized Set<SuppressIntentionAction> getSuppressActions(@NotNull InspectionToolWrapper wrapper) {
        if (wrapper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "wrapper", "com/intellij/codeInspection/ui/InspectionViewSuppressActionHolder", "getSuppressActions"));
        }
        Set<SuppressIntentionAction> set2 = this.mySuppressActions.get(wrapper.getShortName()).values().stream().flatMap(Arrays::stream).collect(Collectors.toSet());
        if (set2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ui/InspectionViewSuppressActionHolder", "getSuppressActions"));
        }
        return set2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<SuppressIntentionAction> internSuppressActions(@NotNull Set<SuppressIntentionAction> set2) {
        if (set2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "set", "com/intellij/codeInspection/ui/InspectionViewSuppressActionHolder", "internSuppressActions"));
        }
        Interner<Set<SuppressIntentionAction>> interner = this.myActionSetInterner;
        synchronized (interner) {
            return (Set)this.myActionSetInterner.intern(set2);
        }
    }

    private static class ContextDescriptor {
        @NotNull
        private final Language myElementLanguage;
        @NotNull
        private final Language myFileBaseLanguage;
        @NotNull
        private final Set<Language> myFileLanguages;
        @Nullable
        private final ContextDescriptor myInjectionDescriptor;

        private static ContextDescriptor from(@NotNull PsiElement element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInspection/ui/InspectionViewSuppressActionHolder$ContextDescriptor", "from"));
            }
            return ContextDescriptor.from(element, true);
        }

        private static ContextDescriptor from(@NotNull PsiElement element, boolean calculateInjectionDescriptor) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInspection/ui/InspectionViewSuppressActionHolder$ContextDescriptor", "from"));
            }
            PsiFile file2 = element.getContainingFile();
            if (file2 == null) {
                return null;
            }
            FileViewProvider provider = file2.getViewProvider();
            PsiLanguageInjectionHost injectionHost = InjectedLanguageManager.getInstance((Project)element.getProject()).getInjectionHost(element);
            ContextDescriptor injectionDescriptor = calculateInjectionDescriptor && injectionHost != null ? ContextDescriptor.from((PsiElement)injectionHost, false) : null;
            return new ContextDescriptor(element.getLanguage(), provider.getBaseLanguage(), provider.getLanguages(), injectionDescriptor);
        }

        private ContextDescriptor(@NotNull Language elementLanguage, @NotNull Language fileBaseLanguage, @NotNull Set<Language> languages, @Nullable ContextDescriptor descriptor) {
            if (elementLanguage == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementLanguage", "com/intellij/codeInspection/ui/InspectionViewSuppressActionHolder$ContextDescriptor", "<init>"));
            }
            if (fileBaseLanguage == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileBaseLanguage", "com/intellij/codeInspection/ui/InspectionViewSuppressActionHolder$ContextDescriptor", "<init>"));
            }
            if (languages == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "languages", "com/intellij/codeInspection/ui/InspectionViewSuppressActionHolder$ContextDescriptor", "<init>"));
            }
            this.myElementLanguage = elementLanguage;
            this.myFileBaseLanguage = fileBaseLanguage;
            this.myFileLanguages = languages;
            this.myInjectionDescriptor = descriptor;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ContextDescriptor that = (ContextDescriptor)o;
            if (!this.myElementLanguage.equals(that.myElementLanguage)) {
                return false;
            }
            if (!this.myFileBaseLanguage.equals(that.myFileBaseLanguage)) {
                return false;
            }
            if (!this.myFileLanguages.equals(that.myFileLanguages)) {
                return false;
            }
            return !(this.myInjectionDescriptor != null ? !this.myInjectionDescriptor.equals(that.myInjectionDescriptor) : that.myInjectionDescriptor != null);
        }

        public int hashCode() {
            int result2 = this.myElementLanguage.hashCode();
            result2 = 31 * result2 + this.myFileBaseLanguage.hashCode();
            result2 = 31 * result2 + this.myFileLanguages.hashCode();
            result2 = 31 * result2 + (this.myInjectionDescriptor != null ? this.myInjectionDescriptor.hashCode() : 0);
            return result2;
        }
    }
}

