/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ui;

import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.SuppressIntentionAction;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.ui.InspectionResultsView;
import com.intellij.codeInspection.ui.InspectionToolPresentation;
import com.intellij.codeInspection.ui.InspectionTreeNode;
import com.intellij.codeInspection.ui.InspectionViewSuppressActionHolder;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.TObjectHashingStrategy;
import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SuppressableInspectionTreeNode
extends InspectionTreeNode {
    @NotNull
    private final InspectionResultsView myView;
    @NotNull
    private final InspectionToolPresentation myPresentation;
    private volatile Set<SuppressIntentionAction> myAvailableSuppressActions;
    private volatile String myPresentableName;
    private volatile Boolean myValid;

    protected SuppressableInspectionTreeNode(Object userObject, @NotNull InspectionToolPresentation presentation) {
        if (presentation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "presentation", "com/intellij/codeInspection/ui/SuppressableInspectionTreeNode", "<init>"));
        }
        super(userObject);
        this.myView = presentation.getContext().getView();
        this.myPresentation = presentation;
    }

    @NotNull
    public InspectionToolPresentation getPresentation() {
        InspectionToolPresentation inspectionToolPresentation = this.myPresentation;
        if (inspectionToolPresentation == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ui/SuppressableInspectionTreeNode", "getPresentation"));
        }
        return inspectionToolPresentation;
    }

    public boolean canSuppress() {
        return this.isLeaf();
    }

    public final boolean isAlreadySuppressedFromView() {
        Object usrObj = this.getUserObject();
        return usrObj != null && this.myView.getSuppressedNodes(this.myPresentation.getToolWrapper().getShortName()).contains(usrObj);
    }

    public abstract boolean isQuickFixAppliedFromView();

    @NotNull
    public Set<SuppressIntentionAction> getAvailableSuppressActions() {
        Set<SuppressIntentionAction> set2 = this.myAvailableSuppressActions;
        if (set2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ui/SuppressableInspectionTreeNode", "getAvailableSuppressActions"));
        }
        return set2;
    }

    public void removeSuppressActionFromAvailable(@NotNull SuppressIntentionAction action) {
        if (action == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/codeInspection/ui/SuppressableInspectionTreeNode", "removeSuppressActionFromAvailable"));
        }
        this.myAvailableSuppressActions.remove(action);
    }

    protected void init(Project project2) {
        this.myPresentableName = this.calculatePresentableName();
        this.myValid = this.calculateIsValid();
        this.myAvailableSuppressActions = this.getElement() == null ? Collections.emptySet() : this.calculateAvailableSuppressActions(project2);
    }

    @Nullable
    public abstract RefEntity getElement();

    @Nullable
    public abstract CommonProblemDescriptor getDescriptor();

    @Override
    public final synchronized boolean isValid() {
        Boolean valid = this.myValid;
        if (valid == null) {
            this.myValid = valid = Boolean.valueOf(this.calculateIsValid());
        }
        return valid;
    }

    @Override
    public final synchronized String toString() {
        String name2 = this.myPresentableName;
        if (name2 == null) {
            this.myPresentableName = name2 = this.calculatePresentableName();
        }
        return name2;
    }

    @Override
    @Nullable
    public String getTailText() {
        if (!this.isValid()) {
            return "No longer valid";
        }
        return this.isAlreadySuppressedFromView() ? "Suppressed" : null;
    }

    @NotNull
    public final Pair<PsiElement, CommonProblemDescriptor> getSuppressContent() {
        RefEntity refElement = this.getElement();
        CommonProblemDescriptor descriptor = this.getDescriptor();
        PsiElement element = descriptor instanceof ProblemDescriptor ? ((ProblemDescriptor)descriptor).getPsiElement() : (refElement instanceof RefElement ? ((RefElement)refElement).getElement() : null);
        Pair pair2 = Pair.create((Object)element, (Object)descriptor);
        if (pair2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ui/SuppressableInspectionTreeNode", "getSuppressContent"));
        }
        return pair2;
    }

    @NotNull
    private Set<SuppressIntentionAction> calculateAvailableSuppressActions(@NotNull Project project2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/ui/SuppressableInspectionTreeNode", "calculateAvailableSuppressActions"));
        }
        if (this.myPresentation.isDummy()) {
            Set<SuppressIntentionAction> set2 = Collections.emptySet();
            if (set2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ui/SuppressableInspectionTreeNode", "calculateAvailableSuppressActions"));
            }
            return set2;
        }
        Pair<PsiElement, CommonProblemDescriptor> suppressContent = this.getSuppressContent();
        PsiElement element = (PsiElement)suppressContent.getFirst();
        if (element == null) {
            Set<SuppressIntentionAction> set3 = Collections.emptySet();
            if (set3 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ui/SuppressableInspectionTreeNode", "calculateAvailableSuppressActions"));
            }
            return set3;
        }
        InspectionViewSuppressActionHolder suppressActionHolder = this.myView.getSuppressActionHolder();
        SuppressIntentionAction[] actions = suppressActionHolder.getSuppressActions(this.myPresentation.getToolWrapper(), element);
        if (actions.length == 0) {
            Set<SuppressIntentionAction> set4 = Collections.emptySet();
            if (set4 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ui/SuppressableInspectionTreeNode", "calculateAvailableSuppressActions"));
            }
            return set4;
        }
        Set<SuppressIntentionAction> set5 = suppressActionHolder.internSuppressActions(Arrays.stream(actions).filter(action -> {
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/ui/SuppressableInspectionTreeNode", "lambda$calculateAvailableSuppressActions$0"));
            }
            return action.isAvailable(project2, null, element);
        }).collect(Collectors.toCollection(() -> ContainerUtil.newConcurrentSet((TObjectHashingStrategy)ContainerUtil.identityStrategy()))));
        if (set5 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ui/SuppressableInspectionTreeNode", "calculateAvailableSuppressActions"));
        }
        return set5;
    }

    protected abstract String calculatePresentableName();

    protected abstract boolean calculateIsValid();

    protected void dropCache(Project project2) {
        this.myValid = this.calculateIsValid();
        this.myPresentableName = this.calculatePresentableName();
        for (int i2 = 0; i2 < this.getChildCount(); ++i2) {
            TreeNode child = this.getChildAt(i2);
            if (!(child instanceof SuppressableInspectionTreeNode)) continue;
            ((SuppressableInspectionTreeNode)child).dropCache(project2);
        }
    }
}

