/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.visibility;

import com.intellij.analysis.AnalysisScope;
import com.intellij.codeInsight.daemon.GroupNames;
import com.intellij.codeInsight.daemon.impl.IdentifierUtil;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.GlobalJavaBatchInspectionTool;
import com.intellij.codeInspection.GlobalJavaInspectionContext;
import com.intellij.codeInspection.HTMLComposer;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptionsProcessor;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.QuickFix;
import com.intellij.codeInspection.ex.EntryPointsManager;
import com.intellij.codeInspection.reference.EntryPoint;
import com.intellij.codeInspection.reference.RefClass;
import com.intellij.codeInspection.reference.RefClassImpl;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefField;
import com.intellij.codeInspection.reference.RefImplicitConstructor;
import com.intellij.codeInspection.reference.RefJavaElement;
import com.intellij.codeInspection.reference.RefJavaElementImpl;
import com.intellij.codeInspection.reference.RefJavaUtil;
import com.intellij.codeInspection.reference.RefJavaVisitor;
import com.intellij.codeInspection.reference.RefManager;
import com.intellij.codeInspection.reference.RefMethod;
import com.intellij.codeInspection.reference.RefParameter;
import com.intellij.codeInspection.reference.RefVisitor;
import com.intellij.codeInspection.visibility.AccessCanBeTightenedInspection;
import com.intellij.codeInspection.visibility.EntryPointWithVisibilityLevel;
import com.intellij.codeInspection.visibility.VisibilityExtension;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.psi.ElementDescriptionLocation;
import com.intellij.psi.ElementDescriptionUtil;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifier;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.ui.components.panels.VerticalBox;
import com.intellij.usageView.UsageViewTypeLocation;
import com.intellij.util.VisibilityUtil;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VisibilityInspection
extends GlobalJavaBatchInspectionTool {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInspection.visibility.VisibilityInspection");
    public boolean SUGGEST_PACKAGE_LOCAL_FOR_MEMBERS = true;
    public boolean SUGGEST_PACKAGE_LOCAL_FOR_TOP_CLASSES = true;
    public boolean SUGGEST_PRIVATE_FOR_INNERS;
    private final Map<String, Boolean> myExtensions = new TreeMap<String, Boolean>();
    private static final String DISPLAY_NAME = InspectionsBundle.message((String)"inspection.visibility.display.name", (Object[])new Object[0]);
    @NonNls
    public static final String SHORT_NAME = "WeakerAccess";
    private static final String CAN_BE_PRIVATE = InspectionsBundle.message((String)"inspection.visibility.compose.suggestion", (Object[])new Object[]{VisibilityUtil.toPresentableText((String)"private")});
    private static final String CAN_BE_PACKAGE_LOCAL = InspectionsBundle.message((String)"inspection.visibility.compose.suggestion", (Object[])new Object[]{VisibilityUtil.toPresentableText((String)"packageLocal")});
    private static final String CAN_BE_PROTECTED = InspectionsBundle.message((String)"inspection.visibility.compose.suggestion", (Object[])new Object[]{VisibilityUtil.toPresentableText((String)"protected")});

    public JComponent createOptionsPanel() {
        return new OptionsPanel();
    }

    @Nullable
    public LocalInspectionTool getSharedLocalInspectionTool() {
        return new AccessCanBeTightenedInspection(this);
    }

    @NotNull
    public String getDisplayName() {
        String string = DISPLAY_NAME;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/visibility/VisibilityInspection", "getDisplayName"));
        }
        return string;
    }

    @NotNull
    public String getGroupDisplayName() {
        String string = GroupNames.DECLARATION_REDUNDANCY;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/visibility/VisibilityInspection", "getGroupDisplayName"));
        }
        return string;
    }

    @NotNull
    public String getShortName() {
        if (SHORT_NAME == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/visibility/VisibilityInspection", "getShortName"));
        }
        return SHORT_NAME;
    }

    @Nullable
    public CommonProblemDescriptor[] checkElement(@NotNull RefEntity refEntity, @NotNull AnalysisScope scope, @NotNull InspectionManager manager, @NotNull GlobalInspectionContext globalContext, @NotNull ProblemDescriptionsProcessor processor2) {
        RefClass refClass;
        RefMethod refMethod;
        Boolean isEnumConstant;
        if (refEntity == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refEntity", "com/intellij/codeInspection/visibility/VisibilityInspection", "checkElement"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/codeInspection/visibility/VisibilityInspection", "checkElement"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/codeInspection/visibility/VisibilityInspection", "checkElement"));
        }
        if (globalContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "globalContext", "com/intellij/codeInspection/visibility/VisibilityInspection", "checkElement"));
        }
        if (processor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/codeInspection/visibility/VisibilityInspection", "checkElement"));
        }
        if (!(refEntity instanceof RefJavaElement)) {
            return null;
        }
        RefJavaElement refElement = (RefJavaElement)refEntity;
        if (refElement instanceof RefParameter) {
            return null;
        }
        if (refElement.isSyntheticJSP()) {
            return null;
        }
        int minLevel = -1;
        if (refElement.isEntry() && (minLevel = this.getMinVisibilityLevel(refElement)) <= 0) {
            return null;
        }
        if (refElement instanceof RefImplicitConstructor) {
            return null;
        }
        if (refElement instanceof RefField && (isEnumConstant = (Boolean)refElement.getUserData(RefField.ENUM_CONSTANT)) != null && isEnumConstant.booleanValue()) {
            return null;
        }
        if (refElement instanceof RefMethod && (refMethod = (RefMethod)refElement).isExternalOverride()) {
            return null;
        }
        if (refElement instanceof RefClass && ((refClass = (RefClass)refElement).isAnonymous() || refClass.isServlet() || refClass.isApplet() || refClass.isLocalClass())) {
            return null;
        }
        if (refElement.getInReferences().isEmpty()) {
            if (minLevel <= 0 && (minLevel = this.getMinVisibilityLevel(refElement)) <= 0) {
                return null;
            }
            String weakestAccess = PsiUtil.getAccessModifier((int)minLevel);
            if (weakestAccess != refElement.getAccessModifier()) {
                return VisibilityInspection.createDescriptions((RefElement)refElement, weakestAccess, manager, globalContext);
            }
        }
        if (refElement instanceof RefClass && VisibilityInspection.isTopLevelClass((RefElement)refElement) && minLevel <= 0 && !this.SUGGEST_PACKAGE_LOCAL_FOR_TOP_CLASSES) {
            return null;
        }
        if (refElement.getOwner() instanceof RefClass && (refClass = (RefClass)refElement.getOwner()).isInterface()) {
            return null;
        }
        String access = this.getPossibleAccess(refElement, minLevel <= 0 ? 1 : minLevel);
        if (access != refElement.getAccessModifier() && access != null) {
            return VisibilityInspection.createDescriptions((RefElement)refElement, access, manager, globalContext);
        }
        return null;
    }

    @NotNull
    private static CommonProblemDescriptor[] createDescriptions(RefElement refElement, String access, @NotNull InspectionManager manager, @NotNull GlobalInspectionContext globalContext) {
        PsiElement nameIdentifier;
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/codeInspection/visibility/VisibilityInspection", "createDescriptions"));
        }
        if (globalContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "globalContext", "com/intellij/codeInspection/visibility/VisibilityInspection", "createDescriptions"));
        }
        PsiElement element = refElement.getElement();
        PsiElement psiElement = nameIdentifier = element != null ? IdentifierUtil.getNameIdentifier(element) : null;
        if (nameIdentifier != null) {
            String message2;
            String quickFixName = "Make " + ElementDescriptionUtil.getElementDescription((PsiElement)element, (ElementDescriptionLocation)UsageViewTypeLocation.INSTANCE) + " ";
            if (access.equals("private")) {
                message2 = CAN_BE_PRIVATE;
                quickFixName = quickFixName + VisibilityUtil.toPresentableText((String)"private");
            } else if (access.equals("packageLocal")) {
                message2 = CAN_BE_PACKAGE_LOCAL;
                quickFixName = quickFixName + VisibilityUtil.toPresentableText((String)"packageLocal");
            } else {
                message2 = CAN_BE_PROTECTED;
                quickFixName = quickFixName + VisibilityUtil.toPresentableText((String)"protected");
            }
            ProblemDescriptor[] problemDescriptorArray = new ProblemDescriptor[]{manager.createProblemDescriptor(nameIdentifier, message2, (LocalQuickFix)new AcceptSuggestedAccess(globalContext.getRefManager(), access, quickFixName), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, false)};
            if (problemDescriptorArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/visibility/VisibilityInspection", "createDescriptions"));
            }
            return problemDescriptorArray;
        }
        if (CommonProblemDescriptor.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/visibility/VisibilityInspection", "createDescriptions"));
        }
        return CommonProblemDescriptor.EMPTY_ARRAY;
    }

    int getMinVisibilityLevel(PsiMember member) {
        return Arrays.stream(ExtensionPointName.create((String)"com.intellij.deadCode").getExtensions()).filter(point -> point instanceof EntryPointWithVisibilityLevel && this.myExtensions.getOrDefault(((EntryPointWithVisibilityLevel)((Object)point)).getId(), true) != false).mapToInt(point -> ((EntryPointWithVisibilityLevel)((Object)point)).getMinVisibilityLevel(member)).max().orElse(-1);
    }

    private int getMinVisibilityLevel(RefJavaElement refElement) {
        PsiElement element = refElement.getElement();
        if (element instanceof PsiMember) {
            return this.getMinVisibilityLevel((PsiMember)element);
        }
        return -1;
    }

    @Nullable
    @PsiModifier.ModifierConstant
    private String getPossibleAccess(@NotNull RefJavaElement refElement, int minLevel) {
        String weakerAccess;
        if (refElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refElement", "com/intellij/codeInspection/visibility/VisibilityInspection", "getPossibleAccess"));
        }
        String curAccess = refElement.getAccessModifier();
        String weakestAccess = PsiUtil.getAccessModifier((int)minLevel);
        if (VisibilityInspection.isTopLevelClass((RefElement)refElement) || VisibilityInspection.isCalledOnSubClasses((RefElement)refElement)) {
            weakestAccess = "packageLocal";
        }
        if (VisibilityInspection.isAbstractMethod((RefElement)refElement)) {
            weakestAccess = "protected";
        }
        if (curAccess == weakestAccess) {
            return curAccess;
        }
        while ((weakerAccess = this.getWeakerAccess(curAccess, (RefElement)refElement)) != null && RefJavaUtil.getInstance().compareAccess(weakerAccess, weakestAccess) >= 0 && this.isAccessible(refElement, weakerAccess)) {
            curAccess = weakerAccess;
        }
        return curAccess;
    }

    private static boolean isCalledOnSubClasses(RefElement refElement) {
        return refElement instanceof RefMethod && ((RefMethod)refElement).isCalledOnSubClass();
    }

    private static boolean isAbstractMethod(RefElement refElement) {
        return refElement instanceof RefMethod && ((RefMethod)refElement).isAbstract();
    }

    private static boolean isTopLevelClass(RefElement refElement) {
        return refElement instanceof RefClass && RefJavaUtil.getInstance().getTopLevelClass(refElement) == refElement;
    }

    @Nullable
    @PsiModifier.ModifierConstant
    private String getWeakerAccess(@PsiModifier.ModifierConstant String curAccess, RefElement refElement) {
        if (curAccess == "public") {
            return VisibilityInspection.isTopLevelClass(refElement) ? "packageLocal" : "protected";
        }
        if (curAccess == "protected") {
            return this.SUGGEST_PACKAGE_LOCAL_FOR_MEMBERS ? "packageLocal" : "private";
        }
        if (curAccess == "packageLocal") {
            return "private";
        }
        return null;
    }

    private boolean isAccessible(RefJavaElement to, @PsiModifier.ModifierConstant String accessModifier) {
        for (Object refElement : to.getInReferences()) {
            if (this.isAccessibleFrom((RefElement)refElement, to, accessModifier)) continue;
            return false;
        }
        if (to instanceof RefMethod) {
            RefMethod refMethod = (RefMethod)to;
            if (refMethod.isAbstract() && (refMethod.getDerivedMethods().isEmpty() || refMethod.getAccessModifier() == "private")) {
                return false;
            }
            for (RefMethod refOverride : refMethod.getDerivedMethods()) {
                if (this.isAccessibleFrom((RefElement)refOverride, to, accessModifier)) continue;
                return false;
            }
            for (RefMethod refSuper : refMethod.getSuperMethods()) {
                if (RefJavaUtil.getInstance().compareAccess(refSuper.getAccessModifier(), accessModifier) <= 0) continue;
                return false;
            }
        }
        if (to instanceof RefClass) {
            RefClass refClass = (RefClass)to;
            for (Object subClass : refClass.getSubClasses()) {
                if (this.isAccessibleFrom((RefElement)subClass, to, accessModifier)) continue;
                return false;
            }
            List children2 = refClass.getChildren();
            for (Object refElement : children2) {
                if (this.isAccessible((RefJavaElement)refElement, accessModifier)) continue;
                return false;
            }
            for (Object refElement : refClass.getInTypeReferences()) {
                if (this.isAccessibleFrom((RefElement)refElement, (RefJavaElement)refClass, accessModifier)) continue;
                return false;
            }
            List<RefJavaElement> classExporters = ((RefClassImpl)refClass).getClassExporters();
            if (classExporters != null) {
                for (RefJavaElement refExporter : classExporters) {
                    if (VisibilityInspection.getAccessLevel(accessModifier) >= VisibilityInspection.getAccessLevel(refExporter.getAccessModifier())) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private static int getAccessLevel(@PsiModifier.ModifierConstant String access) {
        if (access == "private") {
            return 1;
        }
        if (access == "packageLocal") {
            return 2;
        }
        if (access == "protected") {
            return 3;
        }
        return 4;
    }

    private boolean isAccessibleFrom(RefElement from, RefJavaElement to, String accessModifier) {
        if (accessModifier == "public") {
            return true;
        }
        RefJavaUtil refUtil = RefJavaUtil.getInstance();
        if (accessModifier == "packageLocal") {
            return RefJavaUtil.getPackage((RefEntity)from) == RefJavaUtil.getPackage((RefEntity)to);
        }
        RefClass fromTopLevel = refUtil.getTopLevelClass(from);
        RefClass toTopLevel = refUtil.getTopLevelClass((RefElement)to);
        RefClass fromOwner = refUtil.getOwnerClass(from);
        RefClass toOwner = refUtil.getOwnerClass((RefElement)to);
        if (accessModifier == "protected") {
            if (to instanceof RefJavaElementImpl && ((RefJavaElementImpl)to).isUsedQualifiedOutsidePackage()) {
                return false;
            }
            return fromTopLevel != null && refUtil.isInheritor(fromTopLevel, toOwner) || fromOwner != null && refUtil.isInheritor(fromOwner, toTopLevel) || toTopLevel != null && toTopLevel == fromTopLevel;
        }
        if (accessModifier == "private") {
            if (this.SUGGEST_PRIVATE_FOR_INNERS) {
                PsiClass fromTopLevelElement;
                PsiClass psiClass = fromTopLevelElement = fromTopLevel != null ? fromTopLevel.getElement() : null;
                if (fromTopLevelElement != null && VisibilityInspection.isInExtendsList(to, fromTopLevelElement.getExtendsList())) {
                    return false;
                }
                if (fromTopLevelElement != null && VisibilityInspection.isInExtendsList(to, fromTopLevelElement.getImplementsList())) {
                    return false;
                }
                if (fromTopLevelElement != null && VisibilityInspection.isInAnnotations(to, fromTopLevelElement)) {
                    return false;
                }
                return fromTopLevel == toOwner || fromOwner == toTopLevel || toOwner != null && (refUtil.getOwnerClass((RefElement)toOwner) == from || from instanceof RefMethod && toOwner == ((RefMethod)from).getOwnerClass() || from instanceof RefField && toOwner == ((RefField)from).getOwnerClass());
            }
            if (fromOwner != null && fromOwner.isStatic() && !to.isStatic() && refUtil.isInheritor(fromOwner, toOwner)) {
                return false;
            }
            if (fromTopLevel == toOwner) {
                if (from instanceof RefClass && to instanceof RefClass) {
                    PsiClass fromClass = ((RefClass)from).getElement();
                    LOG.assertTrue(fromClass != null);
                    if (VisibilityInspection.isInExtendsList(to, fromClass.getExtendsList())) {
                        return false;
                    }
                    if (VisibilityInspection.isInExtendsList(to, fromClass.getImplementsList())) {
                        return false;
                    }
                }
                return true;
            }
        }
        return false;
    }

    private static boolean isInAnnotations(RefJavaElement to, @NotNull PsiClass fromTopLevelElement) {
        if (fromTopLevelElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fromTopLevelElement", "com/intellij/codeInspection/visibility/VisibilityInspection", "isInAnnotations"));
        }
        PsiModifierList modifierList = fromTopLevelElement.getModifierList();
        if (modifierList == null) {
            return false;
        }
        final PsiElement toElement = to.getElement();
        final boolean[] resolved = new boolean[]{false};
        modifierList.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

            public void visitReferenceExpression(PsiReferenceExpression expression2) {
                if (resolved[0]) {
                    return;
                }
                super.visitReferenceExpression(expression2);
                if (expression2.resolve() == toElement) {
                    resolved[0] = true;
                }
            }
        });
        return resolved[0];
    }

    private static boolean isInExtendsList(RefJavaElement to, PsiReferenceList extendsList) {
        if (extendsList != null) {
            PsiJavaCodeReferenceElement[] referenceElements;
            for (PsiJavaCodeReferenceElement referenceElement : referenceElements = extendsList.getReferenceElements()) {
                PsiReferenceParameterList parameterList = referenceElement.getParameterList();
                if (parameterList == null) continue;
                for (PsiType type2 : parameterList.getTypeArguments()) {
                    if (!extendsList.getManager().areElementsEquivalent((PsiElement)PsiUtil.resolveClassInType((PsiType)type2), to.getElement())) continue;
                    return true;
                }
            }
        }
        return false;
    }

    protected boolean queryExternalUsagesRequests(final @NotNull RefManager manager, final @NotNull GlobalJavaInspectionContext globalContext, final @NotNull ProblemDescriptionsProcessor processor2) {
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/codeInspection/visibility/VisibilityInspection", "queryExternalUsagesRequests"));
        }
        if (globalContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "globalContext", "com/intellij/codeInspection/visibility/VisibilityInspection", "queryExternalUsagesRequests"));
        }
        if (processor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/codeInspection/visibility/VisibilityInspection", "queryExternalUsagesRequests"));
        }
        final EntryPointsManager entryPointsManager = globalContext.getEntryPointsManager(manager);
        for (RefElement entryPoint : entryPointsManager.getEntryPoints()) {
            if (entryPoint instanceof RefJavaElement && this.getMinVisibilityLevel((RefJavaElement)entryPoint) > 0) continue;
            VisibilityInspection.ignoreElement(processor2, (RefEntity)entryPoint);
        }
        ExtensionPoint point = Extensions.getRootArea().getExtensionPoint("com.intellij.visibility");
        for (VisibilityExtension addin : (VisibilityExtension[])point.getExtensions()) {
            addin.fillIgnoreList(manager, processor2);
        }
        manager.iterate((RefVisitor)new RefJavaVisitor(){

            public void visitElement(@NotNull RefEntity refEntity) {
                if (refEntity == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refEntity", "com/intellij/codeInspection/visibility/VisibilityInspection$2", "visitElement"));
                }
                if (!(refEntity instanceof RefElement)) {
                    return;
                }
                if (processor2.getDescriptions(refEntity) == null) {
                    return;
                }
                refEntity.accept((RefVisitor)new RefJavaVisitor(){

                    public void visitField(@NotNull RefField refField) {
                        if (refField == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refField", "com/intellij/codeInspection/visibility/VisibilityInspection$2$1", "visitField"));
                        }
                        if (refField.getAccessModifier() != "private") {
                            globalContext.enqueueFieldUsagesProcessor(refField, psiReference -> {
                                if (processor2 == null) {
                                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/codeInspection/visibility/VisibilityInspection$2$1", "lambda$visitField$0"));
                                }
                                if (refField == null) {
                                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refField", "com/intellij/codeInspection/visibility/VisibilityInspection$2$1", "lambda$visitField$0"));
                                }
                                VisibilityInspection.ignoreElement(processor2, (RefEntity)refField);
                                return false;
                            });
                        }
                    }

                    public void visitMethod(@NotNull RefMethod refMethod) {
                        if (refMethod == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refMethod", "com/intellij/codeInspection/visibility/VisibilityInspection$2$1", "visitMethod"));
                        }
                        if (!refMethod.isExternalOverride() && refMethod.getAccessModifier() != "private" && !(refMethod instanceof RefImplicitConstructor)) {
                            globalContext.enqueueDerivedMethodsProcessor(refMethod, derivedMethod -> {
                                if (processor2 == null) {
                                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/codeInspection/visibility/VisibilityInspection$2$1", "lambda$visitMethod$1"));
                                }
                                if (refMethod == null) {
                                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refMethod", "com/intellij/codeInspection/visibility/VisibilityInspection$2$1", "lambda$visitMethod$1"));
                                }
                                VisibilityInspection.ignoreElement(processor2, (RefEntity)refMethod);
                                return false;
                            });
                            globalContext.enqueueMethodUsagesProcessor(refMethod, psiReference -> {
                                if (processor2 == null) {
                                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/codeInspection/visibility/VisibilityInspection$2$1", "lambda$visitMethod$2"));
                                }
                                if (refMethod == null) {
                                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refMethod", "com/intellij/codeInspection/visibility/VisibilityInspection$2$1", "lambda$visitMethod$2"));
                                }
                                VisibilityInspection.ignoreElement(processor2, (RefEntity)refMethod);
                                return false;
                            });
                        }
                    }

                    public void visitClass(@NotNull RefClass refClass) {
                        if (refClass == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refClass", "com/intellij/codeInspection/visibility/VisibilityInspection$2$1", "visitClass"));
                        }
                        if (!refClass.isAnonymous()) {
                            globalContext.enqueueDerivedClassesProcessor(refClass, inheritor -> {
                                if (processor2 == null) {
                                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/codeInspection/visibility/VisibilityInspection$2$1", "lambda$visitClass$3"));
                                }
                                if (refClass == null) {
                                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refClass", "com/intellij/codeInspection/visibility/VisibilityInspection$2$1", "lambda$visitClass$3"));
                                }
                                VisibilityInspection.ignoreElement(processor2, (RefEntity)refClass);
                                return false;
                            });
                            globalContext.enqueueClassUsagesProcessor(refClass, psiReference -> {
                                if (processor2 == null) {
                                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/codeInspection/visibility/VisibilityInspection$2$1", "lambda$visitClass$4"));
                                }
                                if (refClass == null) {
                                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refClass", "com/intellij/codeInspection/visibility/VisibilityInspection$2$1", "lambda$visitClass$4"));
                                }
                                VisibilityInspection.ignoreElement(processor2, (RefEntity)refClass);
                                return false;
                            });
                            RefMethod defaultConstructor = refClass.getDefaultConstructor();
                            if (entryPointsManager.isAddNonJavaEntries() && defaultConstructor != null) {
                                String qualifiedName;
                                PsiClass psiClass = refClass.getElement();
                                String string = qualifiedName = psiClass != null ? psiClass.getQualifiedName() : null;
                                if (qualifiedName != null) {
                                    Project project2 = manager.getProject();
                                    PsiSearchHelper.SERVICE.getInstance((Project)project2).processUsagesInNonJavaFiles(qualifiedName, (file2, startOffset, endOffset) -> {
                                        if (processor2 == null) {
                                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/codeInspection/visibility/VisibilityInspection$2$1", "lambda$visitClass$5"));
                                        }
                                        entryPointsManager.addEntryPoint((RefElement)defaultConstructor, false);
                                        VisibilityInspection.ignoreElement(processor2, (RefEntity)defaultConstructor);
                                        return false;
                                    }, GlobalSearchScope.projectScope((Project)project2));
                                }
                            }
                        }
                    }
                });
            }
        });
        return false;
    }

    private static void ignoreElement(@NotNull ProblemDescriptionsProcessor processor2, @NotNull RefEntity refElement) {
        RefClass refClass;
        RefMethod defaultConstructor;
        if (processor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/codeInspection/visibility/VisibilityInspection", "ignoreElement"));
        }
        if (refElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refElement", "com/intellij/codeInspection/visibility/VisibilityInspection", "ignoreElement"));
        }
        processor2.ignoreElement(refElement);
        if (refElement instanceof RefClass && (defaultConstructor = (refClass = (RefClass)refElement).getDefaultConstructor()) != null) {
            processor2.ignoreElement((RefEntity)defaultConstructor);
            return;
        }
        RefEntity owner2 = refElement.getOwner();
        if (owner2 instanceof RefElement) {
            processor2.ignoreElement(owner2);
        }
    }

    public void compose(@NotNull StringBuffer buf, @NotNull RefEntity refEntity, @NotNull HTMLComposer composer) {
        if (buf == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buf", "com/intellij/codeInspection/visibility/VisibilityInspection", "compose"));
        }
        if (refEntity == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refEntity", "com/intellij/codeInspection/visibility/VisibilityInspection", "compose"));
        }
        if (composer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "composer", "com/intellij/codeInspection/visibility/VisibilityInspection", "compose"));
        }
        composer.appendElementInReferences(buf, (RefElement)refEntity);
    }

    @Nullable
    public QuickFix getQuickFix(String hint) {
        return new AcceptSuggestedAccess(null, hint, null);
    }

    @Nullable
    public String getHint(@NotNull QuickFix fix) {
        if (fix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fix", "com/intellij/codeInspection/visibility/VisibilityInspection", "getHint"));
        }
        return ((AcceptSuggestedAccess)fix).myHint;
    }

    public void writeSettings(@NotNull Element node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/codeInspection/visibility/VisibilityInspection", "writeSettings"));
        }
        super.writeSettings(node);
        for (Map.Entry<String, Boolean> entry : this.myExtensions.entrySet()) {
            if (entry.getValue().booleanValue()) continue;
            node.addContent(new Element("disabledExtension").setAttribute("id", entry.getKey()));
        }
    }

    public void readSettings(@NotNull Element node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/codeInspection/visibility/VisibilityInspection", "readSettings"));
        }
        super.readSettings(node);
        for (Element extension : node.getChildren("disabledExtension")) {
            String id = extension.getAttributeValue("id");
            if (id == null) continue;
            this.myExtensions.put(id, false);
        }
    }

    private static class AcceptSuggestedAccess
    implements LocalQuickFix {
        private final RefManager myManager;
        @PsiModifier.ModifierConstant
        private final String myHint;
        private final String myName;

        private AcceptSuggestedAccess(RefManager manager, @PsiModifier.ModifierConstant String hint, String name2) {
            this.myManager = manager;
            this.myHint = hint;
            this.myName = name2;
        }

        @NotNull
        public String getName() {
            String string = this.myName != null ? this.myName : this.getFamilyName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/visibility/VisibilityInspection$AcceptSuggestedAccess", "getName"));
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionsBundle.message((String)"inspection.visibility.accept.quickfix", (Object[])new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/visibility/VisibilityInspection$AcceptSuggestedAccess", "getFamilyName"));
            }
            return string;
        }

        public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor) {
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/visibility/VisibilityInspection$AcceptSuggestedAccess", "applyFix"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/codeInspection/visibility/VisibilityInspection$AcceptSuggestedAccess", "applyFix"));
            }
            PsiModifierListOwner element = (PsiModifierListOwner)PsiTreeUtil.getParentOfType((PsiElement)descriptor.getPsiElement(), PsiModifierListOwner.class);
            if (element != null) {
                PsiMethod psiMethod;
                PsiClass containingClass;
                RefElement refElement = null;
                if (this.myManager != null) {
                    refElement = this.myManager.getReference((PsiElement)element);
                }
                if (element instanceof PsiVariable) {
                    ((PsiVariable)element).normalizeDeclaration();
                }
                PsiModifierList list2 = element.getModifierList();
                LOG.assertTrue(list2 != null);
                if (element instanceof PsiMethod && (containingClass = (psiMethod = (PsiMethod)element).getContainingClass()) != null && containingClass.getParent() instanceof PsiFile && this.myHint == "private" && list2.hasModifierProperty("final")) {
                    list2.setModifierProperty("final", false);
                }
                list2.setModifierProperty(this.myHint, true);
                if (refElement instanceof RefJavaElement) {
                    RefJavaUtil.getInstance().setAccessModifier((RefJavaElement)refElement, this.myHint);
                }
            }
        }
    }

    private class OptionsPanel
    extends JPanel {
        private final JCheckBox myPackageLocalForMembersCheckbox;
        private final JCheckBox myPrivateForInnersCheckbox;
        private final JCheckBox myPackageLocalForTopClassesCheckbox;

        private OptionsPanel() {
            super(new GridBagLayout());
            GridBagConstraints gc = new GridBagConstraints();
            gc.fill = 2;
            gc.weightx = 1.0;
            gc.weighty = 0.0;
            gc.anchor = 18;
            this.myPackageLocalForMembersCheckbox = new JCheckBox(InspectionsBundle.message((String)"inspection.visibility.option", (Object[])new Object[0]));
            this.myPackageLocalForMembersCheckbox.setSelected(VisibilityInspection.this.SUGGEST_PACKAGE_LOCAL_FOR_MEMBERS);
            this.myPackageLocalForMembersCheckbox.getModel().addItemListener(e -> {
                VisibilityInspection.this.SUGGEST_PACKAGE_LOCAL_FOR_MEMBERS = this.myPackageLocalForMembersCheckbox.isSelected();
            });
            gc.gridy = 0;
            this.add((Component)this.myPackageLocalForMembersCheckbox, gc);
            this.myPackageLocalForTopClassesCheckbox = new JCheckBox(InspectionsBundle.message((String)"inspection.visibility.option1", (Object[])new Object[0]));
            this.myPackageLocalForTopClassesCheckbox.setSelected(VisibilityInspection.this.SUGGEST_PACKAGE_LOCAL_FOR_TOP_CLASSES);
            this.myPackageLocalForTopClassesCheckbox.getModel().addItemListener(e -> {
                VisibilityInspection.this.SUGGEST_PACKAGE_LOCAL_FOR_TOP_CLASSES = this.myPackageLocalForTopClassesCheckbox.isSelected();
            });
            gc.gridy = 1;
            this.add((Component)this.myPackageLocalForTopClassesCheckbox, gc);
            this.myPrivateForInnersCheckbox = new JCheckBox(InspectionsBundle.message((String)"inspection.visibility.option2", (Object[])new Object[0]));
            this.myPrivateForInnersCheckbox.setSelected(VisibilityInspection.this.SUGGEST_PRIVATE_FOR_INNERS);
            this.myPrivateForInnersCheckbox.getModel().addItemListener(e -> {
                VisibilityInspection.this.SUGGEST_PRIVATE_FOR_INNERS = this.myPrivateForInnersCheckbox.isSelected();
            });
            gc.gridy = 2;
            this.add((Component)this.myPrivateForInnersCheckbox, gc);
            ExtensionPoint point = Extensions.getRootArea().getExtensionPoint("com.intellij.deadCode");
            for (EntryPoint entryPoint : (EntryPoint[])point.getExtensions()) {
                if (!(entryPoint instanceof EntryPointWithVisibilityLevel)) continue;
                ++gc.gridy;
                JCheckBox checkBox = new JCheckBox(((EntryPointWithVisibilityLevel)entryPoint).getTitle());
                checkBox.setSelected(VisibilityInspection.this.myExtensions.getOrDefault(((EntryPointWithVisibilityLevel)entryPoint).getId(), true));
                checkBox.addActionListener(e -> VisibilityInspection.this.myExtensions.put(((EntryPointWithVisibilityLevel)entryPoint).getId(), checkBox.isSelected()));
                this.add((Component)checkBox, gc);
            }
            ++gc.gridy;
            gc.weighty = 1.0;
            this.add((Component)new VerticalBox(), gc);
        }
    }
}

