/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.ant;

import com.intellij.compiler.ant.BuildProperties;
import com.intellij.compiler.ant.BuildPropertiesImpl;
import com.intellij.compiler.ant.ChunkBuildExtension;
import com.intellij.compiler.ant.CleanProject;
import com.intellij.compiler.ant.Comment;
import com.intellij.compiler.ant.CompositeGenerator;
import com.intellij.compiler.ant.GenerationOptions;
import com.intellij.compiler.ant.Generator;
import com.intellij.compiler.ant.ModuleChunk;
import com.intellij.compiler.ant.artifacts.ArtifactsGenerator;
import com.intellij.compiler.ant.taskdefs.AntProject;
import com.intellij.compiler.ant.taskdefs.Target;
import com.intellij.openapi.compiler.CompilerBundle;
import com.intellij.openapi.project.Project;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;

public abstract class ProjectBuild
extends Generator {
    protected final Project myProject;
    private final AntProject myAntProject;

    public ProjectBuild(Project project2, GenerationOptions genOptions) {
        this.myProject = project2;
        this.myAntProject = new AntProject(BuildProperties.getProjectBuildFileName((Project)this.myProject), "all");
        this.myAntProject.add((Generator)new BuildPropertiesImpl(this.myProject, genOptions), 1);
        StringBuilder buildModulesTargetNames = new StringBuilder();
        buildModulesTargetNames.append("init");
        buildModulesTargetNames.append(", ");
        buildModulesTargetNames.append("clean");
        ModuleChunk[] chunks = genOptions.getModuleChunks();
        if (chunks.length > 0) {
            this.myAntProject.add((Generator)new Comment(CompilerBundle.message((String)"generated.ant.build.modules.section.title", (Object[])new Object[0])), 1);
            for (ChunkBuildExtension chunkBuildExtension : chunks) {
                String[] targets;
                this.myAntProject.add(this.createModuleBuildGenerator((ModuleChunk)chunkBuildExtension, genOptions), 1);
                for (String target2 : targets = ChunkBuildExtension.getAllTargets((ModuleChunk)chunkBuildExtension)) {
                    if (buildModulesTargetNames.length() > 0) {
                        buildModulesTargetNames.append(", ");
                    }
                    buildModulesTargetNames.append(target2);
                }
            }
        }
        for (ChunkBuildExtension chunkBuildExtension : (ChunkBuildExtension[])ChunkBuildExtension.EP_NAME.getExtensions()) {
            chunkBuildExtension.generateProjectTargets(project2, genOptions, (CompositeGenerator)this.myAntProject);
        }
        Target initTarget = new Target("init", null, CompilerBundle.message((String)"generated.ant.build.initialization.section.title", (Object[])new Object[0]), null);
        initTarget.add((Generator)new Comment(CompilerBundle.message((String)"generated.ant.build.initialization.section.comment", (Object[])new Object[0])));
        this.myAntProject.add((Generator)initTarget, 1);
        ArtifactsGenerator artifactsGenerator = new ArtifactsGenerator(project2, genOptions);
        this.myAntProject.add((Generator)new CleanProject(project2, genOptions, artifactsGenerator), 1);
        this.myAntProject.add((Generator)new Target("build.modules", buildModulesTargetNames.toString(), CompilerBundle.message((String)"generated.ant.build.build.all.modules.target.name", (Object[])new Object[0]), null), 1);
        StringBuilder buildAllTargetNames = new StringBuilder();
        buildAllTargetNames.append("build.modules");
        if (artifactsGenerator.hasArtifacts()) {
            List<Generator> list2 = artifactsGenerator.generate();
            for (Generator generator : list2) {
                this.myAntProject.add(generator, 1);
            }
            buildAllTargetNames.append(", ").append("build.all.artifacts");
        }
        this.myAntProject.add((Generator)new Target("all", buildAllTargetNames.toString(), CompilerBundle.message((String)"generated.ant.build.build.all.target.name", (Object[])new Object[0]), null), 1);
    }

    public void generate(PrintWriter out) throws IOException {
        ProjectBuild.writeXmlHeader((PrintWriter)out);
        this.myAntProject.generate(out);
    }

    protected abstract Generator createModuleBuildGenerator(ModuleChunk var1, GenerationOptions var2);
}

