/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.backwardRefs;

import com.intellij.compiler.CompilerDirectHierarchyInfo;
import com.intellij.compiler.backwardRefs.CompilerHierarchyInfoImpl;
import com.intellij.compiler.backwardRefs.CompilerHierarchySearchType;
import com.intellij.compiler.backwardRefs.CompilerReferenceReader;
import com.intellij.compiler.backwardRefs.CompilerReferenceServiceEx;
import com.intellij.compiler.backwardRefs.DirtyScopeHolder;
import com.intellij.compiler.backwardRefs.LanguageLightRefAdapter;
import com.intellij.compiler.backwardRefs.ReferenceIndexUnavailableException;
import com.intellij.compiler.backwardRefs.SearchId;
import com.intellij.compiler.backwardRefs.view.CompilerReferenceFindUsagesTestInfo;
import com.intellij.compiler.backwardRefs.view.CompilerReferenceHierarchyTestInfo;
import com.intellij.compiler.backwardRefs.view.DirtyScopeTestInfo;
import com.intellij.compiler.chainsSearch.MethodIncompleteSignature;
import com.intellij.compiler.chainsSearch.SignatureAndOccurrences;
import com.intellij.compiler.server.BuildManager;
import com.intellij.compiler.server.BuildManagerListener;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.compiler.CompilationStatusListener;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompileScope;
import com.intellij.openapi.compiler.CompilerManager;
import com.intellij.openapi.compiler.CompilerTopics;
import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.impl.LibraryScopeCache;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.StorageException;
import com.intellij.util.io.PersistentEnumeratorBase;
import com.intellij.util.messages.MessageBusConnection;
import gnu.trove.THashSet;
import gnu.trove.TIntHashSet;
import java.io.IOException;
import java.util.Arrays;
import java.util.IntSummaryStatistics;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.UUID;
import java.util.concurrent.atomic.LongAdder;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.backwardRefs.LightRef;
import org.jetbrains.jps.backwardRefs.SignatureData;

public class CompilerReferenceServiceImpl
extends CompilerReferenceServiceEx
implements ModificationTracker {
    private static final Logger LOG = Logger.getInstance(CompilerReferenceServiceImpl.class);
    private final Set<FileType> myFileTypes;
    private final DirtyScopeHolder myDirtyScopeHolder;
    private final ProjectFileIndex myProjectFileIndex;
    private final LongAdder myCompilationCount = new LongAdder();
    private final ReentrantReadWriteLock myLock = new ReentrantReadWriteLock();
    private final Lock myReadDataLock = this.myLock.readLock();
    private final Lock myOpenCloseLock = this.myLock.writeLock();
    private int myActiveBuilds = 0;
    private volatile CompilerReferenceReader myReader;

    public CompilerReferenceServiceImpl(Project project2, FileDocumentManager fileDocumentManager, PsiDocumentManager psiDocumentManager) {
        super(project2);
        this.myProjectFileIndex = ProjectRootManager.getInstance((Project)project2).getFileIndex();
        this.myFileTypes = Stream.of(LanguageLightRefAdapter.INSTANCES).flatMap(a -> a.getFileTypes().stream()).collect(Collectors.toSet());
        this.myDirtyScopeHolder = new DirtyScopeHolder(this, fileDocumentManager, psiDocumentManager);
    }

    public void projectOpened() {
        if (CompilerReferenceServiceImpl.isEnabled()) {
            MessageBusConnection connection = this.myProject.getMessageBus().connect((Disposable)this.myProject);
            connection.subscribe(BuildManagerListener.TOPIC, (Object)new BuildManagerListener(){

                @Override
                public void buildStarted(Project project2, UUID sessionId, boolean isAutomake) {
                    if (project2 == CompilerReferenceServiceImpl.this.myProject) {
                        CompilerReferenceServiceImpl.this.closeReaderIfNeed(IndexCloseReason.COMPILATION_STARTED);
                    }
                }
            });
            connection.subscribe(CompilerTopics.COMPILATION_STATUS, (Object)new CompilationStatusListener(){

                public void compilationFinished(boolean aborted, int errors, int warnings, CompileContext compileContext) {
                    this.compilationFinished(compileContext);
                }

                public void automakeCompilationFinished(int errors, int warnings, CompileContext compileContext) {
                    this.compilationFinished(compileContext);
                }

                private void compilationFinished(CompileContext context) {
                    if (context.getProject() == CompilerReferenceServiceImpl.this.myProject) {
                        Runnable compilationFinished = () -> {
                            Module[] compilationModules = (Module[])ReadAction.compute(() -> {
                                if (CompilerReferenceServiceImpl.this.myProject.isDisposed()) {
                                    return null;
                                }
                                return context.getCompileScope().getAffectedModules();
                            });
                            if (compilationModules == null) {
                                return;
                            }
                            CompilerReferenceServiceImpl.this.openReaderIfNeed(IndexOpenReason.COMPILATION_FINISHED);
                        };
                        CompilerReferenceServiceImpl.executeOnBuildThread(compilationFinished);
                    }
                }
            });
            this.myDirtyScopeHolder.installVFSListener();
            if (!ApplicationManager.getApplication().isUnitTestMode()) {
                CompilerManager compilerManager = CompilerManager.getInstance((Project)this.myProject);
                ApplicationManager.getApplication().executeOnPooledThread(() -> {
                    boolean isUpToDate;
                    boolean indexExist = CompilerReferenceReader.exists(this.myProject);
                    if (indexExist) {
                        CompileScope projectCompileScope = compilerManager.createProjectCompileScope(this.myProject);
                        isUpToDate = compilerManager.isUpToDate(projectCompileScope);
                    } else {
                        isUpToDate = false;
                    }
                    CompilerReferenceServiceImpl.executeOnBuildThread(() -> {
                        if (isUpToDate) {
                            this.openReaderIfNeed(IndexOpenReason.UP_TO_DATE_CACHE);
                        } else {
                            this.markAsOutdated(indexExist);
                        }
                    });
                });
            }
            Disposer.register((Disposable)this.myProject, () -> this.closeReaderIfNeed(IndexCloseReason.PROJECT_CLOSED));
        }
    }

    @Override
    @Nullable
    public GlobalSearchScope getScopeWithoutCodeReferences(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/compiler/backwardRefs/CompilerReferenceServiceImpl", "getScopeWithoutCodeReferences"));
        }
        if (!this.isServiceEnabledFor(element)) {
            return null;
        }
        try {
            return (GlobalSearchScope)CachedValuesManager.getCachedValue((PsiElement)element, () -> {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/compiler/backwardRefs/CompilerReferenceServiceImpl", "lambda$getScopeWithoutCodeReferences$4"));
                }
                return CachedValueProvider.Result.create((Object)this.calculateScopeWithoutReferences(element), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT, this});
            });
        }
        catch (RuntimeException e) {
            return (GlobalSearchScope)this.onException(e, "scope without code references");
        }
    }

    @Override
    @Nullable
    public CompilerDirectHierarchyInfo getDirectInheritors(@NotNull PsiNamedElement aClass, @NotNull GlobalSearchScope useScope, @NotNull GlobalSearchScope searchScope, @NotNull FileType searchFileType) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/compiler/backwardRefs/CompilerReferenceServiceImpl", "getDirectInheritors"));
        }
        if (useScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "useScope", "com/intellij/compiler/backwardRefs/CompilerReferenceServiceImpl", "getDirectInheritors"));
        }
        if (searchScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "searchScope", "com/intellij/compiler/backwardRefs/CompilerReferenceServiceImpl", "getDirectInheritors"));
        }
        if (searchFileType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "searchFileType", "com/intellij/compiler/backwardRefs/CompilerReferenceServiceImpl", "getDirectInheritors"));
        }
        return this.getHierarchyInfo(aClass, useScope, searchScope, searchFileType, CompilerHierarchySearchType.DIRECT_INHERITOR);
    }

    @Override
    @Nullable
    public CompilerDirectHierarchyInfo getFunExpressions(@NotNull PsiNamedElement functionalInterface, @NotNull GlobalSearchScope useScope, @NotNull GlobalSearchScope searchScope, @NotNull FileType searchFileType) {
        if (functionalInterface == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionalInterface", "com/intellij/compiler/backwardRefs/CompilerReferenceServiceImpl", "getFunExpressions"));
        }
        if (useScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "useScope", "com/intellij/compiler/backwardRefs/CompilerReferenceServiceImpl", "getFunExpressions"));
        }
        if (searchScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "searchScope", "com/intellij/compiler/backwardRefs/CompilerReferenceServiceImpl", "getFunExpressions"));
        }
        if (searchFileType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "searchFileType", "com/intellij/compiler/backwardRefs/CompilerReferenceServiceImpl", "getFunExpressions"));
        }
        return this.getHierarchyInfo(functionalInterface, useScope, searchScope, searchFileType, CompilerHierarchySearchType.FUNCTIONAL_EXPRESSION);
    }

    @Override
    @Nullable
    public Integer getCompileTimeOccurrenceCount(final @NotNull PsiElement element, boolean isConstructorSuggestion) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/compiler/backwardRefs/CompilerReferenceServiceImpl", "getCompileTimeOccurrenceCount"));
        }
        if (!this.isServiceEnabledFor(element)) {
            return null;
        }
        try {
            return (Integer)((Object)CachedValuesManager.getCachedValue((PsiElement)element, () -> {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/compiler/backwardRefs/CompilerReferenceServiceImpl", "lambda$getCompileTimeOccurrenceCount$5"));
                }
                return CachedValueProvider.Result.create((Object)new ConcurrentFactoryMap<Boolean, Integer>(){

                    @Nullable
                    protected Integer create(Boolean constructorSuggestion) {
                        return CompilerReferenceServiceImpl.this.calculateOccurrenceCount(element, constructorSuggestion);
                    }
                }, (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT, this});
            })).get(isConstructorSuggestion);
        }
        catch (RuntimeException e) {
            return (Integer)this.onException(e, "weighting for completion");
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    @NotNull
    public SortedSet<SignatureAndOccurrences> findMethodReferenceOccurrences(@NotNull String rawReturnType, @SignatureData.IteratorKind byte iteratorKind) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean mayHappen(@NotNull LightRef qualifier, @NotNull LightRef base, int probabilityThreshold) {
        if (qualifier == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifier", "com/intellij/compiler/backwardRefs/CompilerReferenceServiceImpl", "mayHappen"));
        }
        if (base == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "base", "com/intellij/compiler/backwardRefs/CompilerReferenceServiceImpl", "mayHappen"));
        }
        try {
            this.myReadDataLock.lock();
            try {
                if (this.myReader == null) {
                    throw new ReferenceIndexUnavailableException();
                }
                TIntHashSet ids1 = this.myReader.getAllContainingFileIds(qualifier);
                TIntHashSet ids2 = this.myReader.getAllContainingFileIds(base);
                TIntHashSet intersection = CompilerReferenceServiceImpl.intersection(ids1, ids2);
                if ((ids2.size() - intersection.size()) * probabilityThreshold < ids2.size()) {
                    boolean bl = true;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
            finally {
                this.myReadDataLock.unlock();
            }
        }
        catch (Exception e) {
            this.onException(e, "conditional probability");
            return false;
        }
    }

    /*
     * Loose catch block
     */
    @Override
    @NotNull
    public String getName(int idx) throws ReferenceIndexUnavailableException {
        this.myReadDataLock.lock();
        if (this.myReader == null) {
            throw new ReferenceIndexUnavailableException();
        }
        String string = this.myReader.getNameEnumerator().getName(idx);
        this.myReadDataLock.unlock();
        String string2 = string;
        if (string2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/compiler/backwardRefs/CompilerReferenceServiceImpl", "getName"));
        }
        return string2;
        {
            catch (Throwable throwable) {
                try {
                    this.myReadDataLock.unlock();
                    throw throwable;
                }
                catch (Exception e) {
                    this.onException(e, "find methods");
                    throw new ReferenceIndexUnavailableException();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getNameId(@NotNull String name2) throws ReferenceIndexUnavailableException {
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/compiler/backwardRefs/CompilerReferenceServiceImpl", "getNameId"));
        }
        this.myReadDataLock.lock();
        try {
            int id;
            if (this.myReader == null) {
                throw new ReferenceIndexUnavailableException();
            }
            int n = id = this.myReader.getNameEnumerator().tryEnumerate((Object)name2);
            this.myReadDataLock.unlock();
            return n;
        }
        catch (Throwable throwable) {
            try {
                this.myReadDataLock.unlock();
                throw throwable;
            }
            catch (Exception e) {
                this.onException(e, "get name-id");
                throw new ReferenceIndexUnavailableException();
            }
        }
    }

    /*
     * Loose catch block
     */
    @Override
    @NotNull
    public LightRef.LightClassHierarchyElementDef[] getDirectInheritors(@NotNull LightRef.LightClassHierarchyElementDef baseClass) throws ReferenceIndexUnavailableException {
        LightRef.LightClassHierarchyElementDef[] lightClassHierarchyElementDefArray;
        block7: {
            if (baseClass == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseClass", "com/intellij/compiler/backwardRefs/CompilerReferenceServiceImpl", "getDirectInheritors"));
            }
            this.myReadDataLock.lock();
            if (this.myReader == null) {
                throw new ReferenceIndexUnavailableException();
            }
            lightClassHierarchyElementDefArray = this.myReader.getDirectInheritors(baseClass);
            this.myReadDataLock.unlock();
            if (lightClassHierarchyElementDefArray != null) break block7;
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/compiler/backwardRefs/CompilerReferenceServiceImpl", "getDirectInheritors"));
        }
        return lightClassHierarchyElementDefArray;
        {
            catch (Throwable throwable) {
                try {
                    this.myReadDataLock.unlock();
                    throw throwable;
                }
                catch (Exception e) {
                    this.onException(e, "find methods");
                    throw new ReferenceIndexUnavailableException();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getInheritorCount(@NotNull LightRef.LightClassHierarchyElementDef baseClass) throws ReferenceIndexUnavailableException {
        if (baseClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseClass", "com/intellij/compiler/backwardRefs/CompilerReferenceServiceImpl", "getInheritorCount"));
        }
        this.myReadDataLock.lock();
        try {
            if (this.myReader == null) {
                throw new ReferenceIndexUnavailableException();
            }
            LightRef.LightClassHierarchyElementDef[] hierarchy = this.myReader.getHierarchy(baseClass, false, true, -1);
            int n = hierarchy == null ? -1 : hierarchy.length;
            this.myReadDataLock.unlock();
            return n;
        }
        catch (Throwable throwable) {
            try {
                this.myReadDataLock.unlock();
                throw throwable;
            }
            catch (Exception e) {
                this.onException(e, "inheritor count");
                throw new ReferenceIndexUnavailableException();
            }
        }
    }

    private Integer calculateOccurrenceCount(@NotNull PsiElement element, boolean isConstructorSuggestion) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/compiler/backwardRefs/CompilerReferenceServiceImpl", "calculateOccurrenceCount"));
        }
        LanguageLightRefAdapter adapter = null;
        if (isConstructorSuggestion && ((adapter = (LanguageLightRefAdapter)ReadAction.compute(() -> {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/compiler/backwardRefs/CompilerReferenceServiceImpl", "lambda$calculateOccurrenceCount$14"));
            }
            return LanguageLightRefAdapter.findAdapter(element);
        })) == null || !adapter.isClass(element))) {
            return null;
        }
        CompilerElementInfo searchElementInfo = this.asCompilerElements(element, false, false);
        if (searchElementInfo == null) {
            return null;
        }
        this.myReadDataLock.lock();
        try {
            if (this.myReader == null) {
                Integer n = null;
                return n;
            }
            if (isConstructorSuggestion) {
                int constructorOccurrences = 0;
                for (PsiElement constructor : adapter.getInstantiableConstructors(element)) {
                    LightRef lightConstructor = adapter.asLightUsage(constructor, this.myReader.getNameEnumerator());
                    if (lightConstructor == null) continue;
                    constructorOccurrences += this.myReader.getOccurrenceCount(lightConstructor);
                }
                Integer anonymousCount = this.myReader.getAnonymousCount((LightRef.LightClassHierarchyElementDef)searchElementInfo.searchElements[0], searchElementInfo.place == ElementPlace.SRC);
                Integer n = anonymousCount == null ? constructorOccurrences : constructorOccurrences + anonymousCount;
                return n;
            }
            Integer constructorOccurrences = this.myReader.getOccurrenceCount(searchElementInfo.searchElements[0]);
            return constructorOccurrences;
        }
        finally {
            this.myReadDataLock.unlock();
        }
    }

    @Nullable
    private CompilerHierarchyInfoImpl getHierarchyInfo(final @NotNull PsiNamedElement aClass, final @NotNull GlobalSearchScope useScope, @NotNull GlobalSearchScope searchScope, @NotNull FileType searchFileType, @NotNull CompilerHierarchySearchType searchType) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/compiler/backwardRefs/CompilerReferenceServiceImpl", "getHierarchyInfo"));
        }
        if (useScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "useScope", "com/intellij/compiler/backwardRefs/CompilerReferenceServiceImpl", "getHierarchyInfo"));
        }
        if (searchScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "searchScope", "com/intellij/compiler/backwardRefs/CompilerReferenceServiceImpl", "getHierarchyInfo"));
        }
        if (searchFileType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "searchFileType", "com/intellij/compiler/backwardRefs/CompilerReferenceServiceImpl", "getHierarchyInfo"));
        }
        if (searchType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "searchType", "com/intellij/compiler/backwardRefs/CompilerReferenceServiceImpl", "getHierarchyInfo"));
        }
        if (!this.isServiceEnabledFor((PsiElement)aClass) || searchScope == LibraryScopeCache.getInstance(this.myProject).getLibrariesOnlyScope()) {
            return null;
        }
        try {
            Map candidatesPerFile = (Map)ReadAction.compute(() -> {
                if (aClass == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/compiler/backwardRefs/CompilerReferenceServiceImpl", "lambda$getHierarchyInfo$16"));
                }
                if (useScope == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "useScope", "com/intellij/compiler/backwardRefs/CompilerReferenceServiceImpl", "lambda$getHierarchyInfo$16"));
                }
                if (searchType == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "searchType", "com/intellij/compiler/backwardRefs/CompilerReferenceServiceImpl", "lambda$getHierarchyInfo$16"));
                }
                if (searchFileType == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "searchFileType", "com/intellij/compiler/backwardRefs/CompilerReferenceServiceImpl", "lambda$getHierarchyInfo$16"));
                }
                if (this.myProject.isDisposed()) {
                    throw new ProcessCanceledException();
                }
                return (Map)((Object)((Object)CachedValuesManager.getCachedValue((PsiElement)aClass, () -> {
                    if (aClass == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/compiler/backwardRefs/CompilerReferenceServiceImpl", "lambda$null$15"));
                    }
                    if (useScope == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "useScope", "com/intellij/compiler/backwardRefs/CompilerReferenceServiceImpl", "lambda$null$15"));
                    }
                    return CachedValueProvider.Result.create((Object)new ConcurrentFactoryMap<HierarchySearchKey, Map<VirtualFile, SearchId[]>>(){

                        @Nullable
                        protected Map<VirtualFile, SearchId[]> create(HierarchySearchKey key2) {
                            return CompilerReferenceServiceImpl.this.calculateDirectInheritors(aClass, useScope, key2.mySearchFileType, key2.mySearchType);
                        }
                    }, (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT, this});
                }))).get(new HierarchySearchKey(searchType, searchFileType));
            });
            if (candidatesPerFile == null) {
                return null;
            }
            GlobalSearchScope dirtyScope = this.myDirtyScopeHolder.getDirtyScope();
            if (ElementPlace.LIB == ReadAction.compute(() -> {
                if (aClass == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/compiler/backwardRefs/CompilerReferenceServiceImpl", "lambda$getHierarchyInfo$17"));
                }
                return ElementPlace.get(aClass.getContainingFile().getVirtualFile(), this.myProjectFileIndex);
            })) {
                dirtyScope = dirtyScope.union((SearchScope)LibraryScopeCache.getInstance(this.myProject).getLibrariesOnlyScope());
            }
            return new CompilerHierarchyInfoImpl(candidatesPerFile, aClass, dirtyScope, searchScope, this.myProject, searchFileType, searchType);
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (RuntimeException e) {
            return (CompilerHierarchyInfoImpl)this.onException(e, "hierarchy");
        }
    }

    private boolean isServiceEnabledFor(PsiElement element) {
        if (!this.isActive()) {
            return false;
        }
        PsiFile file2 = (PsiFile)ReadAction.compute(() -> element.getContainingFile());
        return file2 != null && !InjectedLanguageManager.getInstance((Project)this.myProject).isInjectedFragment(file2);
    }

    @Override
    public boolean isActive() {
        return this.myReader != null && CompilerReferenceServiceImpl.isEnabled();
    }

    private Map<VirtualFile, SearchId[]> calculateDirectInheritors(@NotNull PsiNamedElement aClass, @NotNull GlobalSearchScope useScope, @NotNull FileType searchFileType, @NotNull CompilerHierarchySearchType searchType) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/compiler/backwardRefs/CompilerReferenceServiceImpl", "calculateDirectInheritors"));
        }
        if (useScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "useScope", "com/intellij/compiler/backwardRefs/CompilerReferenceServiceImpl", "calculateDirectInheritors"));
        }
        if (searchFileType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "searchFileType", "com/intellij/compiler/backwardRefs/CompilerReferenceServiceImpl", "calculateDirectInheritors"));
        }
        if (searchType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "searchType", "com/intellij/compiler/backwardRefs/CompilerReferenceServiceImpl", "calculateDirectInheritors"));
        }
        CompilerElementInfo searchElementInfo = this.asCompilerElements((PsiElement)aClass, false, true);
        if (searchElementInfo == null) {
            return null;
        }
        LightRef searchElement = searchElementInfo.searchElements[0];
        this.myReadDataLock.lock();
        try {
            if (this.myReader == null) {
                Map<VirtualFile, SearchId[]> map2 = null;
                return map2;
            }
            Map<VirtualFile, SearchId[]> map3 = this.myReader.getDirectInheritors(searchElement, useScope, this.myDirtyScopeHolder.getDirtyScope(), searchFileType, searchType);
            return map3;
        }
        finally {
            this.myReadDataLock.unlock();
        }
    }

    @Nullable
    private GlobalSearchScope calculateScopeWithoutReferences(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/compiler/backwardRefs/CompilerReferenceServiceImpl", "calculateScopeWithoutReferences"));
        }
        TIntHashSet referentFileIds = this.getReferentFileIds(element);
        if (referentFileIds == null) {
            return null;
        }
        return GlobalSearchScope.getScopeRestrictedByFileTypes((GlobalSearchScope)new ScopeWithoutReferencesOnCompilation(referentFileIds, this.myProjectFileIndex).intersectWith(GlobalSearchScope.notScope((GlobalSearchScope)this.myDirtyScopeHolder.getDirtyScope())), (FileType[])this.myFileTypes.toArray(new FileType[this.myFileTypes.size()]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private TIntHashSet getReferentFileIds(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/compiler/backwardRefs/CompilerReferenceServiceImpl", "getReferentFileIds"));
        }
        CompilerElementInfo compilerElementInfo = this.asCompilerElements(element, true, true);
        if (compilerElementInfo == null) {
            return null;
        }
        this.myReadDataLock.lock();
        try {
            if (this.myReader == null) {
                TIntHashSet tIntHashSet = null;
                return tIntHashSet;
            }
            TIntHashSet referentFileIds = new TIntHashSet();
            for (TIntHashSet ref : compilerElementInfo.searchElements) {
                TIntHashSet referents;
                block12: {
                    try {
                        referents = this.myReader.findReferentFileIds((LightRef)ref, compilerElementInfo.place == ElementPlace.SRC);
                        if (referents != null) break block12;
                        TIntHashSet tIntHashSet = null;
                        return tIntHashSet;
                    }
                    catch (StorageException e) {
                        throw new RuntimeException(e);
                    }
                }
                referentFileIds.addAll(referents.toArray());
            }
            TIntHashSet tIntHashSet = referentFileIds;
            return tIntHashSet;
        }
        finally {
            this.myReadDataLock.unlock();
        }
    }

    @Nullable
    private CompilerElementInfo asCompilerElements(@NotNull PsiElement psiElement, boolean buildHierarchyForLibraryElements, boolean checkNotDirty) {
        if (psiElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/intellij/compiler/backwardRefs/CompilerReferenceServiceImpl", "asCompilerElements"));
        }
        this.myReadDataLock.lock();
        try {
            if (this.myReader == null) {
                CompilerElementInfo compilerElementInfo = null;
                return compilerElementInfo;
            }
            VirtualFile file2 = PsiUtilCore.getVirtualFile((PsiElement)psiElement);
            if (file2 == null) {
                CompilerElementInfo compilerElementInfo = null;
                return compilerElementInfo;
            }
            ElementPlace place = ElementPlace.get(file2, this.myProjectFileIndex);
            if (checkNotDirty && (place == null || place == ElementPlace.SRC && this.myDirtyScopeHolder.contains(file2))) {
                CompilerElementInfo compilerElementInfo = null;
                return compilerElementInfo;
            }
            LanguageLightRefAdapter adapter = LanguageLightRefAdapter.findAdapter(file2);
            if (adapter == null) {
                CompilerElementInfo compilerElementInfo = null;
                return compilerElementInfo;
            }
            LightRef ref = adapter.asLightUsage(psiElement, this.myReader.getNameEnumerator());
            if (ref == null) {
                CompilerElementInfo compilerElementInfo = null;
                return compilerElementInfo;
            }
            if (place == ElementPlace.LIB && buildHierarchyForLibraryElements) {
                List<LightRef> elements = adapter.getHierarchyRestrictedToLibraryScope(ref, psiElement, this.myReader.getNameEnumerator(), LibraryScopeCache.getInstance(this.myProject).getLibrariesOnlyScope());
                LightRef[] fullHierarchy = new LightRef[elements.size() + 1];
                fullHierarchy[0] = ref;
                int i2 = 1;
                for (LightRef element : elements) {
                    fullHierarchy[i2++] = element;
                }
                CompilerElementInfo compilerElementInfo = new CompilerElementInfo(place, fullHierarchy);
                return compilerElementInfo;
            }
            CompilerElementInfo compilerElementInfo = new CompilerElementInfo(place, new LightRef[]{ref});
            return compilerElementInfo;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            this.myReadDataLock.unlock();
        }
    }

    private void closeReaderIfNeed(IndexCloseReason reason) {
        this.myOpenCloseLock.lock();
        try {
            if (reason == IndexCloseReason.COMPILATION_STARTED) {
                ++this.myActiveBuilds;
                this.myDirtyScopeHolder.compilerActivityStarted();
            }
            if (this.myReader != null) {
                this.myReader.close(reason == IndexCloseReason.AN_EXCEPTION);
                this.myReader = null;
            }
        }
        finally {
            this.myOpenCloseLock.unlock();
        }
    }

    private void openReaderIfNeed(IndexOpenReason reason) {
        this.myCompilationCount.increment();
        this.myOpenCloseLock.lock();
        try {
            try {
                switch (reason) {
                    case UP_TO_DATE_CACHE: {
                        this.myDirtyScopeHolder.upToDateChecked(true);
                        break;
                    }
                    case COMPILATION_FINISHED: {
                        this.myDirtyScopeHolder.compilerActivityFinished();
                    }
                }
            }
            catch (RuntimeException e) {
                --this.myActiveBuilds;
                throw e;
            }
            if (--this.myActiveBuilds == 0 && this.myProject.isOpen()) {
                this.myReader = CompilerReferenceReader.create(this.myProject);
                LOG.info("backward reference index reader " + (this.myReader == null ? "doesn't exist" : "is opened"));
            }
        }
        finally {
            this.myOpenCloseLock.unlock();
        }
    }

    private void markAsOutdated(boolean decrementBuildCount) {
        this.myOpenCloseLock.lock();
        try {
            if (decrementBuildCount) {
                --this.myActiveBuilds;
            }
            this.myDirtyScopeHolder.upToDateChecked(false);
        }
        finally {
            this.myOpenCloseLock.unlock();
        }
    }

    ProjectFileIndex getFileIndex() {
        return this.myProjectFileIndex;
    }

    Set<FileType> getFileTypes() {
        return this.myFileTypes;
    }

    Project getProject() {
        return this.myProject;
    }

    private static void executeOnBuildThread(Runnable compilationFinished) {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            compilationFinished.run();
        } else {
            BuildManager.getInstance().runCommand(compilationFinished);
        }
    }

    public long getModificationCount() {
        return this.myCompilationCount.longValue();
    }

    @Nullable
    public Set<VirtualFile> getReferentFiles(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/compiler/backwardRefs/CompilerReferenceServiceImpl", "getReferentFiles"));
        }
        FileBasedIndex fileIndex = FileBasedIndex.getInstance();
        TIntHashSet ids = this.getReferentFileIds(element);
        if (ids == null) {
            return null;
        }
        THashSet fileSet = new THashSet();
        ids.forEach(arg_0 -> this.lambda$getReferentFiles$19(fileIndex, (Set)fileSet, arg_0));
        return fileSet;
    }

    @NotNull
    public DirtyScopeHolder getDirtyScopeHolder() {
        DirtyScopeHolder dirtyScopeHolder = this.myDirtyScopeHolder;
        if (dirtyScopeHolder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/compiler/backwardRefs/CompilerReferenceServiceImpl", "getDirtyScopeHolder"));
        }
        return dirtyScopeHolder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public CompilerReferenceFindUsagesTestInfo getTestFindUsages(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/compiler/backwardRefs/CompilerReferenceServiceImpl", "getTestFindUsages"));
        }
        this.myReadDataLock.lock();
        TIntHashSet referentFileIds = this.getReferentFileIds(element);
        DirtyScopeTestInfo dirtyScopeInfo = this.myDirtyScopeHolder.getState();
        CompilerReferenceFindUsagesTestInfo compilerReferenceFindUsagesTestInfo = new CompilerReferenceFindUsagesTestInfo(referentFileIds, dirtyScopeInfo, this.myProject);
        CompilerReferenceFindUsagesTestInfo compilerReferenceFindUsagesTestInfo2 = compilerReferenceFindUsagesTestInfo;
        if (compilerReferenceFindUsagesTestInfo2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/compiler/backwardRefs/CompilerReferenceServiceImpl", "getTestFindUsages"));
        }
        return compilerReferenceFindUsagesTestInfo2;
        finally {
            this.myReadDataLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public CompilerReferenceHierarchyTestInfo getTestHierarchy(@NotNull PsiNamedElement element, @NotNull GlobalSearchScope scope, @NotNull FileType fileType) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/compiler/backwardRefs/CompilerReferenceServiceImpl", "getTestHierarchy"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/compiler/backwardRefs/CompilerReferenceServiceImpl", "getTestHierarchy"));
        }
        if (fileType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileType", "com/intellij/compiler/backwardRefs/CompilerReferenceServiceImpl", "getTestHierarchy"));
        }
        this.myReadDataLock.lock();
        CompilerHierarchyInfoImpl hierarchyInfo = this.getHierarchyInfo(element, scope, scope, fileType, CompilerHierarchySearchType.DIRECT_INHERITOR);
        DirtyScopeTestInfo dirtyScopeInfo = this.myDirtyScopeHolder.getState();
        CompilerReferenceHierarchyTestInfo compilerReferenceHierarchyTestInfo = new CompilerReferenceHierarchyTestInfo(hierarchyInfo, dirtyScopeInfo);
        CompilerReferenceHierarchyTestInfo compilerReferenceHierarchyTestInfo2 = compilerReferenceHierarchyTestInfo;
        if (compilerReferenceHierarchyTestInfo2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/compiler/backwardRefs/CompilerReferenceServiceImpl", "getTestHierarchy"));
        }
        return compilerReferenceHierarchyTestInfo2;
        finally {
            this.myReadDataLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public CompilerReferenceHierarchyTestInfo getTestFunExpressions(@NotNull PsiNamedElement element, @NotNull GlobalSearchScope scope, @NotNull FileType fileType) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/compiler/backwardRefs/CompilerReferenceServiceImpl", "getTestFunExpressions"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/compiler/backwardRefs/CompilerReferenceServiceImpl", "getTestFunExpressions"));
        }
        if (fileType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileType", "com/intellij/compiler/backwardRefs/CompilerReferenceServiceImpl", "getTestFunExpressions"));
        }
        this.myReadDataLock.lock();
        CompilerHierarchyInfoImpl hierarchyInfo = this.getHierarchyInfo(element, scope, scope, fileType, CompilerHierarchySearchType.FUNCTIONAL_EXPRESSION);
        DirtyScopeTestInfo dirtyScopeInfo = this.myDirtyScopeHolder.getState();
        CompilerReferenceHierarchyTestInfo compilerReferenceHierarchyTestInfo = new CompilerReferenceHierarchyTestInfo(hierarchyInfo, dirtyScopeInfo);
        CompilerReferenceHierarchyTestInfo compilerReferenceHierarchyTestInfo2 = compilerReferenceHierarchyTestInfo;
        if (compilerReferenceHierarchyTestInfo2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/compiler/backwardRefs/CompilerReferenceServiceImpl", "getTestFunExpressions"));
        }
        return compilerReferenceHierarchyTestInfo2;
        finally {
            this.myReadDataLock.unlock();
        }
    }

    @Nullable
    private <T> T onException(@NotNull Exception e, @NotNull String actionName) {
        Throwable unwrapped;
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/compiler/backwardRefs/CompilerReferenceServiceImpl", "onException"));
        }
        if (actionName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actionName", "com/intellij/compiler/backwardRefs/CompilerReferenceServiceImpl", "onException"));
        }
        if (e instanceof ControlFlowException) {
            throw (RuntimeException)e;
        }
        LOG.error("an exception during " + actionName + " calculation", (Throwable)e);
        Throwable throwable = unwrapped = e instanceof RuntimeException ? e.getCause() : e;
        if (CompilerReferenceServiceImpl.requireIndexRebuild(unwrapped)) {
            this.closeReaderIfNeed(IndexCloseReason.AN_EXCEPTION);
        }
        return null;
    }

    @NotNull
    private static TIntHashSet intersection(@NotNull TIntHashSet set1, @NotNull TIntHashSet set2) {
        if (set1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "set1", "com/intellij/compiler/backwardRefs/CompilerReferenceServiceImpl", "intersection"));
        }
        if (set2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "set2", "com/intellij/compiler/backwardRefs/CompilerReferenceServiceImpl", "intersection"));
        }
        TIntHashSet result2 = (TIntHashSet)set1.clone();
        result2.retainAll(set2.toArray());
        TIntHashSet tIntHashSet = result2;
        if (tIntHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/compiler/backwardRefs/CompilerReferenceServiceImpl", "intersection"));
        }
        return tIntHashSet;
    }

    private static boolean requireIndexRebuild(@Nullable Throwable exception) {
        return exception instanceof PersistentEnumeratorBase.CorruptedException || exception instanceof StorageException || exception instanceof IOException;
    }

    private /* synthetic */ boolean lambda$getReferentFiles$19(FileBasedIndex fileIndex, Set fileSet, int id) {
        VirtualFile vFile = fileIndex.findFileById(this.myProject, id);
        assert (vFile != null);
        fileSet.add(vFile);
        return true;
    }

    private static /* synthetic */ SignatureAndOccurrences lambda$findMethodReferenceOccurrences$13(Map.Entry e) {
        return new SignatureAndOccurrences((MethodIncompleteSignature)e.getKey(), (int)((IntSummaryStatistics)e.getValue()).getSum());
    }

    private static /* synthetic */ int lambda$findMethodReferenceOccurrences$12(SignatureAndOccurrences x) {
        return x.getOccurrenceCount();
    }

    private static /* synthetic */ MethodIncompleteSignature lambda$findMethodReferenceOccurrences$11(SignatureAndOccurrences x) {
        return x.getSignature();
    }

    private /* synthetic */ Stream lambda$findMethodReferenceOccurrences$10(SignatureData sd) {
        return ((StreamEx)((StreamEx)StreamEx.of(this.myReader.getMembersFor(sd)).peek(r -> ProgressManager.checkCanceled())).select(LightRef.JavaLightMethodRef.class).flatMap(r -> {
            LightRef.LightClassHierarchyElementDef[] hierarchy = this.myReader.getHierarchy(r.getOwner(), false, false, 20);
            return hierarchy == null ? Stream.empty() : Arrays.stream(hierarchy).map(c -> r.override(c.getName()));
        }).distinct()).map(r -> {
            int count = this.myReader.getOccurrenceCount((LightRef)r);
            return count <= 1 ? null : new SignatureAndOccurrences(new MethodIncompleteSignature((LightRef.JavaLightMethodRef)r, sd, this), count);
        });
    }

    private static enum IndexOpenReason {
        COMPILATION_FINISHED,
        UP_TO_DATE_CACHE;

    }

    private static enum IndexCloseReason {
        AN_EXCEPTION,
        COMPILATION_STARTED,
        PROJECT_CLOSED;

    }

    private static class HierarchySearchKey {
        private final CompilerHierarchySearchType mySearchType;
        private final FileType mySearchFileType;

        HierarchySearchKey(CompilerHierarchySearchType searchType, FileType searchFileType) {
            this.mySearchType = searchType;
            this.mySearchFileType = searchFileType;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            HierarchySearchKey key2 = (HierarchySearchKey)o;
            return this.mySearchType == key2.mySearchType && this.mySearchFileType == key2.mySearchFileType;
        }

        public int hashCode() {
            return 31 * this.mySearchType.hashCode() + this.mySearchFileType.hashCode();
        }
    }

    static class CompilerElementInfo {
        final ElementPlace place;
        final LightRef[] searchElements;

        private CompilerElementInfo(ElementPlace place, LightRef ... searchElements) {
            this.place = place;
            this.searchElements = searchElements;
        }
    }

    private static class ScopeWithoutReferencesOnCompilation
    extends GlobalSearchScope {
        private final TIntHashSet myReferentIds;
        private final ProjectFileIndex myIndex;

        private ScopeWithoutReferencesOnCompilation(TIntHashSet ids, ProjectFileIndex index) {
            this.myReferentIds = ids;
            this.myIndex = index;
        }

        public boolean contains(@NotNull VirtualFile file2) {
            if (file2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/compiler/backwardRefs/CompilerReferenceServiceImpl$ScopeWithoutReferencesOnCompilation", "contains"));
            }
            return file2 instanceof VirtualFileWithId && this.myIndex.isInSourceContent(file2) && !this.myReferentIds.contains(((VirtualFileWithId)file2).getId());
        }

        public int compare(@NotNull VirtualFile file1, @NotNull VirtualFile file2) {
            if (file1 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file1", "com/intellij/compiler/backwardRefs/CompilerReferenceServiceImpl$ScopeWithoutReferencesOnCompilation", "compare"));
            }
            if (file2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file2", "com/intellij/compiler/backwardRefs/CompilerReferenceServiceImpl$ScopeWithoutReferencesOnCompilation", "compare"));
            }
            return 0;
        }

        public boolean isSearchInModuleContent(@NotNull Module aModule) {
            if (aModule == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aModule", "com/intellij/compiler/backwardRefs/CompilerReferenceServiceImpl$ScopeWithoutReferencesOnCompilation", "isSearchInModuleContent"));
            }
            return true;
        }

        public boolean isSearchInLibraries() {
            return false;
        }
    }

    private static enum ElementPlace {
        SRC,
        LIB;


        private static ElementPlace get(VirtualFile file2, ProjectFileIndex index) {
            if (file2 == null) {
                return null;
            }
            return index.isInSourceContent(file2) ? SRC : (index.isInLibrarySource(file2) || index.isInLibraryClasses(file2) ? LIB : null);
        }
    }
}

