/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.backwardRefs;

import com.intellij.compiler.backwardRefs.JavaLightUsageAdapter;
import com.intellij.compiler.backwardRefs.SearchId;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.impl.source.PsiFileWithStubSupport;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiUtilCore;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.backwardRefs.LightRef;
import org.jetbrains.jps.backwardRefs.NameEnumerator;

public interface LanguageLightRefAdapter {
    public static final LanguageLightRefAdapter[] INSTANCES = new LanguageLightRefAdapter[]{new JavaLightUsageAdapter()};

    @Nullable
    public static LanguageLightRefAdapter findAdapter(@NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/compiler/backwardRefs/LanguageLightRefAdapter", "findAdapter"));
        }
        FileType fileType = file2.getFileType();
        return LanguageLightRefAdapter.findAdapter(fileType);
    }

    @Nullable
    public static LanguageLightRefAdapter findAdapter(@NotNull FileType fileType) {
        if (fileType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileType", "com/intellij/compiler/backwardRefs/LanguageLightRefAdapter", "findAdapter"));
        }
        for (LanguageLightRefAdapter adapter : INSTANCES) {
            if (!adapter.getFileTypes().contains(fileType)) continue;
            return adapter;
        }
        return null;
    }

    @Nullable
    public static LanguageLightRefAdapter findAdapter(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/compiler/backwardRefs/LanguageLightRefAdapter", "findAdapter"));
        }
        VirtualFile file2 = PsiUtilCore.getVirtualFile((PsiElement)element);
        return file2 == null ? null : LanguageLightRefAdapter.findAdapter(file2);
    }

    @NotNull
    public Set<FileType> getFileTypes();

    @Nullable
    public LightRef asLightUsage(@NotNull PsiElement var1, @NotNull NameEnumerator var2) throws IOException;

    @NotNull
    public List<LightRef> getHierarchyRestrictedToLibraryScope(@NotNull LightRef var1, @NotNull PsiElement var2, @NotNull NameEnumerator var3, @NotNull GlobalSearchScope var4) throws IOException;

    @NotNull
    public Class<? extends LightRef.LightClassHierarchyElementDef> getHierarchyObjectClass();

    @NotNull
    public Class<? extends LightRef> getFunExprClass();

    @NotNull
    public PsiElement[] findDirectInheritorCandidatesInFile(@NotNull SearchId[] var1, @NotNull PsiFileWithStubSupport var2);

    @NotNull
    public PsiElement[] findFunExpressionsInFile(@NotNull SearchId[] var1, @NotNull PsiFileWithStubSupport var2);

    public boolean isClass(@NotNull PsiElement var1);

    @NotNull
    public PsiElement[] getInstantiableConstructors(@NotNull PsiElement var1);

    public boolean isDirectInheritor(PsiElement var1, PsiNamedElement var2);
}

