/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.chainsSearch;

import com.intellij.compiler.backwardRefs.CompilerReferenceServiceEx;
import com.intellij.compiler.chainsSearch.MethodChain;
import com.intellij.compiler.chainsSearch.MethodIncompleteSignature;
import com.intellij.compiler.chainsSearch.SearchInitializer;
import com.intellij.compiler.chainsSearch.SignatureAndOccurrences;
import com.intellij.compiler.chainsSearch.context.ChainCompletionContext;
import com.intellij.compiler.chainsSearch.context.ChainSearchTarget;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.util.containers.IntStack;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.backwardRefs.LightRef;

public class ChainSearcher {
    @NotNull
    public static List<MethodChain> search(int pathMaximalLength, ChainSearchTarget searchTarget, int maxResultSize, ChainCompletionContext context, CompilerReferenceServiceEx compilerReferenceServiceEx) {
        SearchInitializer initializer = ChainSearcher.createInitializer(searchTarget, compilerReferenceServiceEx, context);
        List<MethodChain> list2 = ChainSearcher.search(compilerReferenceServiceEx, initializer, pathMaximalLength, maxResultSize, context);
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/compiler/chainsSearch/ChainSearcher", "search"));
        }
        return list2;
    }

    @NotNull
    private static SearchInitializer createInitializer(ChainSearchTarget target2, CompilerReferenceServiceEx referenceServiceEx, ChainCompletionContext context) {
        SortedSet<SignatureAndOccurrences> methods = null;
        for (byte kind2 : target2.getArrayKind()) {
            SortedSet<SignatureAndOccurrences> currentMethods = referenceServiceEx.findMethodReferenceOccurrences(target2.getClassQName(), kind2);
            methods = methods == null ? currentMethods : ChainSearcher.unionSortedSet(currentMethods, methods);
        }
        SearchInitializer searchInitializer = new SearchInitializer(methods, context);
        if (searchInitializer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/compiler/chainsSearch/ChainSearcher", "createInitializer"));
        }
        return searchInitializer;
    }

    @NotNull
    private static List<MethodChain> search(CompilerReferenceServiceEx referenceServiceEx, SearchInitializer initializer, int chainMaxLength, int maxResultSize, ChainCompletionContext context) {
        LinkedList<MethodChain> q = initializer.getChainQueue();
        ArrayList<MethodChain> result2 = new ArrayList<MethodChain>();
        while (!q.isEmpty()) {
            SignatureAndOccurrences candidate;
            ProgressManager.checkCanceled();
            MethodChain currentChain = q.poll();
            MethodIncompleteSignature headSignature = currentChain.getHeadSignature();
            if (ChainSearcher.addChainIfTerminal(currentChain, result2, chainMaxLength, context)) continue;
            boolean updated = false;
            SortedSet<SignatureAndOccurrences> candidates = referenceServiceEx.findMethodReferenceOccurrences(headSignature.getOwner(), (byte)0);
            Iterator iterator = candidates.iterator();
            while (iterator.hasNext() && (candidate = (SignatureAndOccurrences)iterator.next()).getOccurrenceCount() * 10 >= currentChain.getChainWeight()) {
                boolean stopChain;
                MethodChain continuation;
                MethodIncompleteSignature sign = candidate.getSignature();
                if (!sign.isStatic() && sign.getOwner().equals(context.getTarget().getClassQName()) || !referenceServiceEx.mayHappen((LightRef)candidate.getSignature().getRef(), (LightRef)headSignature.getRef(), 5) || (continuation = currentChain.continuation(candidate.getSignature(), candidate.getOccurrenceCount(), context)) == null) continue;
                boolean bl = stopChain = candidate.getSignature().isStatic() || context.hasQualifier(context.resolveQualifierClass(candidate.getSignature()));
                if (stopChain) {
                    ChainSearcher.addChainIfNotPresent(continuation, result2);
                } else {
                    q.addFirst(continuation);
                }
                updated = true;
            }
            if (!updated) {
                ChainSearcher.addChainIfQualifierCanBeOccurredInContext(currentChain, result2, context, referenceServiceEx);
            }
            if (result2.size() <= maxResultSize) continue;
            ArrayList<MethodChain> arrayList = result2;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/compiler/chainsSearch/ChainSearcher", "search"));
            }
            return arrayList;
        }
        ArrayList<MethodChain> arrayList = result2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/compiler/chainsSearch/ChainSearcher", "search"));
        }
        return arrayList;
    }

    private static void addChainIfQualifierCanBeOccurredInContext(MethodChain currentChain, List<MethodChain> result2, ChainCompletionContext context, CompilerReferenceServiceEx referenceServiceEx) {
        if (!context.getTarget().getClassQName().equals(currentChain.getHeadSignature().getOwner())) {
            Set<LightRef> references = context.getContextClassReferences();
            boolean isRelevantQualifier = false;
            for (LightRef ref : references) {
                if (!referenceServiceEx.mayHappen((LightRef)currentChain.getHeadSignature().getOwnerRef(), ref, 1)) continue;
                isRelevantQualifier = true;
                break;
            }
            if (references.isEmpty() || isRelevantQualifier) {
                ChainSearcher.addChainIfNotPresent(currentChain, result2);
            }
        }
    }

    private static boolean addChainIfTerminal(MethodChain currentChain, List<MethodChain> result2, int pathMaximalLength, ChainCompletionContext context) {
        if (currentChain.getHeadSignature().isStatic() || context.hasQualifier(context.resolveQualifierClass(currentChain.getHeadSignature())) || currentChain.length() >= pathMaximalLength) {
            ChainSearcher.addChainIfNotPresent(currentChain, result2);
            return true;
        }
        return false;
    }

    private static void addChainIfNotPresent(MethodChain newChain, List<MethodChain> result2) {
        if (result2.isEmpty()) {
            result2.add(newChain);
            return;
        }
        boolean doAdd = true;
        IntStack indicesToRemove = new IntStack();
        block4: for (int i2 = 0; i2 < result2.size(); ++i2) {
            MethodChain chain = result2.get(i2);
            MethodChain.CompareResult r = MethodChain.compare(chain, newChain);
            switch (r) {
                case LEFT_CONTAINS_RIGHT: {
                    indicesToRemove.push(i2);
                    continue block4;
                }
                case RIGHT_CONTAINS_LEFT: 
                case EQUAL: {
                    doAdd = false;
                    continue block4;
                }
            }
        }
        while (!indicesToRemove.empty()) {
            result2.remove(indicesToRemove.pop());
        }
        if (doAdd) {
            result2.add(newChain);
        }
    }

    private static <T> SortedSet<T> unionSortedSet(SortedSet<T> s1, SortedSet<T> s2) {
        if (s1.isEmpty()) {
            return s2;
        }
        if (s2.isEmpty()) {
            return s1;
        }
        TreeSet<T> result2 = new TreeSet<T>();
        result2.addAll(s1);
        result2.addAll(s2);
        return result2;
    }
}

