/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.chainsSearch;

import com.intellij.codeInsight.NullableNotNullManager;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.JavaChainLookupElement;
import com.intellij.codeInsight.completion.JavaMethodCallElement;
import com.intellij.codeInsight.lookup.ExpressionLookupItem;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementDecorator;
import com.intellij.codeInsight.lookup.TypedLookupItem;
import com.intellij.codeInsight.lookup.VariableLookupItem;
import com.intellij.compiler.chainsSearch.ChainRelevance;
import com.intellij.compiler.chainsSearch.MethodChain;
import com.intellij.compiler.chainsSearch.MethodChainsSearchUtil;
import com.intellij.compiler.chainsSearch.completion.lookup.ChainCompletionNewVariableLookupElement;
import com.intellij.compiler.chainsSearch.completion.lookup.JavaRelevantChainLookupElement;
import com.intellij.compiler.chainsSearch.context.ChainCompletionContext;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Couple;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MethodChainLookupRangingHelper {
    @NotNull
    public static LookupElement toLookupElement(MethodChain chain, ChainCompletionContext context) {
        int unreachableParametersCount = 0;
        int matchedParametersInContext = 0;
        JavaChainLookupElement chainLookupElement = null;
        for (PsiMethod[] psiMethods : chain.getPath()) {
            PsiMethod method = (PsiMethod)ObjectUtils.notNull((Object)MethodChainsSearchUtil.getMethodWithMinNotPrimitiveParameters(psiMethods, context.getTarget().getTargetClass()));
            Couple<Integer> info = MethodChainLookupRangingHelper.calculateParameterInfo(method, context);
            unreachableParametersCount += ((Integer)info.getFirst()).intValue();
            matchedParametersInContext += ((Integer)info.getSecond()).intValue();
            if (chainLookupElement == null) {
                LookupElement qualifierLookupElement = MethodChainLookupRangingHelper.createQualifierLookupElement(method, chain.getQualifierClass(), context);
                LookupElement headLookupElement = MethodChainLookupRangingHelper.createMethodLookupElement(method);
                chainLookupElement = qualifierLookupElement == null ? headLookupElement : new JavaChainLookupElement(qualifierLookupElement, headLookupElement);
                continue;
            }
            chainLookupElement = new JavaChainLookupElement((LookupElement)chainLookupElement, (LookupElement)new JavaMethodCallElement(method));
        }
        if (context.getTarget().isIteratorAccess()) {
            chainLookupElement = MethodChainLookupRangingHelper.decorateWithIteratorAccess(chain.getFirst()[0], chainLookupElement);
        }
        JavaRelevantChainLookupElement javaRelevantChainLookupElement = new JavaRelevantChainLookupElement((LookupElement)ObjectUtils.notNull(chainLookupElement), new ChainRelevance(chain.length(), unreachableParametersCount, matchedParametersInContext));
        if (javaRelevantChainLookupElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/compiler/chainsSearch/MethodChainLookupRangingHelper", "toLookupElement"));
        }
        return javaRelevantChainLookupElement;
    }

    @NotNull
    private static LookupElementDecorator<LookupElement> decorateWithIteratorAccess(final PsiMethod method, LookupElement chainLookupElement) {
        LookupElementDecorator<LookupElement> lookupElementDecorator = new LookupElementDecorator<LookupElement>(chainLookupElement){

            public void handleInsert(InsertionContext context) {
                super.handleInsert(context);
                Document document = context.getDocument();
                int tail = context.getTailOffset();
                PsiType tailReturnType = method.getReturnType();
                if (tailReturnType instanceof PsiArrayType) {
                    document.insertString(tail, (CharSequence)"[0]");
                    context.getEditor().getCaretModel().moveToOffset(tail + 1);
                } else {
                    PsiClass returnClass = (PsiClass)ObjectUtils.notNull((Object)PsiUtil.resolveClassInClassTypeOnly((PsiType)tailReturnType));
                    PsiDocumentManager.getInstance((Project)context.getProject()).doPostponedOperationsAndUnblockDocument(document);
                    if (InheritanceUtil.isInheritor((PsiClass)returnClass, (String)"java.util.List")) {
                        document.insertString(tail, (CharSequence)".get(0)");
                        context.getEditor().getCaretModel().moveToOffset(tail + 5);
                    } else if (InheritanceUtil.isInheritor((PsiClass)returnClass, (String)"java.util.Collection")) {
                        document.insertString(tail, (CharSequence)".iterator().next()");
                    } else if (InheritanceUtil.isInheritor((PsiClass)returnClass, (String)"java.util.Iterator")) {
                        document.insertString(tail, (CharSequence)".next()");
                    } else if (InheritanceUtil.isInheritor((PsiClass)returnClass, (String)"java.util.stream.Stream")) {
                        document.insertString(tail, (CharSequence)".findFirst().get()");
                    }
                }
            }
        };
        if (lookupElementDecorator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/compiler/chainsSearch/MethodChainLookupRangingHelper", "decorateWithIteratorAccess"));
        }
        return lookupElementDecorator;
    }

    @Nullable
    private static LookupElement createQualifierLookupElement(@NotNull PsiMethod method, @NotNull PsiClass qualifierClass, @NotNull ChainCompletionContext context) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/compiler/chainsSearch/MethodChainLookupRangingHelper", "createQualifierLookupElement"));
        }
        if (qualifierClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifierClass", "com/intellij/compiler/chainsSearch/MethodChainLookupRangingHelper", "createQualifierLookupElement"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/compiler/chainsSearch/MethodChainLookupRangingHelper", "createQualifierLookupElement"));
        }
        if (method.hasModifierProperty("static")) {
            return null;
        }
        PsiNamedElement element = context.getQualifiers(qualifierClass).findFirst().orElse(null);
        if (element == null) {
            return new ChainCompletionNewVariableLookupElement(qualifierClass, context);
        }
        if (element instanceof PsiVariable) {
            return new VariableLookupItem((PsiVariable)element);
        }
        if (element instanceof PsiMethod) {
            return MethodChainLookupRangingHelper.createMethodLookupElement((PsiMethod)element);
        }
        throw new AssertionError((Object)("unexpected element: " + element));
    }

    @NotNull
    private static Couple<Integer> calculateParameterInfo(@NotNull PsiMethod method, @NotNull ChainCompletionContext context) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/compiler/chainsSearch/MethodChainLookupRangingHelper", "calculateParameterInfo"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/compiler/chainsSearch/MethodChainLookupRangingHelper", "calculateParameterInfo"));
        }
        NullableNotNullManager nullableNotNullManager = NullableNotNullManager.getInstance((Project)method.getProject());
        int unreachableParametersCount = 0;
        int matchedParametersInContext = 0;
        for (PsiParameter parameter : method.getParameterList().getParameters()) {
            PsiType type2 = parameter.getType();
            if (ChainCompletionContext.isWidelyUsed(type2)) continue;
            Collection contextVariables = context.getQualifiers(type2).collect(Collectors.toList());
            PsiElement contextVariable = (PsiElement)ContainerUtil.getFirstItem((Collection)contextVariables, null);
            if (contextVariable != null) {
                ++matchedParametersInContext;
                continue;
            }
            if (nullableNotNullManager.isNullable((PsiModifierListOwner)parameter, true)) continue;
            ++unreachableParametersCount;
        }
        Couple couple = Couple.of((Object)unreachableParametersCount, (Object)matchedParametersInContext);
        if (couple == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/compiler/chainsSearch/MethodChainLookupRangingHelper", "calculateParameterInfo"));
        }
        return couple;
    }

    @NotNull
    private static LookupElement createMethodLookupElement(@NotNull PsiMethod method) {
        TypedLookupItem result2;
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/compiler/chainsSearch/MethodChainLookupRangingHelper", "createMethodLookupElement"));
        }
        if (method.isConstructor()) {
            PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)method.getProject());
            result2 = new ExpressionLookupItem(elementFactory.createExpressionFromText("new " + method.getContainingClass().getQualifiedName() + "()", null));
        } else {
            result2 = method.hasModifierProperty("static") ? new JavaMethodCallElement(method, false, true) : new JavaMethodCallElement(method);
        }
        JavaMethodCallElement javaMethodCallElement = result2;
        if (javaMethodCallElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/compiler/chainsSearch/MethodChainLookupRangingHelper", "createMethodLookupElement"));
        }
        return javaMethodCallElement;
    }
}

