/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.chainsSearch;

import com.intellij.compiler.chainsSearch.MethodIncompleteSignature;
import org.jetbrains.annotations.NotNull;

public class SignatureAndOccurrences
implements Comparable<SignatureAndOccurrences> {
    private final MethodIncompleteSignature mySignature;
    private final int myOccurrences;

    public SignatureAndOccurrences(MethodIncompleteSignature signature, int occurrences) {
        this.mySignature = signature;
        this.myOccurrences = occurrences;
    }

    public MethodIncompleteSignature getSignature() {
        return this.mySignature;
    }

    public int getOccurrenceCount() {
        return this.myOccurrences;
    }

    @Override
    public int compareTo(@NotNull SignatureAndOccurrences that) {
        if (that == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "that", "com/intellij/compiler/chainsSearch/SignatureAndOccurrences", "compareTo"));
        }
        int sub = -this.getOccurrenceCount() + that.getOccurrenceCount();
        if (sub != 0) {
            return sub;
        }
        return this.mySignature.hashCode() - that.mySignature.hashCode();
    }

    public String toString() {
        return this.getOccurrenceCount() + " for " + this.mySignature;
    }
}

