/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.chainsSearch.context;

import com.intellij.compiler.CompilerReferenceService;
import com.intellij.compiler.backwardRefs.CompilerReferenceServiceEx;
import com.intellij.compiler.chainsSearch.MethodIncompleteSignature;
import com.intellij.compiler.chainsSearch.context.ChainSearchTarget;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.BaseScopeProcessor;
import com.intellij.psi.scope.ElementClassHint;
import com.intellij.psi.scope.util.PsiScopesUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.ClassUtil;
import com.intellij.psi.util.PropertyUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FactoryMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.backwardRefs.LightRef;

public class ChainCompletionContext {
    private static final String[] WIDELY_USED_CLASS_NAMES = new String[]{"java.lang.String", "java.lang.Object", "java.lang.Class"};
    private static final Set<String> WIDELY_USED_SHORT_NAMES = ContainerUtil.set((Object[])new String[]{"String", "Object", "Class"});
    @NotNull
    private final ChainSearchTarget myTarget;
    @NotNull
    private final List<PsiNamedElement> myContextElements;
    @NotNull
    private final PsiElement myContext;
    @NotNull
    private final GlobalSearchScope myResolveScope;
    @NotNull
    private final Project myProject;
    @NotNull
    private final PsiResolveHelper myResolveHelper;
    @NotNull
    private final FactoryMap<MethodIncompleteSignature, PsiClass> myQualifierClassResolver;
    @NotNull
    private final FactoryMap<MethodIncompleteSignature, PsiMethod[]> myResolver;
    private final NotNullLazyValue<Set<LightRef>> myContextClassReferences;

    public ChainCompletionContext(@NotNull ChainSearchTarget target2, @NotNull List<PsiNamedElement> contextElements, @NotNull PsiElement context) {
        if (target2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "com/intellij/compiler/chainsSearch/context/ChainCompletionContext", "<init>"));
        }
        if (contextElements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contextElements", "com/intellij/compiler/chainsSearch/context/ChainCompletionContext", "<init>"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/compiler/chainsSearch/context/ChainCompletionContext", "<init>"));
        }
        this.myContextClassReferences = new NotNullLazyValue<Set<LightRef>>(){

            @NotNull
            protected Set<LightRef> compute() {
                CompilerReferenceServiceEx referenceServiceEx = (CompilerReferenceServiceEx)CompilerReferenceService.getInstance(ChainCompletionContext.this.myProject);
                Set<LightRef> set2 = ChainCompletionContext.this.getContextTypes().stream().map(PsiUtil::resolveClassInType).filter(Objects::nonNull).map(c -> ClassUtil.getJVMClassName((PsiClass)c)).filter(Objects::nonNull).mapToInt(c -> referenceServiceEx.getNameId((String)c)).filter(n -> n != 0).mapToObj(n -> new LightRef.JavaLightClassRef(n)).collect(Collectors.toSet());
                if (set2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/compiler/chainsSearch/context/ChainCompletionContext$1", "compute"));
                }
                return set2;
            }
        };
        this.myTarget = target2;
        this.myContextElements = contextElements;
        this.myContext = context;
        this.myResolveScope = context.getResolveScope();
        this.myProject = context.getProject();
        this.myResolveHelper = PsiResolveHelper.SERVICE.getInstance((Project)this.myProject);
        this.myQualifierClassResolver = FactoryMap.createMap(sign -> sign.resolveQualifier(this.myProject, this.myResolveScope, this.accessValidator()));
        this.myResolver = FactoryMap.createMap(sign -> sign.resolve(this.myProject, this.myResolveScope, this.accessValidator()));
    }

    @NotNull
    public ChainSearchTarget getTarget() {
        ChainSearchTarget chainSearchTarget = this.myTarget;
        if (chainSearchTarget == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/compiler/chainsSearch/context/ChainCompletionContext", "getTarget"));
        }
        return chainSearchTarget;
    }

    public boolean contains(@Nullable PsiType type2) {
        if (type2 == null) {
            return false;
        }
        Set<PsiType> types = this.getContextTypes();
        if (types.contains(type2)) {
            return true;
        }
        for (PsiType contextType : types) {
            if (!type2.isAssignableFrom(contextType)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public PsiElement getContextPsi() {
        PsiElement psiElement = this.myContext;
        if (psiElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/compiler/chainsSearch/context/ChainCompletionContext", "getContextPsi"));
        }
        return psiElement;
    }

    public PsiFile getContextFile() {
        return this.myContext.getContainingFile();
    }

    @NotNull
    public Set<PsiType> getContextTypes() {
        Set<PsiType> set2 = this.myContextElements.stream().map(ChainCompletionContext::getType).collect(Collectors.toSet());
        if (set2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/compiler/chainsSearch/context/ChainCompletionContext", "getContextTypes"));
        }
        return set2;
    }

    @NotNull
    public Set<LightRef> getContextClassReferences() {
        Set set2 = (Set)this.myContextClassReferences.getValue();
        if (set2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/compiler/chainsSearch/context/ChainCompletionContext", "getContextClassReferences"));
        }
        return set2;
    }

    @NotNull
    public GlobalSearchScope getResolveScope() {
        GlobalSearchScope globalSearchScope = this.myResolveScope;
        if (globalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/compiler/chainsSearch/context/ChainCompletionContext", "getResolveScope"));
        }
        return globalSearchScope;
    }

    @NotNull
    public Project getProject() {
        Project project2 = this.myProject;
        if (project2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/compiler/chainsSearch/context/ChainCompletionContext", "getProject"));
        }
        return project2;
    }

    public boolean hasQualifier(@Nullable PsiClass targetClass) {
        return this.getQualifiers(targetClass).findAny().isPresent();
    }

    public Stream<PsiNamedElement> getQualifiers(@Nullable PsiClass targetClass) {
        if (targetClass == null) {
            return Stream.empty();
        }
        return this.getQualifiers((PsiType)JavaPsiFacade.getInstance((Project)this.myProject).getElementFactory().createType(targetClass));
    }

    public Stream<PsiNamedElement> getQualifiers(@NotNull PsiType targetType) {
        if (targetType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetType", "com/intellij/compiler/chainsSearch/context/ChainCompletionContext", "getQualifiers"));
        }
        return this.myContextElements.stream().filter(e -> {
            if (targetType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetType", "com/intellij/compiler/chainsSearch/context/ChainCompletionContext", "lambda$getQualifiers$2"));
            }
            PsiType elementType = ChainCompletionContext.getType((PsiElement)e);
            return elementType != null && targetType.isAssignableFrom(elementType);
        });
    }

    @Nullable
    public PsiClass resolveQualifierClass(MethodIncompleteSignature sign) {
        return (PsiClass)this.myQualifierClassResolver.get((Object)sign);
    }

    @NotNull
    public PsiMethod[] resolve(MethodIncompleteSignature sign) {
        PsiMethod[] psiMethodArray = (PsiMethod[])this.myResolver.get((Object)sign);
        if (psiMethodArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/compiler/chainsSearch/context/ChainCompletionContext", "resolve"));
        }
        return psiMethodArray;
    }

    private Predicate<PsiMember> accessValidator() {
        return m -> this.myResolveHelper.isAccessible(m, this.myContext, null);
    }

    @Nullable
    public static ChainCompletionContext createContext(@Nullable PsiType targetType, @Nullable PsiElement containingElement, boolean suggestIterators) {
        if (containingElement == null) {
            return null;
        }
        ChainSearchTarget target2 = ChainSearchTarget.create(targetType);
        if (target2 == null) {
            return null;
        }
        if (suggestIterators) {
            target2 = target2.toIterators();
        }
        ContextProcessor processor2 = new ContextProcessor(null, containingElement.getProject(), containingElement);
        PsiScopesUtil.treeWalkUp(processor2, containingElement, (PsiElement)containingElement.getContainingFile());
        List<PsiNamedElement> contextElements = processor2.getContextElements();
        return new ChainCompletionContext(target2, contextElements, containingElement);
    }

    @Nullable
    private static PsiType getType(PsiElement element) {
        if (element instanceof PsiVariable) {
            return ((PsiVariable)element).getType();
        }
        if (element instanceof PsiMethod) {
            return ((PsiMethod)element).getReturnType();
        }
        return null;
    }

    public static boolean isWidelyUsed(@NotNull PsiType type2) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/compiler/chainsSearch/context/ChainCompletionContext", "isWidelyUsed"));
        }
        if ((type2 = type2.getDeepComponentType()) instanceof PsiPrimitiveType) {
            return true;
        }
        if (!(type2 instanceof PsiClassType)) {
            return false;
        }
        if (WIDELY_USED_SHORT_NAMES.contains(((PsiClassType)type2).getClassName())) {
            return false;
        }
        PsiClass resolvedClass = ((PsiClassType)type2).resolve();
        if (resolvedClass == null) {
            return false;
        }
        String qName = resolvedClass.getQualifiedName();
        if (qName == null) {
            return false;
        }
        for (String name2 : WIDELY_USED_CLASS_NAMES) {
            if (!name2.equals(qName)) continue;
            return true;
        }
        return false;
    }

    private static class ContextProcessor
    extends BaseScopeProcessor
    implements ElementClassHint {
        private final List<PsiNamedElement> myContextElements;
        private final PsiVariable myCompletionVariable;
        private final PsiResolveHelper myResolveHelper;
        private final PsiElement myPlace;

        private ContextProcessor(@Nullable PsiVariable variable, @NotNull Project project2, @NotNull PsiElement place) {
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/compiler/chainsSearch/context/ChainCompletionContext$ContextProcessor", "<init>"));
            }
            if (place == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/compiler/chainsSearch/context/ChainCompletionContext$ContextProcessor", "<init>"));
            }
            this.myContextElements = new SmartList();
            this.myCompletionVariable = variable;
            this.myResolveHelper = PsiResolveHelper.SERVICE.getInstance((Project)project2);
            this.myPlace = place;
        }

        @Override
        public boolean shouldProcess(ElementClassHint.DeclarationKind kind2) {
            return kind2 == ElementClassHint.DeclarationKind.ENUM_CONST || kind2 == ElementClassHint.DeclarationKind.FIELD || kind2 == ElementClassHint.DeclarationKind.METHOD || kind2 == ElementClassHint.DeclarationKind.VARIABLE;
        }

        public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/compiler/chainsSearch/context/ChainCompletionContext$ContextProcessor", "execute"));
            }
            if (state == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/compiler/chainsSearch/context/ChainCompletionContext$ContextProcessor", "execute"));
            }
            if (!(element instanceof PsiMethod && !PropertyUtil.isSimplePropertyAccessor((PsiMethod)((PsiMethod)element)) || element instanceof PsiMember && !this.myResolveHelper.isAccessible((PsiMember)element, this.myPlace, null))) {
                PsiType type2 = ChainCompletionContext.getType(element);
                if (type2 == null) {
                    return false;
                }
                if (ChainCompletionContext.isWidelyUsed(type2)) {
                    return false;
                }
                this.myContextElements.add((PsiNamedElement)element);
            }
            return true;
        }

        @Override
        public <T> T getHint(@NotNull Key<T> hintKey) {
            if (hintKey == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hintKey", "com/intellij/compiler/chainsSearch/context/ChainCompletionContext$ContextProcessor", "getHint"));
            }
            if (hintKey == ElementClassHint.KEY) {
                return (T)this;
            }
            return super.getHint(hintKey);
        }

        @NotNull
        public List<PsiNamedElement> getContextElements() {
            this.myContextElements.remove(this.myCompletionVariable);
            List<PsiNamedElement> list2 = this.myContextElements;
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/compiler/chainsSearch/context/ChainCompletionContext$ContextProcessor", "getContextElements"));
            }
            return list2;
        }
    }
}

