/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.impl;

import com.intellij.compiler.CompilerEncodingService;
import com.intellij.openapi.compiler.CompilerManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.encoding.EncodingProjectManager;
import com.intellij.openapi.vfs.encoding.EncodingProjectManagerImpl;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashMap;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.JavaModuleSourceRootTypes;

public class CompilerEncodingServiceImpl
extends CompilerEncodingService {
    @NotNull
    private final Project myProject;
    private final CachedValue<Map<Module, Set<Charset>>> myModuleFileEncodings;

    public CompilerEncodingServiceImpl(@NotNull Project project2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/compiler/impl/CompilerEncodingServiceImpl", "<init>"));
        }
        this.myProject = project2;
        this.myModuleFileEncodings = CachedValuesManager.getManager((Project)project2).createCachedValue(() -> {
            Map<Module, Set<Charset>> result2 = this.computeModuleCharsetMap();
            return CachedValueProvider.Result.create(result2, (Object[])new Object[]{ProjectRootManager.getInstance((Project)this.myProject), ((EncodingProjectManagerImpl)EncodingProjectManager.getInstance((Project)this.myProject)).getModificationTracker()});
        }, false);
    }

    @NotNull
    private Map<Module, Set<Charset>> computeModuleCharsetMap() {
        THashMap map2 = new THashMap();
        Map<VirtualFile, Charset> mappings = ((EncodingProjectManagerImpl)EncodingProjectManager.getInstance((Project)this.myProject)).getAllMappings();
        ProjectFileIndex index = ProjectRootManager.getInstance((Project)this.myProject).getFileIndex();
        CompilerManager compilerManager = CompilerManager.getInstance((Project)this.myProject);
        for (Map.Entry<VirtualFile, Charset> entry : mappings.entrySet()) {
            Module module2;
            VirtualFile file2 = entry.getKey();
            Charset charset = entry.getValue();
            if (file2 == null || charset == null || !file2.isDirectory() && !compilerManager.isCompilableFileType(file2.getFileType()) || !index.isUnderSourceRootOfType(file2, JavaModuleSourceRootTypes.SOURCES) || (module2 = index.getModuleForFile(file2)) == null) continue;
            LinkedHashSet<Charset> set2 = (LinkedHashSet<Charset>)map2.get(module2);
            if (set2 == null) {
                set2 = new LinkedHashSet<Charset>();
                map2.put(module2, set2);
                VirtualFile sourceRoot = index.getSourceRootForFile(file2);
                Charset parentCharset = null;
                for (VirtualFile current = file2.getParent(); current != null; current = current.getParent()) {
                    Charset currentCharset = mappings.get(current);
                    if (currentCharset != null) {
                        parentCharset = currentCharset;
                    }
                    if (current.equals(sourceRoot)) break;
                }
                if (parentCharset != null) {
                    set2.add(parentCharset);
                }
            }
            set2.add(charset);
        }
        for (Module module3 : ModuleManager.getInstance((Project)this.myProject).getModules()) {
            for (VirtualFile file3 : ModuleRootManager.getInstance((Module)module3).getSourceRoots(true)) {
                Charset encoding = EncodingProjectManager.getInstance((Project)this.myProject).getEncoding(file3, true);
                if (encoding == null) continue;
                LinkedHashSet<Charset> charsets = (LinkedHashSet<Charset>)map2.get(module3);
                if (charsets == null) {
                    charsets = new LinkedHashSet<Charset>();
                    map2.put(module3, charsets);
                }
                charsets.add(encoding);
            }
        }
        THashMap tHashMap = map2;
        if (tHashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/compiler/impl/CompilerEncodingServiceImpl", "computeModuleCharsetMap"));
        }
        return tHashMap;
    }

    @Nullable
    public Charset getPreferredModuleEncoding(@NotNull Module module2) {
        if (module2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/compiler/impl/CompilerEncodingServiceImpl", "getPreferredModuleEncoding"));
        }
        Set encodings = (Set)((Map)this.myModuleFileEncodings.getValue()).get(module2);
        return (Charset)ContainerUtil.getFirstItem((Collection)encodings, (Object)EncodingProjectManager.getInstance((Project)this.myProject).getDefaultCharset());
    }

    @NotNull
    public Collection<Charset> getAllModuleEncodings(@NotNull Module module2) {
        if (module2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/compiler/impl/CompilerEncodingServiceImpl", "getAllModuleEncodings"));
        }
        Set encodings = (Set)((Map)this.myModuleFileEncodings.getValue()).get(module2);
        if (encodings != null) {
            Set set2 = encodings;
            if (set2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/compiler/impl/CompilerEncodingServiceImpl", "getAllModuleEncodings"));
            }
            return set2;
        }
        List list2 = ContainerUtil.createMaybeSingletonList((Object)EncodingProjectManager.getInstance((Project)this.myProject).getDefaultCharset());
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/compiler/impl/CompilerEncodingServiceImpl", "getAllModuleEncodings"));
        }
        return list2;
    }
}

