/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.inspection;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.daemon.GroupNames;
import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.refactoring.ui.MemberSelectionPanel;
import com.intellij.refactoring.util.classMembers.MemberInfo;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class ChangeSuperClassFix
implements LocalQuickFix,
HighPriorityAction {
    @NotNull
    private final SmartPsiElementPointer<PsiClass> myNewSuperClass;
    @NotNull
    private final SmartPsiElementPointer<PsiClass> myOldSuperClass;
    @NotNull
    private final SmartPsiElementPointer<PsiClass> myTargetClass;
    private final int myInheritorCount;
    @NotNull
    private final String myNewSuperName;
    private final boolean myImplements;

    public ChangeSuperClassFix(@NotNull PsiClass targetClass, @NotNull PsiClass newSuperClass, @NotNull PsiClass oldSuperClass, int percent, boolean isImplements) {
        if (targetClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetClass", "com/intellij/compiler/inspection/ChangeSuperClassFix", "<init>"));
        }
        if (newSuperClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newSuperClass", "com/intellij/compiler/inspection/ChangeSuperClassFix", "<init>"));
        }
        if (oldSuperClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldSuperClass", "com/intellij/compiler/inspection/ChangeSuperClassFix", "<init>"));
        }
        SmartPointerManager smartPointerManager = SmartPointerManager.getInstance((Project)newSuperClass.getProject());
        this.myNewSuperName = (String)ObjectUtils.notNull((Object)newSuperClass.getQualifiedName());
        this.myTargetClass = smartPointerManager.createSmartPsiElementPointer((PsiElement)targetClass);
        this.myNewSuperClass = smartPointerManager.createSmartPsiElementPointer((PsiElement)newSuperClass);
        this.myOldSuperClass = smartPointerManager.createSmartPsiElementPointer((PsiElement)oldSuperClass);
        this.myInheritorCount = percent;
        this.myImplements = isImplements;
    }

    @NotNull
    public PsiClass getNewSuperClass() {
        PsiClass psiClass = (PsiClass)ObjectUtils.notNull((Object)this.myNewSuperClass.getElement());
        if (psiClass == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/compiler/inspection/ChangeSuperClassFix", "getNewSuperClass"));
        }
        return psiClass;
    }

    public int getInheritorCount() {
        return this.myInheritorCount;
    }

    @NotNull
    public String getName() {
        String string = String.format("Make " + (this.myImplements ? "implements" : "extends") + " '%s'", this.myNewSuperName);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/compiler/inspection/ChangeSuperClassFix", "getName"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = GroupNames.INHERITANCE_GROUP_NAME;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/compiler/inspection/ChangeSuperClassFix", "getFamilyName"));
        }
        return string;
    }

    public boolean startInWriteAction() {
        return false;
    }

    public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor problemDescriptor) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/compiler/inspection/ChangeSuperClassFix", "applyFix"));
        }
        if (problemDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "problemDescriptor", "com/intellij/compiler/inspection/ChangeSuperClassFix", "applyFix"));
        }
        PsiClass oldSuperClass = (PsiClass)this.myOldSuperClass.getElement();
        PsiClass newSuperClass = (PsiClass)this.myNewSuperClass.getElement();
        if (oldSuperClass == null || newSuperClass == null) {
            return;
        }
        PsiElement element = this.myTargetClass.getElement();
        if (element == null || !FileModificationService.getInstance().preparePsiElementsForWrite(new PsiElement[]{element})) {
            return;
        }
        PsiClass aClass = (PsiClass)element;
        ChangeSuperClassFix.changeSuperClass(aClass, oldSuperClass, newSuperClass);
    }

    private static void changeSuperClass(@NotNull PsiClass aClass, @NotNull PsiClass oldSuperClass, @NotNull PsiClass newSuperClass) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/compiler/inspection/ChangeSuperClassFix", "changeSuperClass"));
        }
        if (oldSuperClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldSuperClass", "com/intellij/compiler/inspection/ChangeSuperClassFix", "changeSuperClass"));
        }
        if (newSuperClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newSuperClass", "com/intellij/compiler/inspection/ChangeSuperClassFix", "changeSuperClass"));
        }
        PsiMethod[] ownMethods = aClass.getMethods();
        List oldOverridenMethods = Stream.of(ownMethods).map(m -> {
            if (oldSuperClass == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldSuperClass", "com/intellij/compiler/inspection/ChangeSuperClassFix", "lambda$changeSuperClass$0"));
            }
            if (m.isConstructor()) {
                return null;
            }
            Object[] supers = m.findSuperMethods(oldSuperClass);
            if (supers.length == 0) {
                return null;
            }
            return Pair.create((Object)m, (Object)ContainerUtil.set((Object[])supers));
        }).filter(Objects::nonNull).collect(Collectors.toList());
        JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)aClass.getProject());
        PsiElementFactory factory = psiFacade.getElementFactory();
        WriteAction.run(() -> {
            PsiElement ref;
            if (aClass == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/compiler/inspection/ChangeSuperClassFix", "lambda$changeSuperClass$1"));
            }
            if (newSuperClass == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newSuperClass", "com/intellij/compiler/inspection/ChangeSuperClassFix", "lambda$changeSuperClass$1"));
            }
            if (oldSuperClass == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldSuperClass", "com/intellij/compiler/inspection/ChangeSuperClassFix", "lambda$changeSuperClass$1"));
            }
            if (aClass instanceof PsiAnonymousClass) {
                ref = ((PsiAnonymousClass)aClass).getBaseClassReference().replace((PsiElement)factory.createClassReferenceElement(newSuperClass));
            } else {
                PsiReferenceList list2;
                PsiJavaCodeReferenceElement[] refElements;
                PsiReferenceList extendsList = (PsiReferenceList)ObjectUtils.notNull((Object)aClass.getExtendsList());
                for (PsiJavaCodeReferenceElement refElement : refElements = (PsiJavaCodeReferenceElement[])ArrayUtil.mergeArrays((Object[])ChangeSuperClassFix.getReferences(extendsList), (Object[])ChangeSuperClassFix.getReferences(aClass.getImplementsList()))) {
                    if (!refElement.isReferenceTo((PsiElement)oldSuperClass)) continue;
                    refElement.delete();
                }
                if (newSuperClass.isInterface() && !aClass.isInterface()) {
                    list2 = aClass.getImplementsList();
                } else {
                    list2 = extendsList;
                    PsiJavaCodeReferenceElement[] elements = list2.getReferenceElements();
                    if (elements.length == 1 && elements[0].isReferenceTo((PsiElement)psiFacade.findClass("java.lang.Object", aClass.getResolveScope()))) {
                        elements[0].delete();
                    }
                }
                assert (list2 != null);
                ref = list2.add((PsiElement)factory.createClassReferenceElement(newSuperClass));
            }
            JavaCodeStyleManager.getInstance((Project)aClass.getProject()).shortenClassReferences(ref);
        });
        List<MemberInfo> memberInfos = oldOverridenMethods.stream().filter(m -> {
            if (newSuperClass == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newSuperClass", "com/intellij/compiler/inspection/ChangeSuperClassFix", "lambda$changeSuperClass$2"));
            }
            Set newSupers = ContainerUtil.set((Object[])((PsiMethod)m.getFirst()).findSuperMethods(newSuperClass));
            return !newSupers.equals(m.getSecond());
        }).map(m -> (PsiMethod)m.getFirst()).map(m -> {
            MemberInfo info = new MemberInfo((PsiMember)m);
            info.setChecked(true);
            return info;
        }).collect(Collectors.toList());
        if (memberInfos.isEmpty()) {
            return;
        }
        List<PsiMethod> toDelete = ChangeSuperClassFix.getOverridenMethodsToDelete(memberInfos, newSuperClass.getName(), aClass.getProject());
        if (!toDelete.isEmpty()) {
            WriteAction.run(() -> {
                for (PsiMethod method : toDelete) {
                    method.delete();
                }
            });
        }
    }

    @NotNull
    private static PsiJavaCodeReferenceElement[] getReferences(PsiReferenceList list2) {
        PsiJavaCodeReferenceElement[] psiJavaCodeReferenceElementArray = list2 == null ? PsiJavaCodeReferenceElement.EMPTY_ARRAY : list2.getReferenceElements();
        if (psiJavaCodeReferenceElementArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/compiler/inspection/ChangeSuperClassFix", "getReferences"));
        }
        return psiJavaCodeReferenceElementArray;
    }

    @NotNull
    private static List<PsiMethod> getOverridenMethodsToDelete(List<MemberInfo> candidates, String newClassName, Project project2) {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            List<PsiMethod> list2 = candidates.stream().map(c -> (PsiMethod)c.getMember()).collect(Collectors.toList());
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/compiler/inspection/ChangeSuperClassFix", "getOverridenMethodsToDelete"));
            }
            return list2;
        }
        final MemberSelectionPanel panel2 = new MemberSelectionPanel("<html>Choose members to delete since they are already defined in <b>" + newClassName + "</b>", candidates, null);
        DialogWrapper dlg = new DialogWrapper(project2, false){
            {
                super(arg0, arg1);
                this.setOKButtonText("Remove");
                this.setTitle("Choose Members");
                this.init();
            }

            @NotNull
            protected JComponent createCenterPanel() {
                MemberSelectionPanel memberSelectionPanel = panel2;
                if (memberSelectionPanel == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/compiler/inspection/ChangeSuperClassFix$1", "createCenterPanel"));
                }
                return memberSelectionPanel;
            }
        };
        List<Object> list3 = dlg.showAndGet() ? panel2.getTable().getSelectedMemberInfos().stream().map(info -> (PsiMethod)info.getMember()).collect(Collectors.toList()) : Collections.emptyList();
        if (list3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/compiler/inspection/ChangeSuperClassFix", "getOverridenMethodsToDelete"));
        }
        return list3;
    }
}

