/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.inspection;

import com.intellij.codeInspection.BaseJavaLocalInspectionTool;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.compiler.CompilerReferenceService;
import com.intellij.compiler.backwardRefs.CompilerReferenceServiceEx;
import com.intellij.compiler.backwardRefs.ReferenceIndexUnavailableException;
import com.intellij.compiler.inspection.ChangeSuperClassFix;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.impl.java.stubs.index.JavaFullClassNameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.util.SystemProperties;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import one.util.streamex.MoreCollectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.backwardRefs.LightRef;

public class FrequentlyUsedInheritorInspection
extends BaseJavaLocalInspectionTool {
    private static final Logger LOG = Logger.getInstance(FrequentlyUsedInheritorInspection.class);
    public static final byte MAX_RESULT = 3;
    private static final int PERCENT_THRESHOLD = SystemProperties.getIntProperty((String)"FrequentlyUsedInheritorInspection.percent.threshold", (int)20);

    @Nullable
    public ProblemDescriptor[] checkClass(@NotNull PsiClass aClass, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/compiler/inspection/FrequentlyUsedInheritorInspection", "checkClass"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/compiler/inspection/FrequentlyUsedInheritorInspection", "checkClass"));
        }
        if (aClass instanceof PsiTypeParameter || aClass.isEnum()) {
            return null;
        }
        Pair<PsiClass, PsiElement> superClassAndPlace = FrequentlyUsedInheritorInspection.getSuperIfOnlyOne(aClass);
        if (superClassAndPlace == null) {
            return null;
        }
        PsiClass superClass = (PsiClass)superClassAndPlace.getFirst();
        long ms = System.currentTimeMillis();
        List<ClassAndInheritorCount> topInheritors = FrequentlyUsedInheritorInspection.getTopInheritorsUsingCompilerIndices(superClass, aClass.getResolveScope(), (PsiElement)aClass);
        if (LOG.isDebugEnabled()) {
            LOG.debug("search for inheritance structure of " + superClass.getQualifiedName() + " in " + (System.currentTimeMillis() - ms) + " ms");
        }
        if (topInheritors.isEmpty()) {
            return null;
        }
        ArrayList<ChangeSuperClassFix> topInheritorsQuickFix = new ArrayList<ChangeSuperClassFix>(topInheritors.size());
        for (ClassAndInheritorCount searchResult : topInheritors) {
            PsiClass psi = searchResult.psi;
            if (InheritanceUtil.isInheritorOrSelf((PsiClass)psi, (PsiClass)aClass, (boolean)true)) continue;
            ChangeSuperClassFix quickFix = new ChangeSuperClassFix(aClass, psi, superClass, searchResult.number, searchResult.psi.isInterface() && !aClass.isInterface());
            topInheritorsQuickFix.add(quickFix);
            if (topInheritorsQuickFix.size() < 3) continue;
            break;
        }
        Object highlightingElement = aClass.getFields().length == 0 && aClass.getMethods().length == 0 && aClass.getInnerClasses().length == 0 && aClass.getInitializers().length == 0 ? aClass : (aClass instanceof PsiAnonymousClass ? ((PsiAnonymousClass)aClass).getBaseClassReference() : (PsiElement)superClassAndPlace.getSecond());
        return new ProblemDescriptor[]{manager.createProblemDescriptor((PsiElement)highlightingElement, "Class can have more common super class", isOnTheFly, topInheritorsQuickFix.toArray(LocalQuickFix.EMPTY_ARRAY), ProblemHighlightType.GENERIC_ERROR_OR_WARNING)};
    }

    @Nullable
    private static Pair<PsiClass, PsiElement> getSuperIfOnlyOne(@NotNull PsiClass aClass) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/compiler/inspection/FrequentlyUsedInheritorInspection", "getSuperIfOnlyOne"));
        }
        PsiClass superClass = aClass.getSuperClass();
        if (superClass != null && !"java.lang.Object".equals(superClass.getQualifiedName())) {
            return FrequentlyUsedInheritorInspection.isInSourceContent((PsiElement)aClass) ? Pair.create((Object)superClass, (Object)aClass.getExtendsList()) : null;
        }
        PsiClass anInterface = ((Optional)Arrays.stream(aClass.getInterfaces()).filter(c -> !"java.lang.Object".equals(c.getQualifiedName())).filter(c -> FrequentlyUsedInheritorInspection.isInSourceContent((PsiElement)c)).collect(MoreCollectors.onlyOne())).orElse(null);
        if (anInterface == null) {
            return null;
        }
        return Pair.create((Object)anInterface, (Object)(aClass.isInterface() ? aClass.getExtendsList() : aClass.getImplementsList()));
    }

    @NotNull
    private static List<ClassAndInheritorCount> getTopInheritorsUsingCompilerIndices(@NotNull PsiClass aClass, @NotNull GlobalSearchScope searchScope, @NotNull PsiElement place) {
        int id;
        CompilerReferenceServiceEx compilerRefService;
        Project project2;
        block11: {
            List<ClassAndInheritorCount> list2;
            if (aClass == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/compiler/inspection/FrequentlyUsedInheritorInspection", "getTopInheritorsUsingCompilerIndices"));
            }
            if (searchScope == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "searchScope", "com/intellij/compiler/inspection/FrequentlyUsedInheritorInspection", "getTopInheritorsUsingCompilerIndices"));
            }
            if (place == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/compiler/inspection/FrequentlyUsedInheritorInspection", "getTopInheritorsUsingCompilerIndices"));
            }
            String qName = aClass.getQualifiedName();
            if (qName == null) {
                List<ClassAndInheritorCount> list3 = Collections.emptyList();
                if (list3 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/compiler/inspection/FrequentlyUsedInheritorInspection", "getTopInheritorsUsingCompilerIndices"));
                }
                return list3;
            }
            project2 = aClass.getProject();
            compilerRefService = (CompilerReferenceServiceEx)CompilerReferenceService.getInstance(project2);
            try {
                id = compilerRefService.getNameId(qName);
                if (id != 0) break block11;
                list2 = Collections.emptyList();
            }
            catch (ReferenceIndexUnavailableException e) {
                List<ClassAndInheritorCount> list4 = Collections.emptyList();
                if (list4 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/compiler/inspection/FrequentlyUsedInheritorInspection", "getTopInheritorsUsingCompilerIndices"));
                }
                return list4;
            }
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/compiler/inspection/FrequentlyUsedInheritorInspection", "getTopInheritorsUsingCompilerIndices"));
            }
            return list2;
        }
        List<ClassAndInheritorCount> list5 = FrequentlyUsedInheritorInspection.findInheritors(aClass, new LightRef.JavaLightClassRef(id), searchScope, place, -1, project2, compilerRefService);
        if (list5 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/compiler/inspection/FrequentlyUsedInheritorInspection", "getTopInheritorsUsingCompilerIndices"));
        }
        return list5;
    }

    private static List<ClassAndInheritorCount> findInheritors(@NotNull PsiClass aClass, @NotNull LightRef.JavaLightClassRef classAsLightRef, @NotNull GlobalSearchScope searchScope, @NotNull PsiElement place, int hierarchyCardinality, @NotNull Project project2, @NotNull CompilerReferenceServiceEx compilerRefService) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/compiler/inspection/FrequentlyUsedInheritorInspection", "findInheritors"));
        }
        if (classAsLightRef == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classAsLightRef", "com/intellij/compiler/inspection/FrequentlyUsedInheritorInspection", "findInheritors"));
        }
        if (searchScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "searchScope", "com/intellij/compiler/inspection/FrequentlyUsedInheritorInspection", "findInheritors"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/compiler/inspection/FrequentlyUsedInheritorInspection", "findInheritors"));
        }
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/compiler/inspection/FrequentlyUsedInheritorInspection", "findInheritors"));
        }
        if (compilerRefService == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "compilerRefService", "com/intellij/compiler/inspection/FrequentlyUsedInheritorInspection", "findInheritors"));
        }
        LightRef.LightClassHierarchyElementDef[] directInheritors = compilerRefService.getDirectInheritors((LightRef.LightClassHierarchyElementDef)classAsLightRef);
        if (hierarchyCardinality == -1 && (hierarchyCardinality = compilerRefService.getInheritorCount((LightRef.LightClassHierarchyElementDef)classAsLightRef)) == -1) {
            return Collections.emptyList();
        }
        int finalHierarchyCardinality = hierarchyCardinality;
        List directInheritorStats = Stream.of(directInheritors).filter(inheritor -> !(inheritor instanceof LightRef.LightAnonymousClassDef)).map(inheritor -> {
            if (compilerRefService == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "compilerRefService", "com/intellij/compiler/inspection/FrequentlyUsedInheritorInspection", "lambda$findInheritors$3"));
            }
            ProgressManager.checkCanceled();
            int count = compilerRefService.getInheritorCount((LightRef.LightClassHierarchyElementDef)inheritor);
            if (count != 1 && count * 100 > finalHierarchyCardinality * PERCENT_THRESHOLD) {
                return new Object((LightRef.LightClassHierarchyElementDef)inheritor, count){
                    final LightRef.LightClassHierarchyElementDef myDef;
                    final int inheritorCount;
                    final /* synthetic */ LightRef.LightClassHierarchyElementDef val$inheritor;
                    final /* synthetic */ int val$count;
                    {
                        this.val$inheritor = lightClassHierarchyElementDef;
                        this.val$count = n;
                        this.myDef = this.val$inheritor;
                        this.inheritorCount = this.val$count;
                    }
                };
            }
            return null;
        }).filter(Objects::nonNull).map(defAndCount -> {
            if (compilerRefService == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "compilerRefService", "com/intellij/compiler/inspection/FrequentlyUsedInheritorInspection", "lambda$findInheritors$5"));
            }
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/compiler/inspection/FrequentlyUsedInheritorInspection", "lambda$findInheritors$5"));
            }
            if (searchScope == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "searchScope", "com/intellij/compiler/inspection/FrequentlyUsedInheritorInspection", "lambda$findInheritors$5"));
            }
            if (aClass == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/compiler/inspection/FrequentlyUsedInheritorInspection", "lambda$findInheritors$5"));
            }
            String name2 = compilerRefService.getName(defAndCount.myDef.getName());
            PsiClass inheritor = ((Optional)JavaFullClassNameIndex.getInstance().get(name2.hashCode(), project2, searchScope).stream().filter(cls -> name2.equals(cls.getQualifiedName())).collect(MoreCollectors.onlyOne())).orElse(null);
            if (inheritor == null || !inheritor.isInheritor(aClass, false)) {
                return null;
            }
            return new ClassAndInheritorCount(inheritor, defAndCount.myDef, defAndCount.inheritorCount);
        }).filter(Objects::nonNull).collect(Collectors.toList());
        PsiResolveHelper resolveHelper = PsiResolveHelper.SERVICE.getInstance((Project)project2);
        return directInheritorStats.stream().filter(c -> {
            if (place == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/compiler/inspection/FrequentlyUsedInheritorInspection", "lambda$findInheritors$6"));
            }
            return resolveHelper.isAccessible((PsiMember)((ClassAndInheritorCount)c).psi, place, null);
        }).flatMap(c -> {
            if (searchScope == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "searchScope", "com/intellij/compiler/inspection/FrequentlyUsedInheritorInspection", "lambda$findInheritors$7"));
            }
            if (place == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/compiler/inspection/FrequentlyUsedInheritorInspection", "lambda$findInheritors$7"));
            }
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/compiler/inspection/FrequentlyUsedInheritorInspection", "lambda$findInheritors$7"));
            }
            if (compilerRefService == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "compilerRefService", "com/intellij/compiler/inspection/FrequentlyUsedInheritorInspection", "lambda$findInheritors$7"));
            }
            return Stream.concat(Stream.of(c), FrequentlyUsedInheritorInspection.getClassesIfInterface(c, finalHierarchyCardinality, searchScope, place, project2, compilerRefService).stream());
        }).sorted().limit(3L).collect(Collectors.toList());
    }

    private static List<ClassAndInheritorCount> getClassesIfInterface(@NotNull ClassAndInheritorCount classAndInheritorCount, int hierarchyCardinality, GlobalSearchScope searchScope, PsiElement place, Project project2, CompilerReferenceServiceEx compilerRefService) {
        if (classAndInheritorCount == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classAndInheritorCount", "com/intellij/compiler/inspection/FrequentlyUsedInheritorInspection", "getClassesIfInterface"));
        }
        if (classAndInheritorCount.psi.isInterface()) {
            return FrequentlyUsedInheritorInspection.findInheritors(classAndInheritorCount.psi, (LightRef.JavaLightClassRef)classAndInheritorCount.descriptor, searchScope, place, hierarchyCardinality, project2, compilerRefService);
        }
        return Collections.emptyList();
    }

    private static boolean isInSourceContent(@NotNull PsiElement e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/compiler/inspection/FrequentlyUsedInheritorInspection", "isInSourceContent"));
        }
        VirtualFile file2 = e.getContainingFile().getVirtualFile();
        if (file2 == null) {
            return false;
        }
        ProjectFileIndex index = ProjectRootManager.getInstance((Project)e.getProject()).getFileIndex();
        return index.isInContent(file2);
    }

    private static class ClassAndInheritorCount
    implements Comparable<ClassAndInheritorCount> {
        private final PsiClass psi;
        private final LightRef.LightClassHierarchyElementDef descriptor;
        private final int number;

        private ClassAndInheritorCount(PsiClass psi, LightRef.LightClassHierarchyElementDef descriptor, int number) {
            this.psi = psi;
            this.descriptor = descriptor;
            this.number = number;
        }

        @Override
        public int compareTo(@NotNull ClassAndInheritorCount o) {
            if (o == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/compiler/inspection/FrequentlyUsedInheritorInspection$ClassAndInheritorCount", "compareTo"));
            }
            return -this.number + o.number;
        }
    }
}

