/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.configurationStore;

import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.StateSplitterEx;
import com.intellij.openapi.components.StateStorage;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.components.StorageScheme;
import java.lang.annotation.Annotation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FileStorageAnnotation
implements Storage {
    private String path;
    private boolean deprecated;
    private final Class<? extends StateStorage> storageClass;

    public FileStorageAnnotation(@NotNull String path, boolean deprecated) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/configurationStore/FileStorageAnnotation", "<init>"));
        }
        this(path, deprecated, StateStorage.class);
    }

    public FileStorageAnnotation(@NotNull String path, boolean deprecated, @Nullable Class<? extends StateStorage> storageClass) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/configurationStore/FileStorageAnnotation", "<init>"));
        }
        this.path = path;
        this.deprecated = deprecated;
        this.storageClass = storageClass;
    }

    public String id() {
        return "default";
    }

    public boolean exclusive() {
        return false;
    }

    public String file() {
        return this.value();
    }

    public String value() {
        return this.path;
    }

    public StorageScheme scheme() {
        return StorageScheme.DEFAULT;
    }

    public boolean deprecated() {
        return this.deprecated;
    }

    public RoamingType roamingType() {
        return RoamingType.DEFAULT;
    }

    public Class<? extends StateStorage> storageClass() {
        return this.storageClass;
    }

    public Class<StateSplitterEx> stateSplitter() {
        return StateSplitterEx.class;
    }

    @NotNull
    public Class<? extends Annotation> annotationType() {
        throw new UnsupportedOperationException("Method annotationType not implemented in " + this.getClass());
    }
}

