/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.core;

import com.intellij.core.CoreModule;
import com.intellij.core.CoreProjectLoader;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.impl.ModuleEx;
import com.intellij.openapi.module.impl.ModuleManagerImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.impl.ModuleRootManagerImpl;
import com.intellij.openapi.vfs.StandardFileSystems;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.IOException;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NotNull;

public class CoreModuleManager
extends ModuleManagerImpl {
    private final Disposable myParentDisposable;

    public CoreModuleManager(Project project2, Disposable parentDisposable) {
        super(project2);
        this.myParentDisposable = parentDisposable;
    }

    @Override
    @NotNull
    protected ModuleEx createModule(@NotNull String filePath) {
        if (filePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePath", "com/intellij/core/CoreModuleManager", "createModule"));
        }
        CoreModule coreModule = new CoreModule(this.myParentDisposable, this.myProject, filePath);
        if (coreModule == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/core/CoreModuleManager", "createModule"));
        }
        return coreModule;
    }

    @Override
    @NotNull
    protected ModuleEx createAndLoadModule(@NotNull String filePath) throws IOException {
        if (filePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePath", "com/intellij/core/CoreModuleManager", "createAndLoadModule"));
        }
        ModuleEx module2 = this.createModule(filePath);
        VirtualFile vFile = StandardFileSystems.local().findFileByPath(filePath);
        try {
            assert (vFile != null);
            ModuleRootManagerImpl.ModuleRootManagerState state = new ModuleRootManagerImpl.ModuleRootManagerState();
            state.readExternal(CoreProjectLoader.loadStorageFile((ComponentManager)module2, vFile).get("NewModuleRootManager"));
            ((ModuleRootManagerImpl)ModuleRootManager.getInstance((Module)module2)).loadState(state);
        }
        catch (JDOMException e) {
            throw new IOException(e);
        }
        ModuleEx moduleEx = module2;
        if (moduleEx == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/core/CoreModuleManager", "createAndLoadModule"));
        }
        return moduleEx;
    }

    @Override
    protected void deliverPendingEvents() {
    }

    public void loadModules() {
        this.loadModules(this.myModuleModel);
    }

    protected Disposable getLifetime() {
        return this.myParentDisposable;
    }
}

