/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.credentialStore;

import com.intellij.credentialStore.CredentialAttributes;
import com.intellij.credentialStore.CredentialStore;
import com.intellij.credentialStore.Credentials;
import com.intellij.credentialStore.OneTimeString;
import com.intellij.credentialStore.SecureString;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.io.IoKt;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=2, d1={"\u0000P\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\u001a\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u001a\u001c\u0010\n\u001a\u0004\u0018\u00010\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f\u001a\u001e\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\r0\u00112\u0006\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u0001H\u0002\u001a\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00152\b\u0010\u0012\u001a\u0004\u0018\u00010\r\u001a\u001a\u0010\u0016\u001a\u00020\u00172\n\u0010\u0018\u001a\u0006\u0012\u0002\b\u00030\u00192\u0006\u0010\u001a\u001a\u00020\r\u001a\u0010\u0010\u0016\u001a\u00020\r2\u0006\u0010\u001b\u001a\u00020\u000bH\u0002\u001a\u0010\u0010\u001c\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u000bH\u0000\u001a\u0016\u0010\u001d\u001a\u00020\u000b*\u00020\u00152\b\b\u0002\u0010\u001e\u001a\u00020\u001fH\u0007\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006 "}, d2={"ESCAPING_CHAR", "", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "SecureString", "Lcom/intellij/credentialStore/SecureString;", "value", "", "joinData", "", "user", "", "password", "Lcom/intellij/credentialStore/OneTimeString;", "parseString", "", "data", "delimiter", "splitData", "Lcom/intellij/credentialStore/Credentials;", "toOldKey", "Lcom/intellij/credentialStore/CredentialAttributes;", "requestor", "Ljava/lang/Class;", "userName", "hash", "toOldKeyAsIdentity", "serialize", "storePassword", "", "credential-store"})
public final class CredentialStoreKt {
    @NotNull
    private static final Logger LOG = Logger.getInstance(CredentialStore.class);
    private static final char ESCAPING_CHAR = '\\';

    @NotNull
    public static final Logger getLOG() {
        return LOG;
    }

    private static final String toOldKey(byte[] hash) {
        return "old-hashed-key|" + Base64.getEncoder().encodeToString(hash);
    }

    @NotNull
    public static final CredentialAttributes toOldKeyAsIdentity(@NotNull byte[] hash) {
        Intrinsics.checkParameterIsNotNull((Object)hash, (String)"hash");
        return new CredentialAttributes("IntelliJ Platform", CredentialStoreKt.toOldKey(hash), null, false, 12, null);
    }

    @NotNull
    public static final CredentialAttributes toOldKey(@NotNull Class<?> requestor, @NotNull String userName) {
        CredentialAttributes credentialAttributes;
        Intrinsics.checkParameterIsNotNull(requestor, (String)"requestor");
        Intrinsics.checkParameterIsNotNull((Object)userName, (String)"userName");
        String string = "" + requestor.getName() + '/' + userName;
        MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
        String string2 = "IntelliJ Platform";
        CredentialAttributes credentialAttributes2 = credentialAttributes;
        CredentialAttributes credentialAttributes3 = credentialAttributes;
        Charset charset = Charsets.UTF_8;
        String string3 = string;
        if (string3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        byte[] byArray = string3.getBytes(charset);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        byte[] byArray2 = byArray;
        byte[] byArray3 = messageDigest.digest(byArray2);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray3, (String)"MessageDigest.getInstanc\u2026$userName\".toByteArray())");
        credentialAttributes2(string2, CredentialStoreKt.toOldKey(byArray3), null, false, 12, null);
        return credentialAttributes3;
    }

    @Nullable
    public static final byte[] joinData(@Nullable String user, @Nullable OneTimeString password) {
        StringBuilder stringBuilder;
        if (user == null && password == null) {
            return null;
        }
        String string = user;
        StringBuilder stringBuilder2 = stringBuilder;
        StringBuilder stringBuilder3 = stringBuilder;
        String string2 = string;
        if (string2 == null) {
            string2 = "";
        }
        String string3 = string2;
        stringBuilder2(string3);
        StringBuilder builder = stringBuilder3;
        StringUtil.escapeChar((StringBuilder)builder, (char)'\\');
        StringUtil.escapeChar((StringBuilder)builder, (char)'@');
        if (password != null) {
            builder.append('@');
            password.appendTo(builder);
        }
        ByteBuffer buffer = Charsets.UTF_8.encode(CharBuffer.wrap(builder));
        builder.setLength(0);
        return IoKt.toByteArray((ByteBuffer)buffer);
    }

    @Nullable
    public static final Credentials splitData(@Nullable String data) {
        CharSequence charSequence = data;
        if (charSequence == null || charSequence.length() == 0) {
            return null;
        }
        String string = data;
        if (string == null) {
            Intrinsics.throwNpe();
        }
        List<String> list2 = CredentialStoreKt.parseString(string, '@');
        return new Credentials((String)CollectionsKt.getOrNull(list2, (int)0), (String)CollectionsKt.getOrNull(list2, (int)1));
    }

    private static final List<String> parseString(String data, char delimiter) {
        Character c;
        StringBuilder part = new StringBuilder();
        ArrayList<String> result2 = new ArrayList<String>(2);
        int i2 = 0;
        do {
            if ((c = StringsKt.getOrNull((CharSequence)data, (int)i2++)) != null && Intrinsics.areEqual((Object)c, (Object)Character.valueOf(delimiter)) ^ true) {
                if (Intrinsics.areEqual((Object)c, (Object)Character.valueOf('\\'))) {
                    c = StringsKt.getOrNull((CharSequence)data, (int)i2++);
                }
                if (c != null) {
                    part.append(c.charValue());
                    continue;
                }
            }
            result2.add(part.toString());
            part.setLength(0);
            if (i2 >= data.length()) continue;
            String string = data;
            ArrayList<String> arrayList = result2;
            String string2 = string;
            if (string2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string3 = string2.substring(i2);
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
            String string4 = string3;
            arrayList.add(string4);
            break;
        } while (c != null);
        return result2;
    }

    @JvmOverloads
    @NotNull
    public static final byte[] serialize(@NotNull Credentials $receiver, boolean storePassword) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        byte[] byArray = CredentialStoreKt.joinData($receiver.getUserName(), storePassword ? $receiver.getPassword() : null);
        if (byArray == null) {
            Intrinsics.throwNpe();
        }
        return byArray;
    }

    @JvmOverloads
    @NotNull
    public static /* bridge */ /* synthetic */ byte[] serialize$default(Credentials credentials, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        return CredentialStoreKt.serialize(credentials, bl);
    }

    @JvmOverloads
    @NotNull
    public static final byte[] serialize(@NotNull Credentials $receiver) {
        return CredentialStoreKt.serialize$default($receiver, false, 1, null);
    }

    @NotNull
    public static final SecureString SecureString(@NotNull CharSequence value2) {
        Intrinsics.checkParameterIsNotNull((Object)value2, (String)"value");
        return new SecureString(IoKt.toByteArray((ByteBuffer)Charsets.UTF_8.encode(CharBuffer.wrap(value2))));
    }
}

