/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.credentialStore.kdbx;

import com.intellij.credentialStore.kdbx.ConstantValueCreator;
import com.intellij.credentialStore.kdbx.DateValueCreator;
import com.intellij.credentialStore.kdbx.UuidValueCreator;
import com.intellij.credentialStore.kdbx.ValueCreator;
import com.intellij.util.JdomKt;
import java.nio.ByteBuffer;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.Base64;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jdom.Element;
import org.jdom.xpath.XPath;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=2, d1={"\u00006\n\u0000\n\u0002\u0010\u000e\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\u001a\u0010\u0010\u0018\u001a\u00020\u00012\u0006\u0010\u0019\u001a\u00020\u001aH\u0002\u001a\b\u0010\u001b\u001a\u00020\u0001H\u0000\u001a\u0018\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u00012\u0006\u0010\u001f\u001a\u00020\u001dH\u0002\u001a$\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u001d2\u0012\u0010#\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00170\u0016H\u0000\u001a\u0010\u0010$\u001a\n \u0010*\u0004\u0018\u00010\u00010\u0001H\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0007\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\b\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\t\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\n\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000b\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\f\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\r\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\"\u0010\u000e\u001a\n \u0010*\u0004\u0018\u00010\u000f0\u000fX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014\"\u001a\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00170\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"CREATION_TIME_ELEMENT_NAME", "", "ENTRY_ELEMENT_NAME", "EXPIRES_ELEMENT_NAME", "EXPIRY_TIME_ELEMENT_NAME", "GROUP_ELEMENT_NAME", "ICON_ELEMENT_NAME", "LAST_ACCESS_TIME_ELEMENT_NAME", "LAST_MODIFICATION_TIME_ELEMENT_NAME", "LOCATION_CHANGED", "NAME_ELEMENT_NAME", "ROOT_ELEMENT_NAME", "USAGE_COUNT_ELEMENT_NAME", "UUID_ELEMENT_NAME", "dateFormatter", "Ljava/time/format/DateTimeFormatter;", "kotlin.jvm.PlatformType", "getDateFormatter", "()Ljava/time/format/DateTimeFormatter;", "setDateFormatter", "(Ljava/time/format/DateTimeFormatter;)V", "mandatoryEntryElements", "", "Lcom/intellij/credentialStore/kdbx/ValueCreator;", "base64FromUuid", "uuid", "Ljava/util/UUID;", "base64RandomUuid", "createHierarchically", "Lorg/jdom/Element;", "elementPath", "startElement", "ensureElements", "", "element", "childElements", "formattedNow", "credential-store"})
public final class KeePassDatabaseKt {
    @NotNull
    public static final String LOCATION_CHANGED = "Times/LocationChanged";
    @NotNull
    public static final String USAGE_COUNT_ELEMENT_NAME = "Times/UsageCount";
    @NotNull
    public static final String EXPIRES_ELEMENT_NAME = "Times/Expires";
    @NotNull
    public static final String GROUP_ELEMENT_NAME = "Group";
    @NotNull
    public static final String ENTRY_ELEMENT_NAME = "Entry";
    @NotNull
    public static final String ICON_ELEMENT_NAME = "IconID";
    @NotNull
    public static final String UUID_ELEMENT_NAME = "UUID";
    @NotNull
    public static final String NAME_ELEMENT_NAME = "Name";
    @NotNull
    public static final String LAST_MODIFICATION_TIME_ELEMENT_NAME = "Times/LastModificationTime";
    @NotNull
    public static final String CREATION_TIME_ELEMENT_NAME = "Times/CreationTime";
    @NotNull
    public static final String LAST_ACCESS_TIME_ELEMENT_NAME = "Times/LastAccessTime";
    @NotNull
    public static final String EXPIRY_TIME_ELEMENT_NAME = "Times/ExpiryTime";
    private static final String ROOT_ELEMENT_NAME = "Root";
    private static DateTimeFormatter dateFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss'Z'");
    private static final Map<String, ValueCreator> mandatoryEntryElements = MapsKt.linkedMapOf((Pair[])new Pair[]{TuplesKt.to((Object)"UUID", (Object)new UuidValueCreator()), TuplesKt.to((Object)"IconID", (Object)new ConstantValueCreator("0")), TuplesKt.to((Object)"Times/CreationTime", (Object)new DateValueCreator()), TuplesKt.to((Object)"Times/LastModificationTime", (Object)new DateValueCreator()), TuplesKt.to((Object)"Times/LastAccessTime", (Object)new DateValueCreator()), TuplesKt.to((Object)"Times/ExpiryTime", (Object)new DateValueCreator()), TuplesKt.to((Object)"Times/Expires", (Object)new ConstantValueCreator("False")), TuplesKt.to((Object)"Times/UsageCount", (Object)new ConstantValueCreator("0")), TuplesKt.to((Object)"Times/LocationChanged", (Object)new DateValueCreator())});

    public static final DateTimeFormatter getDateFormatter() {
        return dateFormatter;
    }

    public static final void setDateFormatter(DateTimeFormatter dateTimeFormatter) {
        dateFormatter = dateTimeFormatter;
    }

    public static final void ensureElements(@NotNull Element element, @NotNull Map<String, ? extends ValueCreator> childElements) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        Intrinsics.checkParameterIsNotNull(childElements, (String)"childElements");
        Map<String, ? extends ValueCreator> map2 = childElements;
        Iterator<Map.Entry<String, ? extends ValueCreator>> iterator = map2.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, ? extends ValueCreator> entry;
            Map.Entry<String, ? extends ValueCreator> entry2 = entry = iterator.next();
            String elementPath = entry2.getKey();
            entry2 = entry;
            ValueCreator value2 = entry2.getValue();
            Object result2 = XPath.newInstance((String)elementPath).selectSingleNode((Object)element);
            if (result2 != null) continue;
            result2 = KeePassDatabaseKt.createHierarchically(elementPath, element);
            result2.setText(value2.getValue());
        }
    }

    private static final Element createHierarchically(String elementPath, Element startElement) {
        Element currentElement = startElement;
        for (String elementName : StringsKt.split$default((CharSequence)elementPath, (char[])new char[]{'/'}, (boolean)false, (int)0, (int)6, null)) {
            currentElement = JdomKt.getOrCreate((Element)currentElement, (String)elementName);
        }
        return currentElement;
    }

    public static final String formattedNow() {
        return LocalDateTime.now(ZoneOffset.UTC).format(dateFormatter);
    }

    @NotNull
    public static final String base64RandomUuid() {
        UUID uUID = UUID.randomUUID();
        Intrinsics.checkExpressionValueIsNotNull((Object)uUID, (String)"UUID.randomUUID()");
        return KeePassDatabaseKt.base64FromUuid(uUID);
    }

    private static final String base64FromUuid(UUID uuid) {
        ByteBuffer b = ByteBuffer.wrap(new byte[16]);
        b.putLong(uuid.getMostSignificantBits());
        b.putLong(uuid.getLeastSignificantBits());
        String string = Base64.getEncoder().encodeToString(b.array());
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"Base64.getEncoder().encodeToString(b.array())");
        return string;
    }

    @NotNull
    public static final /* synthetic */ Map access$getMandatoryEntryElements$p() {
        return mandatoryEntryElements;
    }
}

