/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.actions;

import com.intellij.debugger.actions.DebuggerAction;
import com.intellij.debugger.actions.ViewAsGroup;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.JavaValue;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.events.SuspendContextCommandImpl;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.settings.ArrayRendererConfigurable;
import com.intellij.debugger.ui.impl.watch.DebuggerTreeNodeImpl;
import com.intellij.debugger.ui.impl.watch.NodeDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.ValueDescriptorImpl;
import com.intellij.debugger.ui.tree.render.ArrayFilterInplaceEditor;
import com.intellij.debugger.ui.tree.render.ArrayRenderer;
import com.intellij.debugger.ui.tree.render.ChildrenRenderer;
import com.intellij.debugger.ui.tree.render.CompoundNodeRenderer;
import com.intellij.debugger.ui.tree.render.ExpressionChildrenRenderer;
import com.intellij.debugger.ui.tree.render.NodeRenderer;
import com.intellij.debugger.ui.tree.render.Renderer;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.impl.ui.tree.actions.XDebuggerTreeActionBase;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueNodeImpl;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

public abstract class ArrayAction
extends DebuggerAction {
    public void actionPerformed(AnActionEvent e) {
        DebuggerContextImpl debuggerContext = DebuggerAction.getDebuggerContext(e.getDataContext());
        DebugProcessImpl debugProcess = debuggerContext.getDebugProcess();
        if (debugProcess == null) {
            return;
        }
        XValueNodeImpl node = XDebuggerTreeActionBase.getSelectedNode(e.getDataContext());
        if (node == null) {
            return;
        }
        ArrayRenderer renderer = ArrayAction.getArrayRenderer((XValue)node.getValueContainer());
        if (renderer == null) {
            return;
        }
        this.createNewRenderer(node, renderer, debuggerContext, node.getName()).done(newRenderer -> ArrayAction.setArrayRenderer(newRenderer, node, debuggerContext));
    }

    @NotNull
    protected abstract Promise<ArrayRenderer> createNewRenderer(XValueNodeImpl var1, ArrayRenderer var2, @NotNull DebuggerContextImpl var3, String var4);

    public void update(AnActionEvent e) {
        boolean enable = false;
        List<JavaValue> values = ViewAsGroup.getSelectedValues(e);
        if (values.size() == 1) {
            enable = ArrayAction.getArrayRenderer((XValue)values.get(0)) != null;
        }
        e.getPresentation().setEnabledAndVisible(enable);
    }

    @Nullable
    public static ArrayRenderer getArrayRenderer(XValue value2) {
        if (value2 instanceof JavaValue) {
            NodeRenderer lastChildrenRenderer;
            ValueDescriptorImpl descriptor = ((JavaValue)value2).getDescriptor();
            Renderer lastRenderer = descriptor.getLastRenderer();
            if (lastRenderer instanceof ArrayRenderer) {
                return (ArrayRenderer)lastRenderer;
            }
            if (lastRenderer instanceof CompoundNodeRenderer && ((CompoundNodeRenderer)lastRenderer).getChildrenRenderer() instanceof ExpressionChildrenRenderer && (lastChildrenRenderer = ExpressionChildrenRenderer.getLastChildrenRenderer(descriptor)) instanceof ArrayRenderer) {
                return (ArrayRenderer)lastChildrenRenderer;
            }
        }
        return null;
    }

    public static void setArrayRenderer(final ArrayRenderer newRenderer, final @NotNull XValueNodeImpl node, @NotNull DebuggerContextImpl debuggerContext) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/debugger/actions/ArrayAction", "setArrayRenderer"));
        }
        if (debuggerContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debuggerContext", "com/intellij/debugger/actions/ArrayAction", "setArrayRenderer"));
        }
        final XValue container = (XValue)node.getValueContainer();
        ArrayRenderer renderer = ArrayAction.getArrayRenderer(container);
        if (renderer == null) {
            return;
        }
        final ValueDescriptorImpl descriptor = ((JavaValue)container).getDescriptor();
        DebugProcessImpl debugProcess = debuggerContext.getDebugProcess();
        if (debugProcess != null) {
            debugProcess.getManagerThread().schedule(new SuspendContextCommandImpl(debuggerContext.getSuspendContext()){

                @Override
                public void contextAction(@NotNull SuspendContextImpl suspendContext) throws Exception {
                    CompoundNodeRenderer compoundRenderer;
                    ChildrenRenderer childrenRenderer;
                    if (suspendContext == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suspendContext", "com/intellij/debugger/actions/ArrayAction$1", "contextAction"));
                    }
                    Renderer lastRenderer = descriptor.getLastRenderer();
                    if (lastRenderer instanceof ArrayRenderer) {
                        ((JavaValue)container).setRenderer(newRenderer, node);
                        node.invokeNodeUpdate(() -> {
                            if (node == null) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/debugger/actions/ArrayAction$1", "lambda$contextAction$0"));
                            }
                            node.getTree().expandPath(node.getPath());
                        });
                    } else if (lastRenderer instanceof CompoundNodeRenderer && (childrenRenderer = (compoundRenderer = (CompoundNodeRenderer)lastRenderer).getChildrenRenderer()) instanceof ExpressionChildrenRenderer) {
                        ExpressionChildrenRenderer.setPreferableChildrenRenderer(descriptor, newRenderer);
                        ((JavaValue)container).reBuild(node);
                    }
                }
            });
        }
    }

    private static String createNodeTitle(String prefix, DebuggerTreeNodeImpl node) {
        if (node != null) {
            DebuggerTreeNodeImpl parent = node.getParent();
            NodeDescriptorImpl descriptor = parent.getDescriptor();
            if (descriptor instanceof ValueDescriptorImpl && ((ValueDescriptorImpl)descriptor).isArray()) {
                int index = parent.getIndex(node);
                return ArrayAction.createNodeTitle(prefix, parent) + "[" + index + "]";
            }
            String name2 = node.getDescriptor() != null ? node.getDescriptor().getName() : null;
            return name2 != null ? prefix + " " + name2 : prefix;
        }
        return prefix;
    }

    private static class FilterArrayAction
    extends ArrayAction {
        private FilterArrayAction() {
        }

        @Override
        @NotNull
        protected Promise<ArrayRenderer> createNewRenderer(XValueNodeImpl node, ArrayRenderer original, @NotNull DebuggerContextImpl debuggerContext, String title) {
            if (debuggerContext == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debuggerContext", "com/intellij/debugger/actions/ArrayAction$FilterArrayAction", "createNewRenderer"));
            }
            ArrayFilterInplaceEditor.editParent(node);
            Promise promise2 = Promises.rejectedPromise();
            if (promise2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/actions/ArrayAction$FilterArrayAction", "createNewRenderer"));
            }
            return promise2;
        }
    }

    private static class AdjustArrayRangeAction
    extends ArrayAction {
        private AdjustArrayRangeAction() {
        }

        @Override
        @NotNull
        protected Promise<ArrayRenderer> createNewRenderer(XValueNodeImpl node, ArrayRenderer original, @NotNull DebuggerContextImpl debuggerContext, String title) {
            if (debuggerContext == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debuggerContext", "com/intellij/debugger/actions/ArrayAction$AdjustArrayRangeAction", "createNewRenderer"));
            }
            ArrayRenderer clonedRenderer = original.clone();
            clonedRenderer.setForced(true);
            if (ShowSettingsUtil.getInstance().editConfigurable(debuggerContext.getProject(), (Configurable)new NamedArrayConfigurable(title, clonedRenderer))) {
                Promise promise2 = Promises.resolvedPromise((Object)clonedRenderer);
                if (promise2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/actions/ArrayAction$AdjustArrayRangeAction", "createNewRenderer"));
                }
                return promise2;
            }
            Promise promise3 = Promises.rejectedPromise();
            if (promise3 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/actions/ArrayAction$AdjustArrayRangeAction", "createNewRenderer"));
            }
            return promise3;
        }
    }

    private static class NamedArrayConfigurable
    extends ArrayRendererConfigurable
    implements Configurable {
        private final String myTitle;

        public NamedArrayConfigurable(String title, ArrayRenderer renderer) {
            super(renderer);
            this.myTitle = title;
        }

        public String getDisplayName() {
            return this.myTitle;
        }

        public String getHelpTopic() {
            return null;
        }
    }
}

