/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.actions;

import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.actions.ArrayAction;
import com.intellij.debugger.settings.NodeRendererSettings;
import com.intellij.debugger.ui.tree.render.ArrayFilterInplaceEditor;
import com.intellij.debugger.ui.tree.render.ArrayRenderer;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ui.tree.TreeUtil;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTree;
import com.intellij.xdebugger.impl.ui.tree.nodes.MessageTreeNode;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueNodeImpl;
import javax.swing.JTree;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.Nullable;

public abstract class ArrayFilterAction
extends AnAction {
    public void update(AnActionEvent e) {
        e.getPresentation().setEnabledAndVisible(ArrayFilterAction.getFilterNode(e) != null);
    }

    public static boolean isArrayFilter(TreeNode node) {
        return node instanceof MessageTreeNode && ((MessageTreeNode)node).getLink() == ArrayRenderer.Filtered.FILTER_HYPERLINK;
    }

    @Nullable
    private static MessageTreeNode getFilterNode(AnActionEvent e) {
        Object node;
        Object[] paths;
        XDebuggerTree tree = XDebuggerTree.getTree(e.getDataContext());
        if (tree != null && !ArrayUtil.isEmpty((Object[])(paths = tree.getSelectionPaths())) && paths.length == 1 && ArrayFilterAction.isArrayFilter((TreeNode)(node = ((TreePath)paths[0]).getLastPathComponent()))) {
            return (MessageTreeNode)node;
        }
        return null;
    }

    public static class Delete
    extends ArrayFilterAction {
        public void actionPerformed(AnActionEvent e) {
            MessageTreeNode node = ArrayFilterAction.getFilterNode(e);
            if (node != null) {
                TreeUtil.selectNode((JTree)((Object)node.getTree()), (TreeNode)node.getParent());
                ArrayAction.setArrayRenderer(NodeRendererSettings.getInstance().getArrayRenderer(), (XValueNodeImpl)node.getParent(), DebuggerManagerEx.getInstanceEx(e.getProject()).getContext());
            }
        }
    }

    public static class Edit
    extends ArrayFilterAction {
        public void actionPerformed(AnActionEvent e) {
            MessageTreeNode node = ArrayFilterAction.getFilterNode(e);
            if (node != null) {
                ArrayFilterInplaceEditor.edit(node, false);
            }
        }
    }
}

