/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine;

import com.intellij.debugger.engine.SyntheticTypeComponentProvider;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.sun.jdi.TypeComponent;
import com.sun.jdi.VirtualMachine;
import org.jetbrains.annotations.NotNull;

public class DefaultSyntheticProvider
implements SyntheticTypeComponentProvider {
    public boolean isSynthetic(@NotNull TypeComponent typeComponent) {
        if (typeComponent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeComponent", "com/intellij/debugger/engine/DefaultSyntheticProvider", "isSynthetic"));
        }
        return DefaultSyntheticProvider.checkIsSynthetic(typeComponent);
    }

    public static boolean checkIsSynthetic(@NotNull TypeComponent typeComponent) {
        if (typeComponent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeComponent", "com/intellij/debugger/engine/DefaultSyntheticProvider", "checkIsSynthetic"));
        }
        String name2 = typeComponent.name();
        if (DebuggerUtilsEx.isLambdaName(name2)) {
            return false;
        }
        if (DebuggerUtilsEx.isLambdaClassName(typeComponent.declaringType().name())) {
            return true;
        }
        VirtualMachine machine = typeComponent.virtualMachine();
        if (machine != null && machine.canGetSyntheticAttribute()) {
            return typeComponent.isSynthetic();
        }
        return name2.contains("$");
    }
}

