/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine;

import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.BasicStepMethodFilter;
import com.intellij.debugger.engine.BreakpointStepMethodFilter;
import com.intellij.debugger.engine.ClassInstanceMethodFilter;
import com.intellij.debugger.engine.LambdaMethodFilter;
import com.intellij.debugger.engine.RequestHint;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.debugger.ui.breakpoints.StepIntoBreakpoint;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiMethod;
import com.intellij.util.containers.ContainerUtil;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.Value;
import com.sun.jdi.event.LocatableEvent;
import org.jetbrains.annotations.NotNull;

public class LambdaAsyncMethodFilter
extends BasicStepMethodFilter {
    private final int myParamNo;
    private final LambdaMethodFilter myMethodFilter;

    public LambdaAsyncMethodFilter(@NotNull PsiMethod callerMethod, int paramNo, LambdaMethodFilter methodFilter) {
        if (callerMethod == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callerMethod", "com/intellij/debugger/engine/LambdaAsyncMethodFilter", "<init>"));
        }
        super(callerMethod, methodFilter.getCallingExpressionLines());
        this.myParamNo = paramNo;
        this.myMethodFilter = methodFilter;
    }

    @Override
    public int onReached(SuspendContextImpl context, RequestHint hint) {
        try {
            SourcePosition pos;
            Value lambdaReference;
            StackFrameProxyImpl proxy = context.getFrameProxy();
            if (proxy != null && (lambdaReference = (Value)ContainerUtil.getOrElse(proxy.getArgumentValues(), (int)this.myParamNo, null)) instanceof ObjectReference && (pos = this.myMethodFilter.getBreakpointPosition()) != null) {
                Project project2 = context.getDebugProcess().getProject();
                long lambdaId = ((ObjectReference)lambdaReference).uniqueID();
                LambdaInstanceBreakpoint breakpoint = new LambdaInstanceBreakpoint(project2, lambdaId, pos, this.myMethodFilter);
                ClassInstanceMethodFilter.setUpStepIntoBreakpoint(context, breakpoint, hint);
                return -100;
            }
        }
        catch (EvaluateException evaluateException) {
            // empty catch block
        }
        return 0;
    }

    private static class LambdaInstanceBreakpoint
    extends StepIntoBreakpoint {
        private final long myLambdaId;

        /*
         * WARNING - void declaration
         */
        public LambdaInstanceBreakpoint(@NotNull Project project2, long lambdaId, @NotNull SourcePosition pos, @NotNull BreakpointStepMethodFilter breakpointStepMethodFilter) {
            void filter;
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/debugger/engine/LambdaAsyncMethodFilter$LambdaInstanceBreakpoint", "<init>"));
            }
            if (pos == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pos", "com/intellij/debugger/engine/LambdaAsyncMethodFilter$LambdaInstanceBreakpoint", "<init>"));
            }
            if (breakpointStepMethodFilter == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filter", "com/intellij/debugger/engine/LambdaAsyncMethodFilter$LambdaInstanceBreakpoint", "<init>"));
            }
            super(project2, pos, (BreakpointStepMethodFilter)filter);
            this.myLambdaId = lambdaId;
        }

        @Override
        public boolean evaluateCondition(EvaluationContextImpl context, LocatableEvent event) throws EvaluateException {
            if (!super.evaluateCondition(context, event)) {
                return false;
            }
            if (!DebuggerUtilsEx.isLambda(event.location().method())) {
                return false;
            }
            ObjectReference lambdaReference = null;
            StackFrameProxyImpl parentFrame = context.getSuspendContext().getThread().frame(1);
            if (parentFrame != null) {
                try {
                    lambdaReference = parentFrame.thisObject();
                }
                catch (EvaluateException evaluateException) {
                    // empty catch block
                }
            }
            return lambdaReference != null && lambdaReference.uniqueID() == this.myLambdaId;
        }
    }
}

