/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine.evaluation.expression;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.JVMName;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluateExceptionUtil;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.evaluation.expression.Evaluator;
import com.intellij.reference.SoftReference;
import com.sun.jdi.ClassLoaderReference;
import com.sun.jdi.ReferenceType;
import java.lang.ref.WeakReference;
import org.jetbrains.annotations.NotNull;

public class TypeEvaluator
implements Evaluator {
    private final JVMName myTypeName;
    private WeakReference<ReferenceType> myLastResult;
    private WeakReference<ClassLoaderReference> myLastClassLoader;

    public TypeEvaluator(@NotNull JVMName typeName) {
        if (typeName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeName", "com/intellij/debugger/engine/evaluation/expression/TypeEvaluator", "<init>"));
        }
        this.myTypeName = typeName;
    }

    @Override
    public Object evaluate(EvaluationContextImpl context) throws EvaluateException {
        String typeName;
        ClassLoaderReference classLoader = context.getClassLoader();
        ReferenceType lastRes = (ReferenceType)SoftReference.dereference(this.myLastResult);
        if (lastRes != null && classLoader == SoftReference.dereference(this.myLastClassLoader) && (classLoader != null || lastRes.virtualMachine().equals(context.getDebugProcess().getVirtualMachineProxy().getVirtualMachine()))) {
            return lastRes;
        }
        DebugProcessImpl debugProcess = context.getDebugProcess();
        ReferenceType type2 = debugProcess.findClass(context, typeName = this.myTypeName.getName(debugProcess), classLoader);
        if (type2 == null) {
            throw EvaluateExceptionUtil.createEvaluateException((String)DebuggerBundle.message((String)"error.class.not.loaded", (Object[])new Object[]{typeName}));
        }
        this.myLastClassLoader = new WeakReference<ClassLoaderReference>(classLoader);
        this.myLastResult = new WeakReference<ReferenceType>(type2);
        return type2;
    }

    public String toString() {
        return "Type " + this.myTypeName;
    }
}

