/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.impl;

import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.ContextUtil;
import com.intellij.debugger.engine.StackFrameContext;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.text.CharArrayUtil;
import org.jetbrains.annotations.Nullable;

public class PositionUtil
extends ContextUtil {
    public static SourcePosition getSourcePosition(StackFrameContext context) {
        if (context instanceof DebuggerContextImpl) {
            return ((DebuggerContextImpl)context).getSourcePosition();
        }
        return ContextUtil.getSourcePosition(context);
    }

    @Nullable
    public static PsiElement getContextElement(StackFrameContext context) {
        if (context instanceof DebuggerContextImpl) {
            return ((DebuggerContextImpl)context).getContextElement();
        }
        return ContextUtil.getContextElement(context);
    }

    @Nullable
    public static <T extends PsiElement> T getPsiElementAt(Project project2, Class<T> expectedPsiElementClass, SourcePosition sourcePosition) {
        return (T)((PsiElement)ReadAction.compute(() -> {
            PsiFile psiFile = sourcePosition.getFile();
            Document document = PsiDocumentManager.getInstance((Project)project2).getDocument(psiFile);
            if (document == null) {
                return null;
            }
            int spOffset = sourcePosition.getOffset();
            if (spOffset < 0) {
                return null;
            }
            int offset = CharArrayUtil.shiftForward((CharSequence)document.getCharsSequence(), (int)spOffset, (String)" \t");
            return PsiTreeUtil.getParentOfType((PsiElement)psiFile.findElementAt(offset), (Class)expectedPsiElementClass, (boolean)false);
        }));
    }
}

