/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.impl.descriptors.data;

import com.intellij.debugger.impl.descriptors.data.DescriptorData;
import com.intellij.debugger.impl.descriptors.data.DisplayKey;
import com.intellij.debugger.ui.impl.watch.MethodReturnValueDescriptorImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.sun.jdi.Method;
import com.sun.jdi.Value;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MethodReturnValueData
extends DescriptorData<MethodReturnValueDescriptorImpl> {
    @Nullable
    private final Value myReturnValue;
    @NotNull
    private final Method myMethod;

    public MethodReturnValueData(@NotNull Method method, @Nullable Value returnValue) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/debugger/impl/descriptors/data/MethodReturnValueData", "<init>"));
        }
        this.myMethod = method;
        this.myReturnValue = returnValue;
    }

    @Nullable
    public Value getReturnValue() {
        return this.myReturnValue;
    }

    @NotNull
    public Method getMethod() {
        Method method = this.myMethod;
        if (method == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/impl/descriptors/data/MethodReturnValueData", "getMethod"));
        }
        return method;
    }

    @Override
    protected MethodReturnValueDescriptorImpl createDescriptorImpl(@NotNull Project project2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/debugger/impl/descriptors/data/MethodReturnValueData", "createDescriptorImpl"));
        }
        return new MethodReturnValueDescriptorImpl(project2, this.myMethod, this.myReturnValue);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MethodReturnValueData that = (MethodReturnValueData)o;
        if (!this.myMethod.equals(that.myMethod)) {
            return false;
        }
        return !(this.myReturnValue != null ? !this.myReturnValue.equals(that.myReturnValue) : that.myReturnValue != null);
    }

    @Override
    public int hashCode() {
        int result2 = this.myReturnValue != null ? this.myReturnValue.hashCode() : 0;
        result2 = 31 * result2 + this.myMethod.hashCode();
        return result2;
    }

    @Override
    public DisplayKey<MethodReturnValueDescriptorImpl> getDisplayKey() {
        return new MethodReturnValueDisplayKey(this.myMethod, this.myReturnValue);
    }

    private static final class MethodReturnValueDisplayKey
    extends Pair<Method, Value>
    implements DisplayKey<MethodReturnValueDescriptorImpl> {
        public MethodReturnValueDisplayKey(@NotNull Method method, @Nullable Value value2) {
            if (method == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/debugger/impl/descriptors/data/MethodReturnValueData$MethodReturnValueDisplayKey", "<init>"));
            }
            super((Object)method, (Object)value2);
        }
    }
}

