/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.jdi;

import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.ContextUtil;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.StackFrameContext;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.impl.SimpleStackFrameContext;
import com.intellij.debugger.jdi.DecompiledLocalVariable;
import com.intellij.debugger.jdi.MethodBytecodeUtil;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.debugger.jdi.VirtualMachineProxyImpl;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiResourceList;
import com.intellij.psi.PsiSynchronizedStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.containers.MultiMap;
import com.sun.jdi.InternalException;
import com.sun.jdi.Location;
import com.sun.jdi.StackFrame;
import com.sun.jdi.Value;
import com.sun.jdi.VirtualMachine;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.org.objectweb.asm.MethodVisitor;

public class LocalVariablesUtil {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.debugger.jdi.LocalVariablesUtil");
    private static final boolean ourInitializationOk;
    private static Class<?> ourSlotInfoClass;
    private static Constructor<?> slotInfoConstructor;
    private static Method ourEnqueueMethod;
    private static Method ourWaitForReplyMethod;
    private static final boolean ourInitializationOkSet;
    private static Class<?> ourSlotInfoClassSet;
    private static Constructor<?> slotInfoConstructorSet;
    private static Method ourEnqueueMethodSet;
    private static Method ourWaitForReplyMethodSet;

    public static Map<DecompiledLocalVariable, Value> fetchValues(@NotNull StackFrameProxyImpl frameProxy, DebugProcess process2, boolean full) throws Exception {
        if (frameProxy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "frameProxy", "com/intellij/debugger/jdi/LocalVariablesUtil", "fetchValues"));
        }
        LinkedHashMap<DecompiledLocalVariable, Value> map2 = new LinkedHashMap<DecompiledLocalVariable, Value>();
        Location location = frameProxy.location();
        com.sun.jdi.Method method = location.method();
        int firstLocalVariableSlot = LocalVariablesUtil.getFirstLocalsSlot(method);
        MultiMap<Integer, String> namesMap = full ? LocalVariablesUtil.calcNames(new SimpleStackFrameContext(frameProxy, process2), firstLocalVariableSlot) : MultiMap.empty();
        int slot = LocalVariablesUtil.getFirstArgsSlot(method);
        List<String> typeNames = method.argumentTypeNames();
        List<Value> argValues = frameProxy.getArgumentValues();
        for (int i2 = 0; i2 < argValues.size(); ++i2) {
            map2.put(new DecompiledLocalVariable(slot, true, null, namesMap.get((Object)slot)), argValues.get(i2));
            slot += LocalVariablesUtil.getTypeSlotSize(typeNames.get(i2));
        }
        if (!full || !ourInitializationOk) {
            return map2;
        }
        List<DecompiledLocalVariable> vars = LocalVariablesUtil.collectVariablesFromBytecode(frameProxy.getVirtualMachine(), location, namesMap);
        StackFrame frame = frameProxy.getStackFrame();
        for (int size = vars.size(); size > 0; --size) {
            try {
                return LocalVariablesUtil.fetchSlotValues(map2, vars.subList(0, size), frame);
            }
            catch (Exception e) {
                LOG.debug((Throwable)e);
                continue;
            }
        }
        return map2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<DecompiledLocalVariable, Value> fetchSlotValues(Map<DecompiledLocalVariable, Value> map2, List<DecompiledLocalVariable> vars, StackFrame frame) throws Exception {
        Object ps;
        Object vmState;
        Long frameId = (Long)ReflectionUtil.getField(frame.getClass(), (Object)frame, Long.TYPE, (String)"id");
        VirtualMachine vm = frame.virtualMachine();
        Method stateMethod = vm.getClass().getDeclaredMethod("state", new Class[0]);
        stateMethod.setAccessible(true);
        Object slotInfoArray = LocalVariablesUtil.createSlotInfoArray(vars);
        Object object = vmState = stateMethod.invoke((Object)vm, new Object[0]);
        synchronized (object) {
            ps = ourEnqueueMethod.invoke(null, vm, frame.thread(), frameId, slotInfoArray);
        }
        Object reply = ourWaitForReplyMethod.invoke(null, vm, ps);
        Value[] values = (Value[])ReflectionUtil.getField(reply.getClass(), (Object)reply, Value[].class, (String)"values");
        if (vars.size() != values.length) {
            throw new InternalException("Wrong number of values returned from target VM");
        }
        int idx = 0;
        for (DecompiledLocalVariable var : vars) {
            map2.put(var, values[idx++]);
        }
        return map2;
    }

    public static boolean canSetValues() {
        return ourInitializationOkSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setValue(StackFrame frame, int slot, Value value2) throws EvaluateException {
        try {
            Object ps;
            Object vmState;
            Long frameId = (Long)ReflectionUtil.getField(frame.getClass(), (Object)frame, Long.TYPE, (String)"id");
            VirtualMachine vm = frame.virtualMachine();
            Method stateMethod = vm.getClass().getDeclaredMethod("state", new Class[0]);
            stateMethod.setAccessible(true);
            Object slotInfoArray = LocalVariablesUtil.createSlotInfoArraySet(slot, value2);
            Object object = vmState = stateMethod.invoke((Object)vm, new Object[0]);
            synchronized (object) {
                ps = ourEnqueueMethodSet.invoke(null, vm, frame.thread(), frameId, slotInfoArray);
            }
            ourWaitForReplyMethodSet.invoke(null, vm, ps);
        }
        catch (Exception e) {
            throw new EvaluateException("Unable to set value", (Throwable)e);
        }
    }

    private static Object createSlotInfoArraySet(int slot, Value value2) throws IllegalAccessException, InvocationTargetException, InstantiationException {
        Object arrayInstance = Array.newInstance(ourSlotInfoClassSet, 1);
        Array.set(arrayInstance, 0, slotInfoConstructorSet.newInstance(slot, value2));
        return arrayInstance;
    }

    private static Object createSlotInfoArray(Collection<DecompiledLocalVariable> vars) throws Exception {
        Object arrayInstance = Array.newInstance(ourSlotInfoClass, vars.size());
        int idx = 0;
        for (DecompiledLocalVariable var : vars) {
            Object info = slotInfoConstructor.newInstance(var.getSlot(), (byte)var.getSignature().charAt(0));
            Array.set(arrayInstance, idx++, info);
        }
        return arrayInstance;
    }

    private static Method getDeclaredMethodByName(Class aClass, String methodName) throws NoSuchMethodException {
        for (Method method : aClass.getDeclaredMethods()) {
            if (!methodName.equals(method.getName())) continue;
            method.setAccessible(true);
            return method;
        }
        throw new NoSuchMethodException(aClass.getName() + "." + methodName);
    }

    @NotNull
    private static List<DecompiledLocalVariable> collectVariablesFromBytecode(VirtualMachineProxyImpl vm, Location location, final MultiMap<Integer, String> namesMap) {
        block12: {
            ArrayList<DecompiledLocalVariable> arrayList;
            HashMap usedVars;
            block13: {
                byte[] bytecodes;
                com.sun.jdi.Method method;
                block11: {
                    if (!vm.canGetBytecodes()) {
                        List<DecompiledLocalVariable> list2 = Collections.emptyList();
                        if (list2 == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/jdi/LocalVariablesUtil", "collectVariablesFromBytecode"));
                        }
                        return list2;
                    }
                    LOG.assertTrue(location != null);
                    method = location.method();
                    Location methodLocation = method.location();
                    if (methodLocation != null && methodLocation.codeIndex() >= 0L) break block11;
                    List<DecompiledLocalVariable> list3 = Collections.emptyList();
                    if (list3 == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/jdi/LocalVariablesUtil", "collectVariablesFromBytecode"));
                    }
                    return list3;
                }
                long codeIndex = location.codeIndex();
                if (codeIndex <= 0L || (bytecodes = method.bytecodes()) == null || bytecodes.length <= 0) break block12;
                final int firstLocalVariableSlot = LocalVariablesUtil.getFirstLocalsSlot(method);
                usedVars = new HashMap();
                MethodBytecodeUtil.visit(method, codeIndex, new MethodVisitor(393216){

                    public void visitVarInsn(int opcode, int slot) {
                        if (slot >= firstLocalVariableSlot) {
                            DecompiledLocalVariable variable = (DecompiledLocalVariable)usedVars.get(slot);
                            String typeSignature = MethodBytecodeUtil.getVarInstructionType(opcode).getDescriptor();
                            if (variable == null || !typeSignature.equals(variable.getSignature())) {
                                variable = new DecompiledLocalVariable(slot, false, typeSignature, namesMap.get((Object)slot));
                                usedVars.put(slot, variable);
                            }
                        }
                    }
                }, false);
                if (!usedVars.isEmpty()) break block13;
                List<DecompiledLocalVariable> list4 = Collections.emptyList();
                if (list4 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/jdi/LocalVariablesUtil", "collectVariablesFromBytecode"));
                }
                return list4;
            }
            try {
                ArrayList<DecompiledLocalVariable> vars = new ArrayList<DecompiledLocalVariable>(usedVars.values());
                vars.sort(Comparator.comparingInt(DecompiledLocalVariable::getSlot));
                arrayList = vars;
            }
            catch (UnsupportedOperationException method) {
                break block12;
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/jdi/LocalVariablesUtil", "collectVariablesFromBytecode"));
            }
            return arrayList;
        }
        List<DecompiledLocalVariable> list5 = Collections.emptyList();
        if (list5 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/jdi/LocalVariablesUtil", "collectVariablesFromBytecode"));
        }
        return list5;
    }

    @NotNull
    private static MultiMap<Integer, String> calcNames(@NotNull StackFrameContext context, int firstLocalsSlot) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/debugger/jdi/LocalVariablesUtil", "calcNames"));
        }
        SourcePosition position = ContextUtil.getSourcePosition(context);
        if (position != null) {
            MultiMap multiMap = (MultiMap)ReadAction.compute(() -> {
                PsiElement element = position.getElementAt();
                PsiElement method = DebuggerUtilsEx.getContainingMethod(element);
                if (method != null) {
                    MultiMap res = new MultiMap();
                    int slot = Math.max(0, firstLocalsSlot - LocalVariablesUtil.getParametersStackSize(method));
                    for (PsiParameter parameter : DebuggerUtilsEx.getParameters(method)) {
                        res.putValue((Object)slot, (Object)parameter.getName());
                        slot += LocalVariablesUtil.getTypeSlotSize(parameter.getType());
                    }
                    PsiElement body2 = DebuggerUtilsEx.getBody(method);
                    if (body2 != null) {
                        try {
                            body2.accept((PsiElementVisitor)new LocalVariableNameFinder(firstLocalsSlot, (MultiMap<Integer, String>)res, element));
                        }
                        catch (Exception e) {
                            LOG.info((Throwable)e);
                        }
                    }
                    return res;
                }
                return MultiMap.empty();
            });
            if (multiMap == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/jdi/LocalVariablesUtil", "calcNames"));
            }
            return multiMap;
        }
        MultiMap multiMap = MultiMap.empty();
        if (multiMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/jdi/LocalVariablesUtil", "calcNames"));
        }
        return multiMap;
    }

    private static int getParametersStackSize(PsiElement method) {
        return Arrays.stream(DebuggerUtilsEx.getParameters(method)).mapToInt(parameter -> LocalVariablesUtil.getTypeSlotSize(parameter.getType())).sum();
    }

    private static int getTypeSlotSize(PsiType varType) {
        if (PsiType.DOUBLE.equals((Object)varType) || PsiType.LONG.equals((Object)varType)) {
            return 2;
        }
        return 1;
    }

    private static int getFirstArgsSlot(com.sun.jdi.Method method) {
        return method.isStatic() ? 0 : 1;
    }

    private static int getFirstLocalsSlot(com.sun.jdi.Method method) {
        return LocalVariablesUtil.getFirstArgsSlot(method) + method.argumentTypeNames().stream().mapToInt(LocalVariablesUtil::getTypeSlotSize).sum();
    }

    private static int getTypeSlotSize(String name2) {
        if ("double".equals(name2) || "long".equals(name2)) {
            return 2;
        }
        return 1;
    }

    static {
        boolean success = false;
        try {
            String GetValuesClassName = "com.sun.tools.jdi.JDWP$StackFrame$GetValues";
            ourSlotInfoClass = Class.forName(GetValuesClassName + "$SlotInfo");
            slotInfoConstructor = ourSlotInfoClass.getDeclaredConstructor(Integer.TYPE, Byte.TYPE);
            slotInfoConstructor.setAccessible(true);
            Class<?> ourGetValuesClass = Class.forName(GetValuesClassName);
            ourEnqueueMethod = LocalVariablesUtil.getDeclaredMethodByName(ourGetValuesClass, "enqueueCommand");
            ourWaitForReplyMethod = LocalVariablesUtil.getDeclaredMethodByName(ourGetValuesClass, "waitForReply");
            success = true;
        }
        catch (Throwable e) {
            LOG.info(e);
        }
        ourInitializationOk = success;
        success = false;
        try {
            String setValuesClassName = "com.sun.tools.jdi.JDWP$StackFrame$SetValues";
            ourSlotInfoClassSet = Class.forName(setValuesClassName + "$SlotInfo");
            slotInfoConstructorSet = ourSlotInfoClassSet.getDeclaredConstructors()[0];
            slotInfoConstructorSet.setAccessible(true);
            Class<?> ourGetValuesClassSet = Class.forName(setValuesClassName);
            ourEnqueueMethodSet = LocalVariablesUtil.getDeclaredMethodByName(ourGetValuesClassSet, "enqueueCommand");
            ourWaitForReplyMethodSet = LocalVariablesUtil.getDeclaredMethodByName(ourGetValuesClassSet, "waitForReply");
            success = true;
        }
        catch (Throwable e) {
            LOG.info(e);
        }
        ourInitializationOkSet = success;
    }

    private static class LocalVariableNameFinder
    extends JavaRecursiveElementVisitor {
        private final MultiMap<Integer, String> myNames;
        private int myCurrentSlotIndex;
        private final PsiElement myElement;
        private final Deque<Integer> myIndexStack = new LinkedList<Integer>();
        private boolean myReached = false;

        public LocalVariableNameFinder(int startSlot, MultiMap<Integer, String> names, PsiElement element) {
            this.myNames = names;
            this.myCurrentSlotIndex = startSlot;
            this.myElement = element;
        }

        private boolean shouldVisit(PsiElement scope) {
            return !this.myReached && PsiTreeUtil.isContextAncestor((PsiElement)scope, (PsiElement)this.myElement, (boolean)false);
        }

        public void visitElement(PsiElement element) {
            if (element == this.myElement) {
                this.myReached = true;
            } else {
                super.visitElement(element);
            }
        }

        public void visitLocalVariable(PsiLocalVariable variable) {
            super.visitLocalVariable(variable);
            if (!this.myReached) {
                this.appendName(variable.getName());
                this.myCurrentSlotIndex += LocalVariablesUtil.getTypeSlotSize(variable.getType());
            }
        }

        public void visitSynchronizedStatement(PsiSynchronizedStatement statement2) {
            if (this.shouldVisit((PsiElement)statement2)) {
                this.myIndexStack.push(this.myCurrentSlotIndex);
                try {
                    this.appendName("<monitor>");
                    ++this.myCurrentSlotIndex;
                    super.visitSynchronizedStatement(statement2);
                }
                finally {
                    this.myCurrentSlotIndex = this.myIndexStack.pop();
                }
            }
        }

        private void appendName(String varName) {
            this.myNames.putValue((Object)this.myCurrentSlotIndex, (Object)varName);
        }

        public void visitCodeBlock(PsiCodeBlock block) {
            if (this.shouldVisit((PsiElement)block)) {
                this.myIndexStack.push(this.myCurrentSlotIndex);
                try {
                    super.visitCodeBlock(block);
                }
                finally {
                    this.myCurrentSlotIndex = this.myIndexStack.pop();
                }
            }
        }

        public void visitForStatement(PsiForStatement statement2) {
            if (this.shouldVisit((PsiElement)statement2)) {
                this.myIndexStack.push(this.myCurrentSlotIndex);
                try {
                    super.visitForStatement(statement2);
                }
                finally {
                    this.myCurrentSlotIndex = this.myIndexStack.pop();
                }
            }
        }

        public void visitForeachStatement(PsiForeachStatement statement2) {
            if (this.shouldVisit((PsiElement)statement2)) {
                this.myIndexStack.push(this.myCurrentSlotIndex);
                try {
                    super.visitForeachStatement(statement2);
                }
                finally {
                    this.myCurrentSlotIndex = this.myIndexStack.pop();
                }
            }
        }

        public void visitCatchSection(PsiCatchSection section) {
            if (this.shouldVisit((PsiElement)section)) {
                this.myIndexStack.push(this.myCurrentSlotIndex);
                try {
                    super.visitCatchSection(section);
                }
                finally {
                    this.myCurrentSlotIndex = this.myIndexStack.pop();
                }
            }
        }

        public void visitResourceList(PsiResourceList resourceList) {
            if (this.shouldVisit((PsiElement)resourceList)) {
                this.myIndexStack.push(this.myCurrentSlotIndex);
                try {
                    super.visitResourceList(resourceList);
                }
                finally {
                    this.myCurrentSlotIndex = this.myIndexStack.pop();
                }
            }
        }

        public void visitClass(PsiClass aClass) {
        }
    }
}

