/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.memory.action;

import com.intellij.debugger.memory.action.DebuggerTreeAction;
import com.intellij.debugger.memory.ui.InstancesWindow;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueNodeImpl;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ShowInstancesByClassAction
extends DebuggerTreeAction {
    @Override
    protected boolean isEnabled(@NotNull XValueNodeImpl node, @NotNull AnActionEvent e) {
        boolean enabled;
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/debugger/memory/action/ShowInstancesByClassAction", "isEnabled"));
        }
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/debugger/memory/action/ShowInstancesByClassAction", "isEnabled"));
        }
        ObjectReference ref = this.getObjectReference(node);
        boolean bl = enabled = ref != null && ref.virtualMachine().canGetInstanceInfo();
        if (enabled) {
            String text2 = String.format("Show %s Objects...", StringUtil.getShortName((String)ref.referenceType().name()));
            e.getPresentation().setText(text2);
        }
        return enabled;
    }

    @Override
    protected void perform(XValueNodeImpl node, @NotNull String nodeName, AnActionEvent e) {
        if (nodeName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodeName", "com/intellij/debugger/memory/action/ShowInstancesByClassAction", "perform"));
        }
        Project project2 = e.getProject();
        if (project2 != null) {
            XDebugSession debugSession = XDebuggerManager.getInstance((Project)project2).getCurrentSession();
            ObjectReference ref = this.getObjectReference(node);
            if (debugSession != null && ref != null) {
                ReferenceType referenceType = ref.referenceType();
                new InstancesWindow(debugSession, l -> {
                    List<ObjectReference> instances = referenceType.instances(l);
                    return instances == null ? Collections.emptyList() : instances;
                }, referenceType.name()).show();
            }
        }
    }
}

