/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.memory.tracking;

import com.intellij.debugger.DebuggerManager;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.events.DebuggerCommandImpl;
import com.intellij.debugger.engine.events.SuspendContextCommandImpl;
import com.intellij.debugger.engine.requests.LocatableEventRequestor;
import com.intellij.debugger.memory.component.InstancesTracker;
import com.intellij.debugger.memory.component.MemoryViewDebugProcessData;
import com.intellij.debugger.memory.event.InstancesTrackerListener;
import com.intellij.debugger.memory.tracking.BackgroundTracker;
import com.intellij.debugger.memory.tracking.TrackerForNewInstances;
import com.intellij.debugger.memory.utils.StackFrameItem;
import com.intellij.debugger.ui.breakpoints.JavaLineBreakpointType;
import com.intellij.debugger.ui.breakpoints.LineBreakpoint;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.impl.XDebuggerManagerImpl;
import com.intellij.xdebugger.impl.breakpoints.LineBreakpointState;
import com.intellij.xdebugger.impl.breakpoints.XLineBreakpointImpl;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.event.LocatableEvent;
import com.sun.jdi.request.BreakpointRequest;
import com.sun.jdi.request.EventRequest;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.java.debugger.breakpoints.properties.JavaLineBreakpointProperties;

public class ConstructorInstancesTracker
implements TrackerForNewInstances,
Disposable,
BackgroundTracker {
    private static final int TRACKED_INSTANCES_LIMIT = 2000;
    private final String myClassName;
    private final Project myProject;
    private final MyConstructorBreakpoints myBreakpoint;
    @Nullable
    private HashSet<ObjectReference> myNewObjects;
    @NotNull
    private HashSet<ObjectReference> myTrackedObjects;
    private volatile boolean myIsBackgroundMode;
    private volatile boolean myIsBackgroundTrackingEnabled;

    public ConstructorInstancesTracker(@NotNull ReferenceType ref, @NotNull XDebugSession debugSession, @NotNull InstancesTracker instancesTracker) {
        if (ref == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "com/intellij/debugger/memory/tracking/ConstructorInstancesTracker", "<init>"));
        }
        if (debugSession == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debugSession", "com/intellij/debugger/memory/tracking/ConstructorInstancesTracker", "<init>"));
        }
        if (instancesTracker == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "instancesTracker", "com/intellij/debugger/memory/tracking/ConstructorInstancesTracker", "<init>"));
        }
        this.myNewObjects = null;
        this.myTrackedObjects = new HashSet();
        this.myProject = debugSession.getProject();
        this.myIsBackgroundTrackingEnabled = instancesTracker.isBackgroundTrackingEnabled();
        this.myClassName = ref.name();
        final DebugProcessImpl debugProcess = (DebugProcessImpl)DebuggerManager.getInstance((Project)this.myProject).getDebugProcess(debugSession.getDebugProcess().getProcessHandler());
        instancesTracker.addTrackerListener(new InstancesTrackerListener(){

            @Override
            public void backgroundTrackingValueChanged(final boolean newState) {
                if (ConstructorInstancesTracker.this.myIsBackgroundTrackingEnabled != newState) {
                    ConstructorInstancesTracker.this.myIsBackgroundTrackingEnabled = newState;
                    debugProcess.getManagerThread().schedule(new DebuggerCommandImpl(){

                        @Override
                        protected void action() throws Exception {
                            if (newState) {
                                ConstructorInstancesTracker.this.myBreakpoint.enable();
                            } else {
                                ConstructorInstancesTracker.this.myBreakpoint.disable();
                            }
                        }
                    });
                }
            }
        }, this);
        JavaLineBreakpointType breakPointType = new JavaLineBreakpointType();
        XLineBreakpointImpl<JavaLineBreakpointProperties> bpn = new XLineBreakpointImpl<JavaLineBreakpointProperties>(breakPointType, ((XDebuggerManagerImpl)XDebuggerManager.getInstance((Project)this.myProject)).getBreakpointManager(), new JavaLineBreakpointProperties(), new LineBreakpointState());
        this.myBreakpoint = new MyConstructorBreakpoints(this.myProject, bpn);
        this.myBreakpoint.createRequestForPreparedClass(debugProcess, ref);
    }

    public void obsolete() {
        DebugProcess process2;
        MemoryViewDebugProcessData data;
        XDebugSession session2;
        if (this.myNewObjects != null) {
            this.myNewObjects.forEach(ObjectReference::enableCollection);
        }
        this.myNewObjects = null;
        if (!this.myIsBackgroundMode || this.myIsBackgroundTrackingEnabled) {
            this.myBreakpoint.enable();
        }
        if ((session2 = XDebuggerManager.getInstance((Project)this.myProject).getCurrentSession()) != null && (data = (MemoryViewDebugProcessData)(process2 = DebuggerManager.getInstance((Project)this.myProject).getDebugProcess(session2.getDebugProcess().getProcessHandler())).getUserData(MemoryViewDebugProcessData.KEY)) != null) {
            data.getTrackedStacks().release();
        }
    }

    public void commitTracked() {
        this.myNewObjects = this.myTrackedObjects;
        this.myTrackedObjects = new HashSet();
    }

    @Override
    @NotNull
    public List<ObjectReference> getNewInstances() {
        List<Object> list2 = this.myNewObjects == null ? Collections.EMPTY_LIST : new ArrayList<ObjectReference>(this.myNewObjects);
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/memory/tracking/ConstructorInstancesTracker", "getNewInstances"));
        }
        return list2;
    }

    @Override
    public int getCount() {
        return this.myNewObjects == null ? 0 : this.myNewObjects.size();
    }

    public void enable() {
        this.myBreakpoint.enable();
    }

    public void disable() {
        this.myBreakpoint.disable();
    }

    @Override
    public boolean isReady() {
        return this.myNewObjects != null;
    }

    public void dispose() {
        this.myBreakpoint.delete();
        this.myTrackedObjects.clear();
        this.myNewObjects = null;
    }

    @Override
    public void setBackgroundMode(boolean isBackgroundMode) {
        if (this.myIsBackgroundMode == isBackgroundMode) {
            return;
        }
        this.myIsBackgroundMode = isBackgroundMode;
        if (isBackgroundMode) {
            this.doEnableBackgroundMode();
        } else {
            this.doDisableBackgroundMode();
        }
    }

    private void doDisableBackgroundMode() {
        this.myBreakpoint.enable();
    }

    private void doEnableBackgroundMode() {
        if (!this.myIsBackgroundTrackingEnabled) {
            this.myBreakpoint.disable();
        }
    }

    private final class MyConstructorBreakpoints
    extends LineBreakpoint<JavaLineBreakpointProperties> {
        private final List<BreakpointRequest> myRequests;
        private volatile boolean myIsEnabled;
        private volatile boolean myIsDeleted;

        MyConstructorBreakpoints(Project project2, XBreakpoint xBreakpoint) {
            super(project2, xBreakpoint);
            this.myRequests = new ArrayList<BreakpointRequest>();
            this.myIsEnabled = false;
            this.myIsDeleted = false;
            this.setVisible(false);
        }

        @Override
        protected void createRequestForPreparedClass(DebugProcessImpl debugProcess, ReferenceType classType) {
            classType.methods().stream().filter(Method::isConstructor).forEach(cons -> {
                Location loc = cons.location();
                BreakpointRequest breakpointRequest = debugProcess.getRequestsManager().createBreakpointRequest(this, loc);
                this.myRequests.add(breakpointRequest);
            });
            if (!ConstructorInstancesTracker.this.myIsBackgroundMode || ConstructorInstancesTracker.this.myIsBackgroundTrackingEnabled) {
                this.enable();
            }
        }

        @Override
        public void reload() {
        }

        void delete() {
            this.myRequests.clear();
            this.myIsDeleted = true;
        }

        @Override
        public boolean processLocatableEvent(SuspendContextCommandImpl action, LocatableEvent event) throws LocatableEventRequestor.EventProcessingException {
            if (this.myIsDeleted) {
                event.request().disable();
            } else {
                this.handleEvent(action, event);
            }
            return false;
        }

        void enable() {
            if (!this.myIsEnabled && !this.myIsDeleted) {
                this.myRequests.forEach(EventRequest::enable);
                this.myIsEnabled = true;
            }
        }

        void disable() {
            if (this.myIsEnabled && !this.myIsDeleted) {
                this.myRequests.forEach(EventRequest::disable);
                this.myIsEnabled = false;
            }
        }

        private void handleEvent(@NotNull SuspendContextCommandImpl action, @NotNull LocatableEvent event) {
            if (action == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/debugger/memory/tracking/ConstructorInstancesTracker$MyConstructorBreakpoints", "handleEvent"));
            }
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/debugger/memory/tracking/ConstructorInstancesTracker$MyConstructorBreakpoints", "handleEvent"));
            }
            try {
                SuspendContextImpl suspendContext = action.getSuspendContext();
                if (suspendContext != null) {
                    MemoryViewDebugProcessData data = (MemoryViewDebugProcessData)suspendContext.getDebugProcess().getUserData(MemoryViewDebugProcessData.KEY);
                    ObjectReference thisRef = this.getThisObject(suspendContext, event);
                    if (thisRef.referenceType().name().equals(ConstructorInstancesTracker.this.myClassName) && data != null) {
                        thisRef.disableCollection();
                        ConstructorInstancesTracker.this.myTrackedObjects.add(thisRef);
                        data.getTrackedStacks().addStack(thisRef, StackFrameItem.createFrames(suspendContext, false));
                    }
                }
            }
            catch (EvaluateException evaluateException) {
                // empty catch block
            }
            if (ConstructorInstancesTracker.this.myTrackedObjects.size() >= 2000) {
                this.disable();
            }
        }
    }
}

