/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.memory.utils;

import com.intellij.openapi.util.text.StringUtil;
import com.sun.jdi.ArrayReference;
import com.sun.jdi.ObjectReference;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

class NamesUtils {
    NamesUtils() {
    }

    @NotNull
    static String getUniqueName(@NotNull ObjectReference ref) {
        if (ref == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "com/intellij/debugger/memory/utils/NamesUtils", "getUniqueName"));
        }
        String shortName = StringUtil.getShortName((String)ref.referenceType().name());
        String name2 = shortName.replace("[]", "Array");
        String string = String.format("%s@%d", name2, ref.uniqueID());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/memory/utils/NamesUtils", "getUniqueName"));
        }
        return string;
    }

    @NotNull
    static String getArrayUniqueName(@NotNull ArrayReference ref) {
        if (ref == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "com/intellij/debugger/memory/utils/NamesUtils", "getArrayUniqueName"));
        }
        String shortName = StringUtil.getShortName((String)ref.referenceType().name());
        int length = ref.length();
        String name2 = shortName.replaceFirst(Pattern.quote("[]"), String.format("[%d]", length));
        String string = String.format("%s@%d", name2, ref.uniqueID());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/memory/utils/NamesUtils", "getArrayUniqueName"));
        }
        return string;
    }
}

