/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.breakpoints;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.PositionManagerImpl;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.ui.breakpoints.Breakpoint;
import com.intellij.debugger.ui.breakpoints.BreakpointManager;
import com.intellij.debugger.ui.breakpoints.JavaBreakpointType;
import com.intellij.debugger.ui.breakpoints.JavaLineBreakpointTypeBase;
import com.intellij.debugger.ui.breakpoints.LineBreakpoint;
import com.intellij.debugger.ui.breakpoints.RunToCursorBreakpoint;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiManager;
import com.intellij.util.SmartList;
import com.intellij.xdebugger.XDebuggerUtil;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import com.intellij.xdebugger.breakpoints.XLineBreakpointType;
import com.intellij.xdebugger.breakpoints.ui.XBreakpointGroupingRule;
import com.intellij.xdebugger.impl.XSourcePositionImpl;
import com.intellij.xdebugger.impl.breakpoints.XLineBreakpointImpl;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.java.debugger.breakpoints.properties.JavaLineBreakpointProperties;

public class JavaLineBreakpointType
extends JavaLineBreakpointTypeBase<JavaLineBreakpointProperties>
implements JavaBreakpointType<JavaLineBreakpointProperties> {
    public JavaLineBreakpointType() {
        super("java-line", DebuggerBundle.message((String)"line.breakpoints.tab.title", (Object[])new Object[0]));
    }

    protected JavaLineBreakpointType(@NonNls @NotNull String id, @Nls @NotNull String title) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/debugger/ui/breakpoints/JavaLineBreakpointType", "<init>"));
        }
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/debugger/ui/breakpoints/JavaLineBreakpointType", "<init>"));
        }
        super(id, title);
    }

    protected String getHelpID() {
        return "debugging.lineBreakpoint";
    }

    public String getDisplayName() {
        return DebuggerBundle.message((String)"line.breakpoints.tab.title", (Object[])new Object[0]);
    }

    public List<XBreakpointGroupingRule<XLineBreakpoint<JavaLineBreakpointProperties>, ?>> getGroupingRules() {
        return XDebuggerUtil.getInstance().getGroupingByFileRuleAsList();
    }

    @Nullable
    public JavaLineBreakpointProperties createProperties() {
        return new JavaLineBreakpointProperties();
    }

    @NotNull
    public JavaLineBreakpointProperties createBreakpointProperties(@NotNull VirtualFile file2, int line) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/debugger/ui/breakpoints/JavaLineBreakpointType", "createBreakpointProperties"));
        }
        JavaLineBreakpointProperties javaLineBreakpointProperties = new JavaLineBreakpointProperties();
        if (javaLineBreakpointProperties == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/ui/breakpoints/JavaLineBreakpointType", "createBreakpointProperties"));
        }
        return javaLineBreakpointProperties;
    }

    @Override
    @NotNull
    public Breakpoint<JavaLineBreakpointProperties> createJavaBreakpoint(Project project2, XBreakpoint breakpoint) {
        LineBreakpoint<JavaLineBreakpointProperties> lineBreakpoint = new LineBreakpoint<JavaLineBreakpointProperties>(project2, breakpoint);
        if (lineBreakpoint == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/ui/breakpoints/JavaLineBreakpointType", "createJavaBreakpoint"));
        }
        return lineBreakpoint;
    }

    public int getPriority() {
        return 100;
    }

    @NotNull
    public List<JavaBreakpointVariant> computeVariants(@NotNull Project project2, @NotNull XSourcePosition position) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/debugger/ui/breakpoints/JavaLineBreakpointType", "computeVariants"));
        }
        if (position == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "com/intellij/debugger/ui/breakpoints/JavaLineBreakpointType", "computeVariants"));
        }
        SourcePosition pos = DebuggerUtilsEx.toSourcePosition(position, project2);
        if (pos == null) {
            List<JavaBreakpointVariant> list2 = Collections.emptyList();
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/ui/breakpoints/JavaLineBreakpointType", "computeVariants"));
            }
            return list2;
        }
        List<PsiLambdaExpression> lambdas = DebuggerUtilsEx.collectLambdas(pos, true);
        if (lambdas.isEmpty()) {
            List<JavaBreakpointVariant> list3 = Collections.emptyList();
            if (list3 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/ui/breakpoints/JavaLineBreakpointType", "computeVariants"));
            }
            return list3;
        }
        PsiElement startMethod = DebuggerUtilsEx.getContainingMethod(pos);
        if (lambdas.contains(startMethod) && lambdas.size() == 1) {
            List<JavaBreakpointVariant> list4 = Collections.emptyList();
            if (list4 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/ui/breakpoints/JavaLineBreakpointType", "computeVariants"));
            }
            return list4;
        }
        Document document = PsiDocumentManager.getInstance((Project)project2).getDocument(pos.getFile());
        if (document == null) {
            List<JavaBreakpointVariant> list5 = Collections.emptyList();
            if (list5 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/ui/breakpoints/JavaLineBreakpointType", "computeVariants"));
            }
            return list5;
        }
        SmartList res = new SmartList();
        if (!(startMethod instanceof PsiLambdaExpression)) {
            res.add(new LineJavaBreakpointVariant(position, startMethod, -1));
        }
        int ordinal = 0;
        for (PsiLambdaExpression lambda2 : lambdas) {
            PsiElement firstElem = DebuggerUtilsEx.getFirstElementOnTheLine(lambda2, document, position.getLine());
            XSourcePositionImpl elementPosition = XSourcePositionImpl.createByElement(firstElem);
            if (elementPosition == null) continue;
            if (lambda2 == startMethod) {
                res.add(0, new LineJavaBreakpointVariant(elementPosition, (PsiElement)lambda2, ordinal++));
                continue;
            }
            res.add(new LambdaJavaBreakpointVariant(elementPosition, (PsiElement)lambda2, ordinal++));
        }
        res.add(new JavaBreakpointVariant(position));
        SmartList smartList = res;
        if (smartList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/ui/breakpoints/JavaLineBreakpointType", "computeVariants"));
        }
        return smartList;
    }

    public boolean matchesPosition(@NotNull LineBreakpoint<?> breakpoint, @NotNull SourcePosition position) {
        if (breakpoint == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "breakpoint", "com/intellij/debugger/ui/breakpoints/JavaLineBreakpointType", "matchesPosition"));
        }
        if (position == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "com/intellij/debugger/ui/breakpoints/JavaLineBreakpointType", "matchesPosition"));
        }
        Object properties = breakpoint.getProperties();
        if (properties instanceof JavaLineBreakpointProperties) {
            if (!(breakpoint instanceof RunToCursorBreakpoint) && ((JavaLineBreakpointProperties)((Object)properties)).getLambdaOrdinal() == null) {
                return true;
            }
            PsiElement containingMethod = this.getContainingMethod(breakpoint);
            if (containingMethod == null) {
                return false;
            }
            return DebuggerUtilsEx.inTheMethod(position, containingMethod);
        }
        return true;
    }

    @Nullable
    public PsiElement getContainingMethod(@NotNull LineBreakpoint<?> breakpoint) {
        Integer ordinal;
        if (breakpoint == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "breakpoint", "com/intellij/debugger/ui/breakpoints/JavaLineBreakpointType", "getContainingMethod"));
        }
        SourcePosition position = breakpoint.getSourcePosition();
        if (position == null) {
            return null;
        }
        Object properties = breakpoint.getProperties();
        if (properties instanceof JavaLineBreakpointProperties && !(breakpoint instanceof RunToCursorBreakpoint) && (ordinal = ((JavaLineBreakpointProperties)((Object)properties)).getLambdaOrdinal()) > -1) {
            List<PsiLambdaExpression> lambdas = DebuggerUtilsEx.collectLambdas(position, true);
            if (ordinal < lambdas.size()) {
                return (PsiElement)lambdas.get(ordinal);
            }
        }
        return DebuggerUtilsEx.getContainingMethod(position);
    }

    @Nullable
    public TextRange getHighlightRange(XLineBreakpoint<JavaLineBreakpointProperties> breakpoint) {
        PsiElement method;
        Breakpoint javaBreakpoint;
        Integer ordinal = JavaLineBreakpointType.getLambdaOrdinal(breakpoint);
        if (ordinal != null && (javaBreakpoint = BreakpointManager.getJavaBreakpoint(breakpoint)) instanceof LineBreakpoint && (method = this.getContainingMethod((LineBreakpoint)javaBreakpoint)) != null) {
            return method.getTextRange();
        }
        return null;
    }

    public XSourcePosition getSourcePosition(@NotNull XBreakpoint<JavaLineBreakpointProperties> breakpoint) {
        SourcePosition linePosition;
        if (breakpoint == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "breakpoint", "com/intellij/debugger/ui/breakpoints/JavaLineBreakpointType", "getSourcePosition"));
        }
        Integer ordinal = JavaLineBreakpointType.getLambdaOrdinal(breakpoint);
        if (ordinal != null && ordinal > -1 && (linePosition = JavaLineBreakpointType.createLineSourcePosition((XLineBreakpointImpl)breakpoint)) != null) {
            return DebuggerUtilsEx.toXSourcePosition(new PositionManagerImpl.JavaSourcePosition(linePosition, ordinal));
        }
        return null;
    }

    @Nullable
    private static Integer getLambdaOrdinal(XBreakpoint<JavaLineBreakpointProperties> breakpoint) {
        JavaLineBreakpointProperties properties = (JavaLineBreakpointProperties)breakpoint.getProperties();
        return properties != null ? properties.getLambdaOrdinal() : null;
    }

    @Nullable
    private static SourcePosition createLineSourcePosition(XLineBreakpointImpl breakpoint) {
        PsiFile psiFile;
        VirtualFile file2 = breakpoint.getFile();
        if (file2 != null && (psiFile = PsiManager.getInstance((Project)breakpoint.getProject()).findFile(file2)) != null) {
            return SourcePosition.createFromLine((PsiFile)psiFile, (int)breakpoint.getLine());
        }
        return null;
    }

    public boolean canBeHitInOtherPlaces() {
        return true;
    }

    public class LambdaJavaBreakpointVariant
    extends ExactJavaBreakpointVariant {
        public LambdaJavaBreakpointVariant(@NotNull XSourcePosition position, PsiElement element, Integer lambdaOrdinal) {
            if (position == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "com/intellij/debugger/ui/breakpoints/JavaLineBreakpointType$LambdaJavaBreakpointVariant", "<init>"));
            }
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/debugger/ui/breakpoints/JavaLineBreakpointType$LambdaJavaBreakpointVariant", "<init>"));
            }
            super(position, element, lambdaOrdinal);
        }

        @Override
        public Icon getIcon() {
            return AllIcons.Debugger.LambdaBreakpoint;
        }
    }

    public class LineJavaBreakpointVariant
    extends ExactJavaBreakpointVariant {
        public LineJavaBreakpointVariant(@Nullable XSourcePosition position, PsiElement element, Integer lambdaOrdinal) {
            if (position == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "com/intellij/debugger/ui/breakpoints/JavaLineBreakpointType$LineJavaBreakpointVariant", "<init>"));
            }
            super(position, element, lambdaOrdinal);
        }

        @Override
        public String getText() {
            return "Line";
        }

        @Override
        public Icon getIcon() {
            return AllIcons.Debugger.Db_set_breakpoint;
        }
    }

    public class ExactJavaBreakpointVariant
    extends JavaBreakpointVariant {
        private final PsiElement myElement;
        private final Integer myLambdaOrdinal;

        public ExactJavaBreakpointVariant(@Nullable XSourcePosition position, PsiElement element, Integer lambdaOrdinal) {
            if (position == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "com/intellij/debugger/ui/breakpoints/JavaLineBreakpointType$ExactJavaBreakpointVariant", "<init>"));
            }
            super(position);
            this.myElement = element;
            this.myLambdaOrdinal = lambdaOrdinal;
        }

        public Icon getIcon() {
            return this.myElement != null ? this.myElement.getIcon(0) : AllIcons.Debugger.Db_set_breakpoint;
        }

        public String getText() {
            return this.myElement != null ? StringUtil.shortenTextWithEllipsis((String)this.myElement.getText(), (int)100, (int)0) : "Line";
        }

        public TextRange getHighlightRange() {
            return this.myElement != null ? this.myElement.getTextRange() : null;
        }

        @NotNull
        public JavaLineBreakpointProperties createProperties() {
            JavaLineBreakpointProperties properties = (JavaLineBreakpointProperties)super.createProperties();
            assert (properties != null);
            properties.setLambdaOrdinal(this.myLambdaOrdinal);
            JavaLineBreakpointProperties javaLineBreakpointProperties = properties;
            if (javaLineBreakpointProperties == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/ui/breakpoints/JavaLineBreakpointType$ExactJavaBreakpointVariant", "createProperties"));
            }
            return javaLineBreakpointProperties;
        }
    }

    public class JavaBreakpointVariant
    extends XLineBreakpointType.XLineBreakpointAllVariant {
        public JavaBreakpointVariant(XSourcePosition position) {
            if (position == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "com/intellij/debugger/ui/breakpoints/JavaLineBreakpointType$JavaBreakpointVariant", "<init>"));
            }
            super((XLineBreakpointType)JavaLineBreakpointType.this, position);
        }
    }
}

