/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.breakpoints;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.JVMName;
import com.intellij.debugger.engine.JVMNameUtil;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.requests.RequestManagerImpl;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.impl.PositionUtil;
import com.intellij.debugger.jdi.MethodBytecodeUtil;
import com.intellij.debugger.requests.Requestor;
import com.intellij.debugger.ui.breakpoints.Breakpoint;
import com.intellij.debugger.ui.breakpoints.BreakpointCategory;
import com.intellij.debugger.ui.breakpoints.BreakpointWithHighlighter;
import com.intellij.debugger.ui.breakpoints.FilteredRequestor;
import com.intellij.debugger.ui.breakpoints.MethodBreakpointBase;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.ProgressWindow;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizerUtil;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMethod;
import com.intellij.util.StringBuilderSpinAllocator;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XBreakpointListener;
import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.ClassType;
import com.sun.jdi.InterfaceType;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.event.LocatableEvent;
import com.sun.jdi.event.MethodEntryEvent;
import com.sun.jdi.event.MethodExitEvent;
import com.sun.jdi.request.BreakpointRequest;
import com.sun.jdi.request.ClassPrepareRequest;
import com.sun.jdi.request.EventRequest;
import com.sun.jdi.request.MethodEntryRequest;
import com.sun.jdi.request.MethodExitRequest;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.stream.Stream;
import javax.swing.Icon;
import one.util.streamex.StreamEx;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.java.debugger.breakpoints.properties.JavaMethodBreakpointProperties;
import org.jetbrains.org.objectweb.asm.Label;
import org.jetbrains.org.objectweb.asm.MethodVisitor;

public class MethodBreakpoint
extends BreakpointWithHighlighter<JavaMethodBreakpointProperties>
implements MethodBreakpointBase {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.debugger.ui.breakpoints.MethodBreakpoint");
    @Nullable
    private JVMName mySignature;
    private boolean myIsStatic;
    @NonNls
    public static final Key<MethodBreakpoint> CATEGORY = BreakpointCategory.lookup("method_breakpoints");

    protected MethodBreakpoint(@NotNull Project project2, XBreakpoint breakpoint) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/debugger/ui/breakpoints/MethodBreakpoint", "<init>"));
        }
        super(project2, breakpoint);
    }

    public boolean isStatic() {
        return this.myIsStatic;
    }

    @Override
    @NotNull
    public Key<MethodBreakpoint> getCategory() {
        Key<MethodBreakpoint> key2 = CATEGORY;
        if (key2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/ui/breakpoints/MethodBreakpoint", "getCategory"));
        }
        return key2;
    }

    @Override
    public boolean isValid() {
        return super.isValid() && this.getMethodName() != null;
    }

    @Override
    protected void reload(@NotNull PsiFile psiFile) {
        PsiClass psiClass;
        if (psiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/intellij/debugger/ui/breakpoints/MethodBreakpoint", "reload"));
        }
        this.setMethodName(null);
        this.mySignature = null;
        MethodDescriptor descriptor = MethodBreakpoint.getMethodDescriptor(this.myProject, psiFile, this.getSourcePosition());
        if (descriptor != null) {
            this.setMethodName(descriptor.methodName);
            this.mySignature = descriptor.methodSignature;
            this.myIsStatic = descriptor.isStatic;
        }
        if ((psiClass = this.getPsiClass()) != null) {
            ((JavaMethodBreakpointProperties)((Object)this.getProperties())).myClassPattern = psiClass.getQualifiedName();
        }
        if (this.myIsStatic) {
            this.setInstanceFiltersEnabled(false);
        }
    }

    private static void createRequestForSubClasses(final @NotNull MethodBreakpointBase breakpoint, @NotNull DebugProcessImpl debugProcess, @NotNull ReferenceType baseType) {
        if (breakpoint == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "breakpoint", "com/intellij/debugger/ui/breakpoints/MethodBreakpoint", "createRequestForSubClasses"));
        }
        if (debugProcess == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debugProcess", "com/intellij/debugger/ui/breakpoints/MethodBreakpoint", "createRequestForSubClasses"));
        }
        if (baseType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseType", "com/intellij/debugger/ui/breakpoints/MethodBreakpoint", "createRequestForSubClasses"));
        }
        DebuggerManagerThreadImpl.assertIsManagerThread();
        RequestManagerImpl requestsManager = debugProcess.getRequestsManager();
        ClassPrepareRequest request = requestsManager.createClassPrepareRequest((debuggerProcess, referenceType) -> {
            if (baseType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseType", "com/intellij/debugger/ui/breakpoints/MethodBreakpoint", "lambda$createRequestForSubClasses$0"));
            }
            if (breakpoint == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "breakpoint", "com/intellij/debugger/ui/breakpoints/MethodBreakpoint", "lambda$createRequestForSubClasses$0"));
            }
            if (debugProcess == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debugProcess", "com/intellij/debugger/ui/breakpoints/MethodBreakpoint", "lambda$createRequestForSubClasses$0"));
            }
            if (MethodBreakpoint.instanceOf(referenceType, baseType)) {
                MethodBreakpoint.createRequestForPreparedClassEmulated(breakpoint, debugProcess, referenceType, false);
            }
        }, null);
        if (request != null) {
            requestsManager.registerRequest(breakpoint, request);
            request.enable();
            debugProcess.getVirtualMachineProxy().clearCaches();
        }
        AtomicReference indicatorRef = new AtomicReference();
        ApplicationManager.getApplication().invokeAndWait(() -> {
            if (debugProcess == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debugProcess", "com/intellij/debugger/ui/breakpoints/MethodBreakpoint", "lambda$createRequestForSubClasses$1"));
            }
            ProgressWindow progress = new ProgressWindow(true, false, debugProcess.getProject(), "Cancel emulation");
            progress.setDelayInMillis(2000);
            indicatorRef.set(progress);
        });
        final ProgressWindow indicator = (ProgressWindow)indicatorRef.get();
        final AtomicBoolean changed = new AtomicBoolean();
        XBreakpointListener listener2 = new XBreakpointListener<XBreakpoint<?>>(){

            void changed(@NotNull XBreakpoint b) {
                if (b == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "b", "com/intellij/debugger/ui/breakpoints/MethodBreakpoint$1", "changed"));
                }
                if (b == breakpoint.getXBreakpoint()) {
                    changed.set(true);
                    indicator.cancel();
                }
            }

            public void breakpointRemoved(@NotNull XBreakpoint b) {
                if (b == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "b", "com/intellij/debugger/ui/breakpoints/MethodBreakpoint$1", "breakpointRemoved"));
                }
                this.changed(b);
            }

            public void breakpointChanged(@NotNull XBreakpoint b) {
                if (b == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "b", "com/intellij/debugger/ui/breakpoints/MethodBreakpoint$1", "breakpointChanged"));
                }
                this.changed(b);
            }
        };
        XDebuggerManager.getInstance((Project)debugProcess.getProject()).getBreakpointManager().addBreakpointListener(listener2, (Disposable)indicator);
        ProgressManager.getInstance().executeProcessUnderProgress(() -> {
            if (baseType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseType", "com/intellij/debugger/ui/breakpoints/MethodBreakpoint", "lambda$createRequestForSubClasses$3"));
            }
            if (breakpoint == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "breakpoint", "com/intellij/debugger/ui/breakpoints/MethodBreakpoint", "lambda$createRequestForSubClasses$3"));
            }
            if (debugProcess == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debugProcess", "com/intellij/debugger/ui/breakpoints/MethodBreakpoint", "lambda$createRequestForSubClasses$3"));
            }
            MethodBreakpoint.processPreparedSubTypes(baseType, subType -> {
                if (breakpoint == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "breakpoint", "com/intellij/debugger/ui/breakpoints/MethodBreakpoint", "lambda$null$2"));
                }
                if (debugProcess == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debugProcess", "com/intellij/debugger/ui/breakpoints/MethodBreakpoint", "lambda$null$2"));
                }
                MethodBreakpoint.createRequestForPreparedClassEmulated(breakpoint, debugProcess, subType, false);
            }, indicator);
        }, (ProgressIndicator)indicator);
        if (indicator.isCanceled() && !changed.get()) {
            breakpoint.disableEmulation();
        }
    }

    @Override
    public void disableEmulation() {
        MethodBreakpointBase.disableEmulation(this);
    }

    static void createRequestForPreparedClassEmulated(final @NotNull MethodBreakpointBase breakpoint, final @NotNull DebugProcessImpl debugProcess, @NotNull ReferenceType classType, boolean base) {
        if (breakpoint == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "breakpoint", "com/intellij/debugger/ui/breakpoints/MethodBreakpoint", "createRequestForPreparedClassEmulated"));
        }
        if (debugProcess == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debugProcess", "com/intellij/debugger/ui/breakpoints/MethodBreakpoint", "createRequestForPreparedClassEmulated"));
        }
        if (classType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classType", "com/intellij/debugger/ui/breakpoints/MethodBreakpoint", "createRequestForPreparedClassEmulated"));
        }
        if (!base && !MethodBreakpoint.shouldCreateRequest(breakpoint, breakpoint.getXBreakpoint(), debugProcess, true)) {
            return;
        }
        try {
            Method lambdaMethod = MethodBytecodeUtil.getLambdaMethod(classType, debugProcess.getVirtualMachineProxy());
            if (lambdaMethod != null && !breakpoint.matchingMethods((StreamEx<Method>)StreamEx.of(((ClassType)classType).interfaces()).flatCollection(ReferenceType::allMethods), debugProcess).findFirst().isPresent()) {
                return;
            }
            StreamEx methods = lambdaMethod != null ? StreamEx.of((Object)lambdaMethod) : breakpoint.matchingMethods((StreamEx<Method>)((StreamEx)StreamEx.of(classType.methods()).filter(m -> base || !m.isAbstract())), debugProcess);
            boolean found = false;
            for (Method method : methods) {
                List<Location> allLineLocations;
                found = true;
                if (method.isNative()) {
                    breakpoint.disableEmulation();
                    return;
                }
                Method target2 = MethodBytecodeUtil.getBridgeTargetMethod(method, debugProcess.getVirtualMachineProxy());
                if (target2 != null && !ContainerUtil.isEmpty(DebuggerUtilsEx.allLineLocations(target2))) {
                    method = target2;
                }
                if ((allLineLocations = DebuggerUtilsEx.allLineLocations(method)) == null) {
                    breakpoint.disableEmulation();
                    return;
                }
                if (ContainerUtil.isEmpty(allLineLocations)) continue;
                if (breakpoint.isWatchEntry()) {
                    MethodBreakpoint.createLocationBreakpointRequest(breakpoint, (Location)ContainerUtil.getFirstItem(allLineLocations), debugProcess, true);
                }
                if (!breakpoint.isWatchExit()) continue;
                MethodBytecodeUtil.visit(method, new MethodVisitor(393216){
                    int myLastLine;
                    {
                        super(x0);
                        this.myLastLine = 0;
                    }

                    public void visitLineNumber(int line, Label start) {
                        this.myLastLine = line;
                    }

                    public void visitInsn(int opcode) {
                        switch (opcode) {
                            case 172: 
                            case 173: 
                            case 174: 
                            case 175: 
                            case 176: 
                            case 177: {
                                allLineLocations.stream().filter(l -> l.lineNumber() == this.myLastLine).findFirst().ifPresent(location -> {
                                    if (breakpoint == null) {
                                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "breakpoint", "com/intellij/debugger/ui/breakpoints/MethodBreakpoint$2", "lambda$visitInsn$1"));
                                    }
                                    if (debugProcess == null) {
                                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debugProcess", "com/intellij/debugger/ui/breakpoints/MethodBreakpoint$2", "lambda$visitInsn$1"));
                                    }
                                    MethodBreakpoint.createLocationBreakpointRequest(breakpoint, location, debugProcess, false);
                                });
                            }
                        }
                    }
                }, true);
            }
            if (base && found) {
                MethodBreakpoint.createRequestForSubClasses(breakpoint, debugProcess, classType);
            }
        }
        catch (Exception e) {
            LOG.debug((Throwable)e);
        }
    }

    private static void createLocationBreakpointRequest(@NotNull FilteredRequestor requestor, @Nullable Location location, @NotNull DebugProcessImpl debugProcess, boolean methodEntry) {
        if (requestor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "requestor", "com/intellij/debugger/ui/breakpoints/MethodBreakpoint", "createLocationBreakpointRequest"));
        }
        if (debugProcess == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debugProcess", "com/intellij/debugger/ui/breakpoints/MethodBreakpoint", "createLocationBreakpointRequest"));
        }
        BreakpointRequest request = MethodBreakpoint.createLocationBreakpointRequest(requestor, location, debugProcess);
        if (request != null) {
            request.putProperty("METHOD_ENTRY_KEY", methodEntry);
        }
    }

    @Override
    protected void createRequestForPreparedClass(@NotNull DebugProcessImpl debugProcess, @NotNull ReferenceType classType) {
        if (debugProcess == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debugProcess", "com/intellij/debugger/ui/breakpoints/MethodBreakpoint", "createRequestForPreparedClass"));
        }
        if (classType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classType", "com/intellij/debugger/ui/breakpoints/MethodBreakpoint", "createRequestForPreparedClass"));
        }
        if (this.isEmulated()) {
            MethodBreakpoint.createRequestForPreparedClassEmulated(this, debugProcess, classType, true);
        } else {
            this.createRequestForPreparedClassOriginal(debugProcess, classType);
        }
    }

    private void createRequestForPreparedClassOriginal(@NotNull DebugProcessImpl debugProcess, @NotNull ReferenceType classType) {
        if (debugProcess == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debugProcess", "com/intellij/debugger/ui/breakpoints/MethodBreakpoint", "createRequestForPreparedClassOriginal"));
        }
        if (classType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classType", "com/intellij/debugger/ui/breakpoints/MethodBreakpoint", "createRequestForPreparedClassOriginal"));
        }
        try {
            boolean hasMethod = false;
            for (Method method : classType.allMethods()) {
                String signature = method.signature();
                String name2 = method.name();
                if (!this.getMethodName().equals(name2) || !this.mySignature.getName(debugProcess).equals(signature)) continue;
                hasMethod = true;
                break;
            }
            if (!hasMethod) {
                debugProcess.getRequestsManager().setInvalid(this, DebuggerBundle.message((String)"error.invalid.breakpoint.method.not.found", (Object[])new Object[]{classType.name()}));
                return;
            }
            RequestManagerImpl requestManager = debugProcess.getRequestsManager();
            if (this.isWatchEntry()) {
                MethodEntryRequest entryRequest = MethodBreakpoint.findRequest(debugProcess, MethodEntryRequest.class, this);
                if (entryRequest == null) {
                    entryRequest = requestManager.createMethodEntryRequest(this);
                } else {
                    entryRequest.disable();
                }
                entryRequest.addClassFilter(classType);
                debugProcess.getRequestsManager().enableRequest(entryRequest);
            }
            if (this.isWatchExit()) {
                MethodExitRequest exitRequest = MethodBreakpoint.findRequest(debugProcess, MethodExitRequest.class, this);
                if (exitRequest == null) {
                    exitRequest = requestManager.createMethodExitRequest(this);
                } else {
                    exitRequest.disable();
                }
                exitRequest.addClassFilter(classType);
                debugProcess.getRequestsManager().enableRequest(exitRequest);
            }
        }
        catch (Exception e) {
            LOG.debug((Throwable)e);
        }
    }

    @Override
    public String getEventMessage(@NotNull LocatableEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/debugger/ui/breakpoints/MethodBreakpoint", "getEventMessage"));
        }
        return MethodBreakpoint.getEventMessage(event, this.getFileName());
    }

    static String getEventMessage(@NotNull LocatableEvent event, String defaultFileName) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/debugger/ui/breakpoints/MethodBreakpoint", "getEventMessage"));
        }
        Location location = event.location();
        if (event instanceof MethodEntryEvent) {
            return MethodBreakpoint.getEventMessage(true, ((MethodEntryEvent)event).method(), location, defaultFileName);
        }
        if (event instanceof MethodExitEvent) {
            return MethodBreakpoint.getEventMessage(false, ((MethodExitEvent)event).method(), location, defaultFileName);
        }
        Object entryProperty = event.request().getProperty("METHOD_ENTRY_KEY");
        if (entryProperty instanceof Boolean) {
            return MethodBreakpoint.getEventMessage((Boolean)entryProperty, location.method(), location, defaultFileName);
        }
        return "";
    }

    private static String getEventMessage(boolean entry, Method method, Location location, String defaultFileName) {
        String locationFileName;
        String locationQName = DebuggerUtilsEx.getLocationMethodQName(location);
        try {
            locationFileName = location.sourceName();
        }
        catch (AbsentInformationException e) {
            locationFileName = defaultFileName;
        }
        int locationLine = location.lineNumber();
        return DebuggerBundle.message((String)(entry ? "status.method.entry.breakpoint.reached" : "status.method.exit.breakpoint.reached"), (Object[])new Object[]{method.declaringType().name() + "." + method.name() + "()", locationQName, locationFileName, locationLine});
    }

    @Override
    public PsiElement getEvaluationElement() {
        return this.getPsiClass();
    }

    @Override
    protected Icon getDisabledIcon(boolean isMuted) {
        Breakpoint master = DebuggerManagerEx.getInstanceEx(this.myProject).getBreakpointManager().findMasterBreakpoint(this);
        if (master != null) {
            return isMuted ? AllIcons.Debugger.Db_muted_dep_method_breakpoint : AllIcons.Debugger.Db_dep_method_breakpoint;
        }
        return null;
    }

    @Override
    @NotNull
    protected Icon getInvalidIcon(boolean isMuted) {
        Icon icon = isMuted ? AllIcons.Debugger.Db_muted_invalid_method_breakpoint : AllIcons.Debugger.Db_invalid_method_breakpoint;
        if (icon == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/ui/breakpoints/MethodBreakpoint", "getInvalidIcon"));
        }
        return icon;
    }

    @Override
    @NotNull
    protected Icon getVerifiedIcon(boolean isMuted) {
        Icon icon = isMuted ? AllIcons.Debugger.Db_muted_verified_method_breakpoint : AllIcons.Debugger.Db_verified_method_breakpoint;
        if (icon == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/ui/breakpoints/MethodBreakpoint", "getVerifiedIcon"));
        }
        return icon;
    }

    @Override
    @NotNull
    protected Icon getVerifiedWarningsIcon(boolean isMuted) {
        Icon icon = isMuted ? AllIcons.Debugger.Db_muted_method_warning_breakpoint : AllIcons.Debugger.Db_method_warning_breakpoint;
        if (icon == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/ui/breakpoints/MethodBreakpoint", "getVerifiedWarningsIcon"));
        }
        return icon;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getDisplayName() {
        StringBuilder buffer = StringBuilderSpinAllocator.alloc();
        try {
            if (this.isValid()) {
                boolean classNameExists;
                String className = this.getClassName();
                boolean bl = classNameExists = className != null && className.length() > 0;
                if (classNameExists) {
                    buffer.append(className);
                }
                if (this.getMethodName() != null) {
                    if (classNameExists) {
                        buffer.append(".");
                    }
                    buffer.append(this.getMethodName());
                }
            } else {
                buffer.append(DebuggerBundle.message((String)"status.breakpoint.invalid", (Object[])new Object[0]));
            }
            String string = buffer.toString();
            return string;
        }
        finally {
            StringBuilderSpinAllocator.dispose((StringBuilder)buffer);
        }
    }

    @Override
    public boolean evaluateCondition(@NotNull EvaluationContextImpl context, @NotNull LocatableEvent event) throws EvaluateException {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/debugger/ui/breakpoints/MethodBreakpoint", "evaluateCondition"));
        }
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/debugger/ui/breakpoints/MethodBreakpoint", "evaluateCondition"));
        }
        if (!this.matchesEvent(event, context.getDebugProcess())) {
            return false;
        }
        return super.evaluateCondition(context, event);
    }

    public boolean matchesEvent(@NotNull LocatableEvent event, DebugProcessImpl process2) throws EvaluateException {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/debugger/ui/breakpoints/MethodBreakpoint", "matchesEvent"));
        }
        if (this.isEmulated()) {
            return true;
        }
        if (this.getMethodName() == null || this.mySignature == null) {
            return false;
        }
        Method method = event.location().method();
        return method != null && method.name().equals(this.getMethodName()) && method.signature().equals(this.mySignature.getName(process2));
    }

    @Nullable
    public static MethodBreakpoint create(@NotNull Project project2, XBreakpoint xBreakpoint) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/debugger/ui/breakpoints/MethodBreakpoint", "create"));
        }
        MethodBreakpoint breakpoint = new MethodBreakpoint(project2, xBreakpoint);
        return (MethodBreakpoint)breakpoint.init();
    }

    @Nullable
    private static MethodDescriptor getMethodDescriptor(@NotNull Project project2, @NotNull PsiFile psiJavaFile, @NotNull SourcePosition sourcePosition) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/debugger/ui/breakpoints/MethodBreakpoint", "getMethodDescriptor"));
        }
        if (psiJavaFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiJavaFile", "com/intellij/debugger/ui/breakpoints/MethodBreakpoint", "getMethodDescriptor"));
        }
        if (sourcePosition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourcePosition", "com/intellij/debugger/ui/breakpoints/MethodBreakpoint", "getMethodDescriptor"));
        }
        PsiDocumentManager docManager = PsiDocumentManager.getInstance((Project)project2);
        Document document = docManager.getDocument(psiJavaFile);
        if (document == null) {
            return null;
        }
        MethodDescriptor descriptor = (MethodDescriptor)ReadAction.compute(() -> {
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/debugger/ui/breakpoints/MethodBreakpoint", "lambda$getMethodDescriptor$5"));
            }
            if (sourcePosition == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourcePosition", "com/intellij/debugger/ui/breakpoints/MethodBreakpoint", "lambda$getMethodDescriptor$5"));
            }
            PsiMethod method = PositionUtil.getPsiElementAt(project2, PsiMethod.class, sourcePosition);
            if (method == null) {
                return null;
            }
            int methodOffset = method.getTextOffset();
            if (methodOffset < 0) {
                return null;
            }
            if (document.getLineNumber(methodOffset) < sourcePosition.getLine()) {
                return null;
            }
            PsiIdentifier identifier = method.getNameIdentifier();
            int methodNameOffset = identifier != null ? identifier.getTextOffset() : methodOffset;
            MethodDescriptor res = new MethodDescriptor();
            res.methodName = JVMNameUtil.getJVMMethodName(method);
            try {
                res.methodSignature = JVMNameUtil.getJVMSignature(method);
                res.isStatic = method.hasModifierProperty("static");
            }
            catch (IndexNotReadyException ignored) {
                return null;
            }
            res.methodLine = document.getLineNumber(methodNameOffset);
            return res;
        });
        if (descriptor == null || descriptor.methodName == null || descriptor.methodSignature == null) {
            return null;
        }
        return descriptor;
    }

    @Nullable
    static <T extends EventRequest> T findRequest(@NotNull DebugProcessImpl debugProcess, Class<T> requestClass, Requestor requestor) {
        if (debugProcess == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debugProcess", "com/intellij/debugger/ui/breakpoints/MethodBreakpoint", "findRequest"));
        }
        return (T)((EventRequest)StreamEx.of(debugProcess.getRequestsManager().findRequests(requestor)).select(requestClass).findFirst().orElse(null));
    }

    @Override
    public void readExternal(@NotNull Element breakpointNode) throws InvalidDataException {
        if (breakpointNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "breakpointNode", "com/intellij/debugger/ui/breakpoints/MethodBreakpoint", "readExternal"));
        }
        super.readExternal(breakpointNode);
        try {
            ((JavaMethodBreakpointProperties)((Object)this.getProperties())).WATCH_ENTRY = Boolean.valueOf(JDOMExternalizerUtil.readField((Element)breakpointNode, (String)"WATCH_ENTRY"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            ((JavaMethodBreakpointProperties)((Object)this.getProperties())).WATCH_EXIT = Boolean.valueOf(JDOMExternalizerUtil.readField((Element)breakpointNode, (String)"WATCH_EXIT"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean isEmulated() {
        return ((JavaMethodBreakpointProperties)((Object)this.getProperties())).EMULATED;
    }

    @Override
    public boolean isWatchEntry() {
        return ((JavaMethodBreakpointProperties)((Object)this.getProperties())).WATCH_ENTRY;
    }

    @Override
    public boolean isWatchExit() {
        return ((JavaMethodBreakpointProperties)((Object)this.getProperties())).WATCH_EXIT;
    }

    @Override
    public StreamEx matchingMethods(StreamEx<Method> methods, DebugProcessImpl debugProcess) {
        try {
            String methodName = this.getMethodName();
            String signature = this.mySignature != null ? this.mySignature.getName(debugProcess) : null;
            return (StreamEx)((StreamEx)methods.filter(m -> Comparing.equal((String)methodName, (String)m.name()) && Comparing.equal((String)signature, (String)m.signature()))).limit(1L);
        }
        catch (EvaluateException e) {
            LOG.warn((Throwable)e);
            return StreamEx.empty();
        }
    }

    @Nullable
    private String getMethodName() {
        return ((JavaMethodBreakpointProperties)((Object)this.getProperties())).myMethodName;
    }

    private void setMethodName(@Nullable String methodName) {
        ((JavaMethodBreakpointProperties)((Object)this.getProperties())).myMethodName = methodName;
    }

    private static boolean instanceOf(@Nullable ReferenceType type2, @NotNull ReferenceType superType) {
        if (superType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "superType", "com/intellij/debugger/ui/breakpoints/MethodBreakpoint", "instanceOf"));
        }
        if (type2 == null) {
            return false;
        }
        if (superType.equals(type2)) {
            return true;
        }
        return MethodBreakpoint.supertypes(type2).anyMatch(t -> {
            if (superType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "superType", "com/intellij/debugger/ui/breakpoints/MethodBreakpoint", "lambda$instanceOf$7"));
            }
            return MethodBreakpoint.instanceOf(t, superType);
        });
    }

    private static Stream<? extends ReferenceType> supertypes(ReferenceType type2) {
        if (type2 instanceof InterfaceType) {
            return ((InterfaceType)type2).superinterfaces().stream();
        }
        if (type2 instanceof ClassType) {
            return StreamEx.ofNullable((Object)((ClassType)type2).superclass()).prepend(((ClassType)type2).interfaces());
        }
        return StreamEx.empty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void processPreparedSubTypes(ReferenceType classType, Consumer<ReferenceType> consumer, ProgressIndicator progressIndicator) {
        long start = 0L;
        if (LOG.isDebugEnabled()) {
            start = System.currentTimeMillis();
        }
        progressIndicator.start();
        progressIndicator.setText(DebuggerBundle.message((String)"label.method.breakpoints.processing.classes", (Object[])new Object[0]));
        try {
            MultiMap inheritance = new MultiMap();
            List<ReferenceType> allTypes = classType.virtualMachine().allClasses();
            for (int i = 0; i < allTypes.size(); ++i) {
                if (progressIndicator.isCanceled()) {
                    return;
                }
                ReferenceType type2 = allTypes.get(i);
                if (type2.isPrepared()) {
                    MethodBreakpoint.supertypes(type2).forEach(st -> inheritance.putValue(st, (Object)type2));
                }
                progressIndicator.setText2(i + "/" + allTypes.size());
                progressIndicator.setFraction((double)i / (double)allTypes.size());
            }
            List types = ((StreamEx)StreamEx.ofTree((Object)classType, t -> StreamEx.of((Collection)inheritance.get(t))).skip(1L)).toList();
            progressIndicator.setText(DebuggerBundle.message((String)"label.method.breakpoints.setting.breakpoints", (Object[])new Object[0]));
            for (int i = 0; i < types.size(); ++i) {
                if (progressIndicator.isCanceled()) {
                    return;
                }
                consumer.accept((ReferenceType)types.get(i));
                progressIndicator.setText2(i + "/" + types.size());
                progressIndicator.setFraction((double)i / (double)types.size());
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Processed " + types.size() + " classes in " + String.valueOf(System.currentTimeMillis() - start) + "ms");
            }
        }
        finally {
            progressIndicator.stop();
        }
    }

    private static final class MethodDescriptor {
        String methodName;
        JVMName methodSignature;
        boolean isStatic;
        int methodLine;

        private MethodDescriptor() {
        }
    }
}

