/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.impl.nodes;

import com.intellij.debugger.ui.tree.render.ArrayRenderer;
import com.intellij.openapi.diagnostic.Logger;
import com.sun.jdi.ArrayReference;

public class ArrayIndexHelper {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.debugger.ui.impl.nodes.ArrayIndexHelper");
    private final ArrayReference myArray;
    private final ArrayRenderer myRenderer;

    public ArrayIndexHelper(ArrayReference array, ArrayRenderer renderer) {
        this.myRenderer = renderer;
        this.myArray = array;
    }

    public int getStartIndex() {
        if (this.myArray.length() == 0) {
            return -1;
        }
        return this.myRenderer.START_INDEX;
    }

    public int getEndIndex() {
        return Math.min(this.myArray.length() - 1, this.myRenderer.END_INDEX);
    }

    public ArrayRenderer newRenderer(int startIdx, int endIdx) {
        ArrayRenderer result2 = this.myRenderer.clone();
        result2.START_INDEX = startIdx < this.myArray.length() ? startIdx : 0;
        result2.END_INDEX = startIdx <= endIdx ? endIdx : startIdx;
        return result2;
    }
}

