/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.tree.render;

import com.intellij.debugger.DebuggerContext;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.settings.NodeRendererSettings;
import com.intellij.debugger.ui.tree.DebuggerTreeNode;
import com.intellij.debugger.ui.tree.NodeDescriptor;
import com.intellij.debugger.ui.tree.ValueDescriptor;
import com.intellij.debugger.ui.tree.render.ChildrenBuilder;
import com.intellij.debugger.ui.tree.render.ChildrenRenderer;
import com.intellij.debugger.ui.tree.render.DescriptorLabelListener;
import com.intellij.debugger.ui.tree.render.NodeRendererImpl;
import com.intellij.debugger.ui.tree.render.ValueLabelRenderer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.PsiElement;
import com.sun.jdi.Type;
import com.sun.jdi.Value;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;

public class CompoundNodeRenderer
extends NodeRendererImpl {
    @NonNls
    public static final String UNIQUE_ID = "CompoundNodeRenderer";
    private ValueLabelRenderer myLabelRenderer;
    private ChildrenRenderer myChildrenRenderer;
    protected final NodeRendererSettings myRendererSettings;

    public CompoundNodeRenderer(NodeRendererSettings rendererSettings, String name2, ValueLabelRenderer labelRenderer, ChildrenRenderer childrenRenderer) {
        super(name2);
        this.myRendererSettings = rendererSettings;
        this.myLabelRenderer = labelRenderer;
        this.myChildrenRenderer = childrenRenderer;
    }

    @Override
    public String getUniqueId() {
        return UNIQUE_ID;
    }

    @Override
    public CompoundNodeRenderer clone() {
        CompoundNodeRenderer renderer = (CompoundNodeRenderer)super.clone();
        renderer.myLabelRenderer = this.myLabelRenderer != null ? (ValueLabelRenderer)this.myLabelRenderer.clone() : null;
        renderer.myChildrenRenderer = this.myChildrenRenderer != null ? (ChildrenRenderer)this.myChildrenRenderer.clone() : null;
        return renderer;
    }

    @Override
    public void buildChildren(Value value2, ChildrenBuilder builder, EvaluationContext evaluationContext) {
        this.getChildrenRenderer().buildChildren(value2, builder, evaluationContext);
    }

    @Override
    public PsiElement getChildValueExpression(DebuggerTreeNode node, DebuggerContext context) throws EvaluateException {
        return this.getChildrenRenderer().getChildValueExpression(node, context);
    }

    @Override
    public boolean isExpandable(Value value2, EvaluationContext evaluationContext, NodeDescriptor parentDescriptor) {
        return this.getChildrenRenderer().isExpandable(value2, evaluationContext, parentDescriptor);
    }

    @Override
    public boolean isApplicable(Type type2) {
        return this.getLabelRenderer().isApplicable(type2) && this.getChildrenRenderer().isApplicable(type2);
    }

    @Override
    public String calcLabel(ValueDescriptor descriptor, EvaluationContext evaluationContext, DescriptorLabelListener listener2) throws EvaluateException {
        return this.getLabelRenderer().calcLabel(descriptor, evaluationContext, listener2);
    }

    public ValueLabelRenderer getLabelRenderer() {
        return this.myLabelRenderer;
    }

    public ChildrenRenderer getChildrenRenderer() {
        return this.myChildrenRenderer;
    }

    public void setLabelRenderer(ValueLabelRenderer labelRenderer) {
        this.myLabelRenderer = labelRenderer;
    }

    public void setChildrenRenderer(ChildrenRenderer childrenRenderer) {
        this.myChildrenRenderer = childrenRenderer;
    }

    @Override
    public void readExternal(Element element) throws InvalidDataException {
        super.readExternal(element);
        List children2 = element.getChildren("Renderer");
        if (children2 != null) {
            for (Element elem : children2) {
                String role = elem.getAttributeValue("role");
                if (role == null) continue;
                if ("label".equals(role)) {
                    this.myLabelRenderer = (ValueLabelRenderer)this.myRendererSettings.readRenderer(elem);
                    continue;
                }
                if (!"children".equals(role)) continue;
                this.myChildrenRenderer = (ChildrenRenderer)this.myRendererSettings.readRenderer(elem);
            }
        }
    }

    @Override
    public void writeExternal(Element element) throws WriteExternalException {
        super.writeExternal(element);
        if (this.myLabelRenderer != null) {
            Element labelRendererElement = this.myRendererSettings.writeRenderer(this.myLabelRenderer);
            labelRendererElement.setAttribute("role", "label");
            element.addContent(labelRendererElement);
        }
        if (this.myChildrenRenderer != null) {
            Element childrenRendererElement = this.myRendererSettings.writeRenderer(this.myChildrenRenderer);
            childrenRendererElement.setAttribute("role", "children");
            element.addContent(childrenRendererElement);
        }
    }
}

