/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.tree.render;

import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.engine.evaluation.expression.UnBoxingEvaluator;
import com.intellij.debugger.settings.NodeRendererSettings;
import com.intellij.debugger.ui.tree.ValueDescriptor;
import com.intellij.debugger.ui.tree.render.CompoundReferenceRenderer;
import com.intellij.debugger.ui.tree.render.DescriptorLabelListener;
import com.intellij.debugger.ui.tree.render.LabelRenderer;
import com.intellij.openapi.util.text.StringUtil;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.Type;
import com.sun.jdi.Value;

public abstract class UnboxableTypeRenderer
extends CompoundReferenceRenderer {
    public UnboxableTypeRenderer(String className, NodeRendererSettings rendererSettings) {
        super(rendererSettings, StringUtil.getShortName((String)className), new LabelRenderer(){

            @Override
            public String calcLabel(ValueDescriptor descriptor, EvaluationContext evaluationContext, DescriptorLabelListener labelListener) throws EvaluateException {
                return DebuggerUtils.getValueAsString((EvaluationContext)evaluationContext, (Value)UnBoxingEvaluator.getInnerPrimitiveValue((ObjectReference)descriptor.getValue()));
            }
        }, null);
        LOG.assertTrue(UnBoxingEvaluator.isTypeUnboxable(className));
        this.setClassName(className);
        this.setEnabled(true);
    }

    @Override
    public boolean isApplicable(Type type2) {
        return type2 instanceof ReferenceType && StringUtil.equals((CharSequence)type2.name(), (CharSequence)this.getClassName());
    }

    public static class DoubleRenderer
    extends UnboxableTypeRenderer {
        public DoubleRenderer(NodeRendererSettings rendererSettings) {
            super("java.lang.Double", rendererSettings);
        }
    }

    public static class FloatRenderer
    extends UnboxableTypeRenderer {
        public FloatRenderer(NodeRendererSettings rendererSettings) {
            super("java.lang.Float", rendererSettings);
        }
    }

    public static class LongRenderer
    extends UnboxableTypeRenderer {
        public LongRenderer(NodeRendererSettings rendererSettings) {
            super("java.lang.Long", rendererSettings);
        }
    }

    public static class IntegerRenderer
    extends UnboxableTypeRenderer {
        public IntegerRenderer(NodeRendererSettings rendererSettings) {
            super("java.lang.Integer", rendererSettings);
        }
    }

    public static class ShortRenderer
    extends UnboxableTypeRenderer {
        public ShortRenderer(NodeRendererSettings rendererSettings) {
            super("java.lang.Short", rendererSettings);
        }
    }

    public static class CharacterRenderer
    extends UnboxableTypeRenderer {
        public CharacterRenderer(NodeRendererSettings rendererSettings) {
            super("java.lang.Character", rendererSettings);
        }
    }

    public static class ByteRenderer
    extends UnboxableTypeRenderer {
        public ByteRenderer(NodeRendererSettings rendererSettings) {
            super("java.lang.Byte", rendererSettings);
        }
    }

    public static class BooleanRenderer
    extends UnboxableTypeRenderer {
        public BooleanRenderer(NodeRendererSettings rendererSettings) {
            super("java.lang.Boolean", rendererSettings);
        }
    }
}

