/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.designer;

import com.intellij.designer.AbstractToolWindowManager;
import com.intellij.designer.DesignerBundle;
import com.intellij.designer.DesignerCustomizations;
import com.intellij.designer.DesignerEditorPanelFacade;
import com.intellij.designer.DesignerToolWindow;
import com.intellij.designer.LightToolWindow;
import com.intellij.designer.designSurface.DesignerEditorPanel;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ex.ToolWindowEx;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import icons.UIDesignerNewIcons;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DesignerToolWindowManager
extends AbstractToolWindowManager {
    private DesignerToolWindow myToolWindowContent;

    public DesignerToolWindowManager(Project project2, FileEditorManager fileEditorManager) {
        super(project2, fileEditorManager);
    }

    public static DesignerToolWindow getInstance(DesignerEditorPanel designer) {
        DesignerToolWindowManager manager = DesignerToolWindowManager.getInstance(designer.getProject());
        if (manager.isEditorMode()) {
            return (DesignerToolWindow)manager.getContent(designer);
        }
        return manager.myToolWindowContent;
    }

    public static DesignerToolWindowManager getInstance(Project project2) {
        return (DesignerToolWindowManager)project2.getComponent(DesignerToolWindowManager.class);
    }

    @Override
    protected void initToolWindow() {
        if (this.myToolWindowContent == null) {
            this.myToolWindowContent = new DesignerToolWindow(this.myProject, true);
            Disposer.register((Disposable)this, () -> this.myToolWindowContent.dispose());
        }
        this.myToolWindow = ToolWindowManager.getInstance((Project)this.myProject).registerToolWindow(DesignerBundle.message("designer.toolwindow.name", new Object[0]), false, this.getAnchor(), (Disposable)this.myProject, true);
        this.myToolWindow.setIcon(UIDesignerNewIcons.ToolWindow);
        if (!ApplicationManager.getApplication().isHeadlessEnvironment()) {
            this.myToolWindow.getComponent().putClientProperty("HideIdLabel", "true");
        }
        ((ToolWindowEx)this.myToolWindow).setTitleActions(this.myToolWindowContent.createActions());
        this.initGearActions();
        ContentManager contentManager = this.myToolWindow.getContentManager();
        Content content = contentManager.getFactory().createContent((JComponent)this.myToolWindowContent.getToolWindowPanel(), DesignerBundle.message("designer.toolwindow.title", new Object[0]), false);
        content.setCloseable(false);
        content.setPreferredFocusableComponent((JComponent)((Object)this.myToolWindowContent.getComponentTree()));
        contentManager.addContent(content);
        contentManager.setSelectedContent(content, true);
        this.myToolWindow.setAvailable(false, null);
    }

    @Override
    protected ToolWindowAnchor getAnchor() {
        DesignerCustomizations customization = DesignerToolWindowManager.getCustomizations();
        return customization != null ? customization.getStructureAnchor() : ToolWindowAnchor.LEFT;
    }

    @Override
    protected void updateToolWindow(@Nullable DesignerEditorPanelFacade designer) {
        this.myToolWindowContent.update((DesignerEditorPanel)designer);
        if (designer == null) {
            this.myToolWindow.setAvailable(false, null);
        } else {
            this.myToolWindow.setAvailable(true, null);
            this.myToolWindow.show(null);
        }
    }

    @Override
    @NotNull
    public String getComponentName() {
        if ("UIDesignerToolWindowManager2" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/designer/DesignerToolWindowManager", "getComponentName"));
        }
        return "UIDesignerToolWindowManager2";
    }

    @Override
    protected LightToolWindow createContent(@NotNull DesignerEditorPanelFacade designer) {
        if (designer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "designer", "com/intellij/designer/DesignerToolWindowManager", "createContent"));
        }
        DesignerToolWindow toolWindowContent = new DesignerToolWindow(this.myProject, false);
        toolWindowContent.update((DesignerEditorPanel)designer);
        return this.createContent(designer, toolWindowContent, DesignerBundle.message("designer.toolwindow.title", new Object[0]), UIDesignerNewIcons.ToolWindow, (JComponent)toolWindowContent.getToolWindowPanel(), (JComponent)((Object)toolWindowContent.getComponentTree()), 320, toolWindowContent.createActions());
    }
}

