/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.designer.designSurface.tools;

import com.intellij.designer.designSurface.tools.SelectionTracker;
import com.intellij.designer.designSurface.tools.TargetingTool;
import com.intellij.designer.model.RadComponent;
import com.intellij.designer.utils.Cursors;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.util.Collections;
import java.util.List;

public class DragTracker
extends SelectionTracker {
    private static final Cursor myDragCursor = Cursors.getMoveCursor();

    public DragTracker(RadComponent component) {
        super(component);
        this.setDefaultCursor(Cursors.RESIZE_ALL);
        this.setDisabledCursor(Cursors.getNoCursor());
    }

    @Override
    protected Cursor getDefaultCursor() {
        return this.myState == 0 ? super.getDefaultCursor() : myDragCursor;
    }

    @Override
    protected void handleButtonUp(int button) {
        if (this.myState == 3) {
            this.eraseFeedback();
            this.executeCommand();
            this.myState = 0;
        } else {
            super.handleButtonUp(button);
        }
    }

    @Override
    protected void handleDragInProgress() {
        if (this.myState == 3) {
            this.updateContext();
            this.updateTargetUnderMouse();
            this.showFeedback();
            this.updateCommand();
        }
    }

    @Override
    protected void updateCommand() {
        if (this.myTargetOperation != null) {
            if (this.myContext.isMove()) {
                this.setExecuteEnabled(this.myContext.isMoveEnabled() && this.myTargetOperation.canExecute());
            } else if (this.myContext.isAdd()) {
                this.setExecuteEnabled(this.myContext.isAddEnabled() && this.myTargetOperation.canExecute());
            } else {
                this.setExecuteEnabled(false);
            }
        } else {
            this.setExecuteEnabled(false);
        }
    }

    private void updateTargetUnderMouse() {
        if (this.myContext.getComponents().isEmpty()) {
            return;
        }
        TargetingTool.ContainerTargetFilter filter = new TargetingTool.ContainerTargetFilter(){

            @Override
            public boolean preFilter(RadComponent component) {
                return !DragTracker.this.myContext.getComponents().contains(component);
            }

            @Override
            protected void updateContext(RadComponent target2) {
                DragTracker.this.updateContextType(target2);
            }
        };
        RadComponent target2 = this.myArea.findTarget(this.myCurrentScreenX, this.myCurrentScreenY, filter);
        this.setTarget(target2, filter);
        if (target2 == null) {
            this.myContext.setType(null);
        } else {
            this.myTargetOperation.setComponents(this.myContext.getComponents());
        }
    }

    protected void updateContextType(RadComponent target2) {
        if (this.myContext.getComponents().get(0).getParent() == target2) {
            this.myContext.setType("move_children");
        } else {
            this.myContext.setType("add_children");
        }
    }

    @Override
    protected void updateContext() {
        super.updateContext();
        this.myContext.setMoveDelta(new Point(this.moveDeltaWidth(), this.moveDeltaHeight()));
        this.myContext.setSizeDelta(new Dimension());
        this.myContext.setLocation(this.getLocation());
        if (this.myContext.getComponents() == null) {
            List<RadComponent> components = this.calculateContextComponents(RadComponent.getPureSelection(this.myArea.getSelection()));
            this.myContext.setComponents(components);
            for (RadComponent component : components) {
                component.processDropOperation(this.myContext);
            }
        }
    }

    protected List<RadComponent> calculateContextComponents(List<RadComponent> components) {
        RadComponent parent = null;
        for (RadComponent component : components) {
            if (parent == null) {
                parent = component.getParent();
                continue;
            }
            if (parent == component.getParent()) continue;
            components = Collections.emptyList();
            break;
        }
        return components;
    }
}

