/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.designer.model;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.designer.model.QuickFix;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ErrorInfo {
    private static final String KEY = "Inspection.Errors";
    private final String myName;
    private final String myPropertyName;
    private final HighlightDisplayLevel myLevel;
    private final List<QuickFix> myQuickFixes;

    public ErrorInfo(@NotNull String name2, @Nullable String propertyName, @NotNull HighlightDisplayLevel level) {
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/designer/model/ErrorInfo", "<init>"));
        }
        if (level == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "level", "com/intellij/designer/model/ErrorInfo", "<init>"));
        }
        this.myQuickFixes = new ArrayList<QuickFix>();
        this.myName = name2;
        this.myPropertyName = propertyName;
        this.myLevel = level;
    }

    public String getName() {
        return this.myName;
    }

    public HighlightDisplayLevel getLevel() {
        return this.myLevel;
    }

    @Nullable
    public String getPropertyName() {
        return this.myPropertyName;
    }

    public List<QuickFix> getQuickFixes() {
        return this.myQuickFixes;
    }

    public static boolean haveFixes(List<ErrorInfo> errorInfos) {
        for (ErrorInfo errorInfo : errorInfos) {
            if (errorInfo.getQuickFixes().isEmpty()) continue;
            return true;
        }
        return false;
    }
}

