/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.designer.model;

import com.intellij.designer.model.Property;
import com.intellij.designer.model.RadComponent;
import com.intellij.designer.model.RadLayout;
import com.intellij.designer.palette.DefaultPaletteItem;
import com.intellij.designer.palette.PaletteItem;
import com.intellij.designer.propertyTable.IPropertyDecorator;
import com.intellij.openapi.util.IconLoader;
import com.intellij.util.ArrayUtil;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class MetaModel {
    private final Class<RadComponent> myModel;
    private Class<RadLayout> myLayout;
    private final String myTarget;
    private final String myTag;
    private PaletteItem myPaletteItem;
    private String myTitle;
    private String myIconPath;
    private Icon myIcon;
    private String myCreation;
    private boolean myDelete = true;
    private List<String> myInplaceProperties = Collections.emptyList();
    private List<String> myTopProperties = Collections.emptyList();
    private List<String> myNormalProperties = Collections.emptyList();
    private List<String> myImportantProperties = Collections.emptyList();
    private List<String> myExpertProperties = Collections.emptyList();
    private List<String> myDeprecatedProperties = Collections.emptyList();
    private List<MetaModel> myMorphingModels = Collections.emptyList();

    public MetaModel(Class<RadComponent> model, String target2, String tag) {
        this.myModel = model;
        this.myTarget = target2;
        this.myTag = tag;
    }

    public Class<RadComponent> getModel() {
        return this.myModel;
    }

    public Class<RadLayout> getLayout() {
        return this.myLayout;
    }

    public void setLayout(Class<RadLayout> layout) {
        this.myLayout = layout;
    }

    public String getTarget() {
        return this.myTarget;
    }

    public String getTag() {
        return this.myTag;
    }

    public boolean isTag(@NotNull String tag) {
        if (tag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tag", "com/intellij/designer/model/MetaModel", "isTag"));
        }
        return tag.equals(this.myTag);
    }

    public boolean isTag(String ... tags) {
        return ArrayUtil.contains((String)this.myTag, (String[])tags);
    }

    public String getCreation() {
        return this.myCreation;
    }

    public void setCreation(String creation) {
        this.myCreation = creation;
    }

    public boolean canDelete() {
        return this.myDelete;
    }

    public void setDelete(boolean delete) {
        this.myDelete = delete;
    }

    public String getTitle() {
        return this.myTitle;
    }

    public Icon getIcon() {
        if (this.myIcon == null) {
            if (this.myIconPath == null) {
                return this.myPaletteItem == null ? null : this.myPaletteItem.getIcon();
            }
            this.myIcon = IconLoader.findIcon((String)this.myIconPath, this.myModel);
        }
        return this.myIcon;
    }

    public void setPresentation(String title, String iconPath) {
        this.myTitle = title;
        this.myIconPath = iconPath;
        this.myIcon = null;
    }

    public PaletteItem getPaletteItem() {
        return this.myPaletteItem;
    }

    public void setPaletteItem(@NotNull DefaultPaletteItem paletteItem) {
        if (paletteItem == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "paletteItem", "com/intellij/designer/model/MetaModel", "setPaletteItem"));
        }
        this.myPaletteItem = paletteItem;
        this.myPaletteItem.setMetaModel(this);
    }

    public List<MetaModel> getMorphingModels() {
        return this.myMorphingModels;
    }

    public void setMorphingModels(List<MetaModel> morphingModels) {
        this.myMorphingModels = morphingModels;
    }

    public List<String> getInplaceProperties() {
        return this.myInplaceProperties;
    }

    public void setInplaceProperties(List<String> inplaceProperties) {
        this.myInplaceProperties = inplaceProperties;
    }

    public List<String> getTopProperties() {
        return this.myTopProperties;
    }

    public void setTopProperties(List<String> topProperties) {
        this.myTopProperties = topProperties;
    }

    public void setNormalProperties(List<String> normalProperties) {
        this.myNormalProperties = normalProperties;
    }

    public boolean isImportantProperty(String name2) {
        return this.myImportantProperties.contains(name2);
    }

    public void setImportantProperties(List<String> importantProperties) {
        this.myImportantProperties = importantProperties;
    }

    public boolean isExpertProperty(String name2) {
        return this.myExpertProperties.contains(name2);
    }

    public void setExpertProperties(List<String> expertProperties) {
        this.myExpertProperties = expertProperties;
    }

    public boolean isDeprecatedProperty(String name2) {
        return this.myDeprecatedProperties.contains(name2);
    }

    public void setDeprecatedProperties(List<String> deprecatedProperties) {
        this.myDeprecatedProperties = deprecatedProperties;
    }

    public void decorate0(Property property, String name2) {
        property.setImportant(this.isImportantProperty(name2));
        property.setExpert(this.isExpertProperty(name2));
        property.setDeprecated(this.isDeprecatedProperty(name2));
    }

    public void decorate(Property property, String name2) {
        this.decorate0(property, name2);
        if (property instanceof IPropertyDecorator) {
            ((IPropertyDecorator)((Object)property)).decorate(this);
        }
    }

    public Property decorateWithOverride(Property property) {
        String name2 = property.getName();
        if (this.myNormalProperties.contains(name2) || this.myImportantProperties.contains(name2) || this.myExpertProperties.contains(name2) || this.myDeprecatedProperties.contains(name2)) {
            property = property.createForNewPresentation();
            this.decorate(property, name2);
        }
        return property;
    }
}

