/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic;

import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.SystemProperties;
import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VMOptions {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.diagnostic.VMOptions");

    public static int readOption(@NotNull MemoryKind kind2, boolean effective) {
        List<String> arguments;
        if (kind2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/diagnostic/VMOptions", "readOption"));
        }
        if (effective) {
            arguments = ManagementFactory.getRuntimeMXBean().getInputArguments();
        } else {
            File file2 = VMOptions.getWriteFile();
            if (file2 == null || !file2.exists()) {
                return -1;
            }
            try {
                String content = FileUtil.loadFile((File)file2);
                arguments = Collections.singletonList(content);
            }
            catch (IOException e) {
                LOG.warn((Throwable)e);
                return -1;
            }
        }
        for (String argument : arguments) {
            Matcher m = kind2.pattern.matcher(argument);
            if (!m.find()) continue;
            try {
                int value2 = Integer.parseInt(m.group(1));
                double multiplier = VMOptions.parseUnit(m.group(2));
                return (int)((double)value2 * multiplier);
            }
            catch (NumberFormatException e) {
                LOG.info((Throwable)e);
                break;
            }
        }
        return -1;
    }

    private static double parseUnit(String unitString) {
        if (StringUtil.startsWithIgnoreCase((String)unitString, (String)"k")) {
            return 9.765625E-4;
        }
        if (StringUtil.startsWithIgnoreCase((String)unitString, (String)"g")) {
            return 1024.0;
        }
        return 1.0;
    }

    public static void writeOption(@NotNull MemoryKind option, int value2) {
        if (option == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "option", "com/intellij/diagnostic/VMOptions", "writeOption"));
        }
        String optionValue = option.option + value2 + "m";
        VMOptions.writeGeneralOption(option.pattern, optionValue);
    }

    public static void writeOption(@NotNull String option, @NotNull String separator, @NotNull String value2) {
        if (option == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "option", "com/intellij/diagnostic/VMOptions", "writeOption"));
        }
        if (separator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "separator", "com/intellij/diagnostic/VMOptions", "writeOption"));
        }
        if (value2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/diagnostic/VMOptions", "writeOption"));
        }
        VMOptions.writeGeneralOption(Pattern.compile("-D" + option + separator + "(true|false)*([a-zA-Z]*)"), "-D" + option + separator + value2);
    }

    private static void writeGeneralOption(@NotNull Pattern pattern, @NotNull String value2) {
        if (pattern == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pattern", "com/intellij/diagnostic/VMOptions", "writeGeneralOption"));
        }
        if (value2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/diagnostic/VMOptions", "writeGeneralOption"));
        }
        File file2 = VMOptions.getWriteFile();
        if (file2 == null) {
            LOG.warn("VM options file not configured");
            return;
        }
        try {
            String content;
            String string = content = file2.exists() ? FileUtil.loadFile((File)file2) : VMOptions.read();
            if (!StringUtil.isEmptyOrSpaces((String)content)) {
                Matcher m = pattern.matcher(content);
                if (m.find()) {
                    StringBuffer b = new StringBuffer();
                    m.appendReplacement(b, Matcher.quoteReplacement(value2));
                    m.appendTail(b);
                    content = b.toString();
                } else {
                    content = StringUtil.trimTrailing((String)content) + SystemProperties.getLineSeparator() + value2;
                }
            } else {
                content = value2;
            }
            if (file2.exists()) {
                FileUtil.setReadOnlyAttribute((String)file2.getPath(), (boolean)false);
            } else {
                FileUtil.ensureExists((File)file2.getParentFile());
            }
            FileUtil.writeToFile((File)file2, (String)content);
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
        }
    }

    @Nullable
    public static String read() {
        try {
            File newFile = VMOptions.getWriteFile();
            if (newFile != null && newFile.exists()) {
                return FileUtil.loadFile((File)newFile);
            }
            String vmOptionsFile = System.getProperty("jb.vmOptionsFile");
            if (vmOptionsFile != null) {
                return FileUtil.loadFile((File)new File(vmOptionsFile));
            }
        }
        catch (IOException e) {
            LOG.info((Throwable)e);
        }
        return null;
    }

    @Nullable
    public static File getWriteFile() {
        String vmOptionsFile = System.getProperty("jb.vmOptionsFile");
        if (vmOptionsFile == null) {
            return null;
        }
        if (!FileUtil.isAncestor((String)PathManager.getHomePath(), (String)vmOptionsFile, (boolean)true)) {
            return new File(vmOptionsFile);
        }
        String location = PathManager.getCustomOptionsDirectory();
        if (location == null) {
            return null;
        }
        String fileName = ApplicationNamesInfo.getInstance().getProductName().toLowerCase(Locale.US);
        if (SystemInfo.is64Bit && !SystemInfo.isMac) {
            fileName = fileName + "64";
        }
        if (SystemInfo.isWindows) {
            fileName = fileName + ".exe";
        }
        fileName = fileName + ".vmoptions";
        return new File(location, fileName);
    }

    public static int readXmx() {
        return VMOptions.readOption(MemoryKind.HEAP, true);
    }

    public static int readMaxPermGen() {
        return VMOptions.readOption(MemoryKind.PERM_GEN, true);
    }

    public static int readCodeCache() {
        return VMOptions.readOption(MemoryKind.CODE_CACHE, true);
    }

    public static void writeXmx(int value2) {
        VMOptions.writeOption(MemoryKind.HEAP, value2);
    }

    public static void writeMaxPermGen(int value2) {
        VMOptions.writeOption(MemoryKind.PERM_GEN, value2);
    }

    public static void writeCodeCache(int value2) {
        VMOptions.writeOption(MemoryKind.CODE_CACHE, value2);
    }

    public static enum MemoryKind {
        HEAP("Xmx", ""),
        PERM_GEN("XX:MaxPermSize", "="),
        METASPACE("XX:MaxMetaspaceSize", "="),
        CODE_CACHE("XX:ReservedCodeCacheSize", "=");

        public final String optionName;
        public final String option;
        private final Pattern pattern;

        private MemoryKind(String name2, String separator) {
            this.optionName = name2;
            this.option = "-" + name2 + separator;
            this.pattern = Pattern.compile(this.option + "(\\d*)([a-zA-Z]*)");
        }
    }
}

