/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff;

import com.intellij.diff.comparison.ByLine;
import com.intellij.diff.comparison.ComparisonPolicy;
import com.intellij.diff.comparison.DiffTooBigException;
import com.intellij.diff.comparison.iterables.FairDiffIterable;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.Range;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.DumbProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.text.LineTokenizer;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class Block {
    private static final Logger LOG = Logger.getInstance(Block.class);
    @NotNull
    private final String[] mySource;
    private final int myStart;
    private final int myEnd;

    public Block(@NotNull String source, int start, int end) {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/diff/Block", "<init>"));
        }
        this(Block.tokenize(source), start, end);
    }

    public Block(@NotNull String[] source, int start, int end) {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/diff/Block", "<init>"));
        }
        this.mySource = source;
        this.myStart = DiffUtil.bound(start, 0, source.length);
        this.myEnd = DiffUtil.bound(end, this.myStart, source.length);
    }

    @NotNull
    public static String[] tokenize(@NotNull String text2) {
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/diff/Block", "tokenize"));
        }
        String[] stringArray = LineTokenizer.tokenize((CharSequence)text2, (boolean)false, (boolean)false);
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/Block", "tokenize"));
        }
        return stringArray;
    }

    @NotNull
    public Block createPreviousBlock(@NotNull String prevContent) {
        if (prevContent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prevContent", "com/intellij/diff/Block", "createPreviousBlock"));
        }
        Block block = this.createPreviousBlock(Block.tokenize(prevContent));
        if (block == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/Block", "createPreviousBlock"));
        }
        return block;
    }

    @NotNull
    public Block createPreviousBlock(@NotNull String[] prevContent) {
        Block block;
        block8: {
            if (prevContent == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prevContent", "com/intellij/diff/Block", "createPreviousBlock"));
            }
            try {
                FairDiffIterable iterable = ByLine.compare(Arrays.asList(prevContent), Arrays.asList(this.mySource), ComparisonPolicy.IGNORE_WHITESPACES, (ProgressIndicator)DumbProgressIndicator.INSTANCE);
                boolean greedy = this.myStart != this.myEnd;
                int start = this.myStart;
                int end = this.myEnd;
                int shift = 0;
                for (Range range : iterable.iterateChanges()) {
                    int changeStart = range.start2 + shift;
                    int changeEnd = range.end2 + shift;
                    int changeShift = range.end1 - range.start1 - (range.end2 - range.start2);
                    DiffUtil.UpdatedLineRange updatedRange = DiffUtil.updateRangeOnModification(start, end, changeStart, changeEnd, changeShift, greedy);
                    start = updatedRange.startLine;
                    end = updatedRange.endLine;
                    shift += changeShift;
                }
                if (start < 0 || end > prevContent.length || end < start) {
                    LOG.error("Invalid block range: [" + start + ", " + end + "); length - " + prevContent.length);
                }
                for (Range range : iterable.iterateUnchanged()) {
                    int count = range.end1 - range.start1;
                    for (int i2 = 0; i2 < count; ++i2) {
                        int prevIndex = range.start1 + i2;
                        int sourceIndex = range.start2 + i2;
                        if (!prevContent[prevIndex].equals(this.mySource[sourceIndex])) continue;
                        prevContent[prevIndex] = this.mySource[sourceIndex];
                    }
                }
                block = new Block(prevContent, start, end);
                if (block != null) break block8;
            }
            catch (DiffTooBigException e) {
                Block block2 = new Block(prevContent, 0, 0);
                if (block2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/Block", "createPreviousBlock"));
                }
                return block2;
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/Block", "createPreviousBlock"));
        }
        return block;
    }

    @NotNull
    public String getBlockContent() {
        String string = StringUtil.join(this.getLines(), (String)"\n");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/Block", "getBlockContent"));
        }
        return string;
    }

    @NotNull
    public List<String> getLines() {
        List<String> list2 = Arrays.asList(this.mySource).subList(this.myStart, this.myEnd);
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/Block", "getLines"));
        }
        return list2;
    }

    public int hashCode() {
        return Arrays.hashCode(this.mySource) ^ this.myStart ^ this.myEnd;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Block)) {
            return false;
        }
        Block other = (Block)object;
        return Arrays.equals(this.mySource, other.mySource) && this.myStart == other.myStart && this.myEnd == other.myEnd;
    }

    public int getStart() {
        return this.myStart;
    }

    public int getEnd() {
        return this.myEnd;
    }

    public String toString() {
        StringBuilder result2 = new StringBuilder();
        this.appendLines(result2, 0, this.myStart);
        result2.append("<-----------------------------\n");
        this.appendLines(result2, this.myStart, this.myEnd);
        result2.append("----------------------------->\n");
        this.appendLines(result2, this.myEnd, this.mySource.length);
        return result2.toString();
    }

    private void appendLines(@NotNull StringBuilder result2, int from, int to) {
        if (result2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/diff/Block", "appendLines"));
        }
        for (int i2 = from; i2 < to; ++i2) {
            result2.append(this.mySource[i2]);
            result2.append("\n");
        }
    }
}

