/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.actions;

import com.intellij.diff.util.DiffUtil;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.Pair;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;

public class AllLinesIterator
implements Iterator<Pair<Integer, CharSequence>> {
    @NotNull
    private final Document myDocument;
    private int myLine;

    public AllLinesIterator(@NotNull Document document) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/diff/actions/AllLinesIterator", "<init>"));
        }
        this.myLine = 0;
        this.myDocument = document;
    }

    @Override
    public boolean hasNext() {
        return this.myLine < DiffUtil.getLineCount(this.myDocument);
    }

    @Override
    public Pair<Integer, CharSequence> next() {
        int offset1 = this.myDocument.getLineStartOffset(this.myLine);
        int offset2 = this.myDocument.getLineEndOffset(this.myLine);
        CharSequence text2 = this.myDocument.getImmutableCharSequence().subSequence(offset1, offset2);
        Pair pair2 = new Pair((Object)this.myLine, (Object)text2);
        ++this.myLine;
        return pair2;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

