/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.actions.impl;

import com.intellij.diff.actions.impl.OpenInEditorAction;
import com.intellij.internal.statistic.UsageTrigger;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.MouseShortcut;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.event.EditorMouseEventArea;
import com.intellij.openapi.editor.ex.EditorGutterComponentEx;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.pom.Navigatable;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.util.Collections;
import java.util.List;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OpenInEditorWithMouseAction
extends AnAction
implements DumbAware {
    @NotNull
    private List<? extends Editor> myEditors = Collections.emptyList();

    public OpenInEditorWithMouseAction() {
        AnAction navigateAction = ActionManager.getInstance().getAction("GotoDeclaration");
        this.setShortcutSet((ShortcutSet)(navigateAction != null ? navigateAction.getShortcutSet() : new CustomShortcutSet(new Shortcut[]{new MouseShortcut(1, 128, 1)})));
    }

    public void install(@NotNull List<? extends Editor> editors) {
        if (editors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editors", "com/intellij/diff/actions/impl/OpenInEditorWithMouseAction", "install"));
        }
        this.myEditors = editors;
        for (Editor editor : editors) {
            this.registerCustomShortcutSet(this.getShortcutSet(), (EditorGutterComponentEx)editor.getGutter());
        }
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/diff/actions/impl/OpenInEditorWithMouseAction", "update"));
        }
        InputEvent inputEvent = e.getInputEvent();
        if (!(inputEvent instanceof MouseEvent)) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        if (e.getProject() == null) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        if (e.getData(OpenInEditorAction.KEY) == null) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        Component component = inputEvent.getComponent();
        if (component == null) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        Point point = ((MouseEvent)inputEvent).getPoint();
        Component componentAt = SwingUtilities.getDeepestComponentAt(component, point.x, point.y);
        if (!(componentAt instanceof EditorGutterComponentEx)) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        Editor editor = this.getEditor(componentAt);
        if (editor == null) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        MouseEvent convertedEvent = SwingUtilities.convertMouseEvent(inputEvent.getComponent(), (MouseEvent)inputEvent, componentAt);
        EditorMouseEventArea area = editor.getMouseEventArea(convertedEvent);
        if (area != EditorMouseEventArea.LINE_NUMBERS_AREA) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        e.getPresentation().setEnabledAndVisible(true);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/diff/actions/impl/OpenInEditorWithMouseAction", "actionPerformed"));
        }
        UsageTrigger.trigger("diff.OpenInEditor.Mouse");
        MouseEvent inputEvent = (MouseEvent)e.getInputEvent();
        OpenInEditorAction openInEditorAction = (OpenInEditorAction)((Object)e.getRequiredData(OpenInEditorAction.KEY));
        Project project2 = (Project)e.getRequiredData(CommonDataKeys.PROJECT);
        Component component = inputEvent.getComponent();
        Point point = inputEvent.getPoint();
        Component componentAt = SwingUtilities.getDeepestComponentAt(component, point.x, point.y);
        MouseEvent convertedEvent = SwingUtilities.convertMouseEvent(inputEvent.getComponent(), inputEvent, componentAt);
        Editor editor = this.getEditor(componentAt);
        assert (editor != null);
        int line = editor.xyToLogicalPosition((Point)convertedEvent.getPoint()).line;
        Navigatable navigatable = this.getNavigatable(editor, line);
        if (navigatable == null) {
            return;
        }
        openInEditorAction.openEditor(project2, navigatable);
    }

    @Nullable
    private Editor getEditor(@NotNull Component component) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/diff/actions/impl/OpenInEditorWithMouseAction", "getEditor"));
        }
        for (Editor editor : this.myEditors) {
            if (editor == null || editor.getGutter() != component) continue;
            return editor;
        }
        return null;
    }

    @Nullable
    protected abstract Navigatable getNavigatable(@NotNull Editor var1, int var2);
}

