/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.contents;

import com.intellij.diff.contents.DiffContentBase;
import com.intellij.diff.contents.DocumentContent;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.LineCol;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.util.LineSeparator;
import com.intellij.util.diff.Diff;
import com.intellij.util.diff.FilesTooBigForDiffException;
import java.nio.charset.Charset;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DocumentContentImpl
extends DiffContentBase
implements DocumentContent {
    @Nullable
    private final Project myProject;
    @NotNull
    private final Document myDocument;
    @Nullable
    private final FileType myType;
    @Nullable
    private final VirtualFile myHighlightFile;
    @Nullable
    private final LineSeparator mySeparator;
    @Nullable
    private final Charset myCharset;
    @Nullable
    private final Boolean myBOM;

    public DocumentContentImpl(@NotNull Document document) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/diff/contents/DocumentContentImpl", "<init>"));
        }
        this(null, document, null, null, null, null, null);
    }

    public DocumentContentImpl(@Nullable Project project2, @NotNull Document document, @Nullable FileType type2, @Nullable VirtualFile highlightFile, @Nullable LineSeparator separator, @Nullable Charset charset, @Nullable Boolean bom) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/diff/contents/DocumentContentImpl", "<init>"));
        }
        this.myProject = project2;
        this.myDocument = document;
        this.myType = type2;
        this.myHighlightFile = highlightFile;
        this.mySeparator = separator;
        this.myCharset = charset;
        this.myBOM = bom;
    }

    @Nullable
    public Project getProject() {
        return this.myProject;
    }

    @NotNull
    public Document getDocument() {
        Document document = this.myDocument;
        if (document == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/contents/DocumentContentImpl", "getDocument"));
        }
        return document;
    }

    @Nullable
    public VirtualFile getHighlightFile() {
        return this.myHighlightFile;
    }

    @Nullable
    public Navigatable getNavigatable(@NotNull LineCol position) {
        if (position == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "com/intellij/diff/contents/DocumentContentImpl", "getNavigatable"));
        }
        if (!DiffUtil.canNavigateToFile(this.myProject, this.getHighlightFile())) {
            return null;
        }
        return new MyNavigatable(this.myProject, this.getHighlightFile(), this.getDocument(), position);
    }

    @Nullable
    public Navigatable getNavigatable() {
        return this.getNavigatable(new LineCol(0));
    }

    @Nullable
    public LineSeparator getLineSeparator() {
        return this.mySeparator;
    }

    @Nullable
    public Boolean hasBom() {
        return this.myBOM;
    }

    @Nullable
    public FileType getContentType() {
        return this.myType;
    }

    @Nullable
    public Charset getCharset() {
        return this.myCharset;
    }

    private static class MyNavigatable
    implements Navigatable {
        @NotNull
        private final Project myProject;
        @NotNull
        private final VirtualFile myTargetFile;
        @NotNull
        private final Document myDocument;
        @NotNull
        private final LineCol myPosition;

        public MyNavigatable(@NotNull Project project2, @NotNull VirtualFile targetFile, @NotNull Document document, @NotNull LineCol position) {
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/diff/contents/DocumentContentImpl$MyNavigatable", "<init>"));
            }
            if (targetFile == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetFile", "com/intellij/diff/contents/DocumentContentImpl$MyNavigatable", "<init>"));
            }
            if (document == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/diff/contents/DocumentContentImpl$MyNavigatable", "<init>"));
            }
            if (position == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "com/intellij/diff/contents/DocumentContentImpl$MyNavigatable", "<init>"));
            }
            this.myProject = project2;
            this.myTargetFile = targetFile;
            this.myDocument = document;
            this.myPosition = position;
        }

        public void navigate(boolean requestFocus) {
            Document targetDocument = FileDocumentManager.getInstance().getDocument(this.myTargetFile);
            LineCol targetPosition = MyNavigatable.translatePosition(this.myDocument, targetDocument, this.myPosition);
            OpenFileDescriptor descriptor = new OpenFileDescriptor(this.myProject, this.myTargetFile, targetPosition.line, targetPosition.column);
            if (descriptor.canNavigate()) {
                descriptor.navigate(true);
            }
        }

        public boolean canNavigate() {
            return this.myTargetFile.isValid();
        }

        public boolean canNavigateToSource() {
            return false;
        }

        @NotNull
        private static LineCol translatePosition(@NotNull Document fromDocument, @Nullable Document toDocument, @NotNull LineCol position) {
            LineCol lineCol;
            block8: {
                block7: {
                    LineCol lineCol2;
                    if (fromDocument == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fromDocument", "com/intellij/diff/contents/DocumentContentImpl$MyNavigatable", "translatePosition"));
                    }
                    if (position == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "com/intellij/diff/contents/DocumentContentImpl$MyNavigatable", "translatePosition"));
                    }
                    try {
                        if (toDocument != null) break block7;
                        lineCol2 = position;
                    }
                    catch (FilesTooBigForDiffException ignore) {
                        LineCol lineCol3 = position;
                        if (lineCol3 == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/contents/DocumentContentImpl$MyNavigatable", "translatePosition"));
                        }
                        return lineCol3;
                    }
                    if (lineCol2 == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/contents/DocumentContentImpl$MyNavigatable", "translatePosition"));
                    }
                    return lineCol2;
                }
                int targetLine = Diff.translateLine((CharSequence)fromDocument.getCharsSequence(), (CharSequence)toDocument.getCharsSequence(), (int)position.line, (boolean)true);
                lineCol = new LineCol(targetLine, position.column);
                if (lineCol != null) break block8;
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/contents/DocumentContentImpl$MyNavigatable", "translatePosition"));
            }
            return lineCol;
        }
    }
}

