/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.util.base;

import org.jetbrains.annotations.NotNull;

public enum HighlightPolicy {
    BY_LINE("Highlight lines"),
    BY_WORD("Highlight words"),
    BY_WORD_SPLIT("Highlight split changes"),
    DO_NOT_HIGHLIGHT("Do not highlight");

    @NotNull
    private final String myText;

    private HighlightPolicy(String text2) {
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/diff/tools/util/base/HighlightPolicy", "<init>"));
        }
        this.myText = text2;
    }

    @NotNull
    public String getText() {
        String string = this.myText;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/util/base/HighlightPolicy", "getText"));
        }
        return string;
    }

    public boolean isShouldCompare() {
        return this != DO_NOT_HIGHLIGHT;
    }

    public boolean isFineFragments() {
        return this == BY_WORD || this == BY_WORD_SPLIT;
    }

    public boolean isShouldSquash() {
        return this == BY_WORD || this == BY_LINE;
    }
}

