/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dupLocator.index;

import com.intellij.dupLocator.DuplicatesProfile;
import com.intellij.dupLocator.DuplocateVisitor;
import com.intellij.dupLocator.DuplocatorState;
import com.intellij.dupLocator.LightDuplicateProfile;
import com.intellij.dupLocator.index.TracingData;
import com.intellij.dupLocator.treeHash.FragmentsCollector;
import com.intellij.dupLocator.util.PsiFragment;
import com.intellij.lang.Language;
import com.intellij.lang.LighterAST;
import com.intellij.lang.LighterASTNode;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.psi.PsiElement;
import com.intellij.util.SystemProperties;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexExtension;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.FileContentImpl;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.PsiDependentIndex;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.util.io.EnumeratorIntegerDescriptor;
import com.intellij.util.io.KeyDescriptor;
import gnu.trove.THashMap;
import gnu.trove.TIntArrayList;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DuplicatesIndex
extends FileBasedIndexExtension<Integer, TIntArrayList>
implements PsiDependentIndex {
    static boolean ourEnabled = SystemProperties.getBooleanProperty((String)"idea.enable.duplicates.online.calculation", (boolean)true);
    static final boolean ourEnabledLightProfiles = true;
    private static boolean ourEnabledOldProfiles = false;
    @NonNls
    public static final ID<Integer, TIntArrayList> NAME = ID.create((String)"DuplicatesIndex");
    private static final int myBaseVersion = 25;
    private final FileBasedIndex.InputFilter myInputFilter = file2 -> {
        if (!ourEnabled || !file2.isInLocalFileSystem()) {
            return false;
        }
        DuplicatesProfile duplicatesProfile = DuplicatesIndex.findDuplicatesProfile(file2.getFileType());
        if (duplicatesProfile instanceof LightDuplicateProfile) {
            return ((LightDuplicateProfile)((Object)duplicatesProfile)).acceptsFile(file2);
        }
        return duplicatesProfile != null;
    };
    private final DataExternalizer<TIntArrayList> myValueExternalizer = new DataExternalizer<TIntArrayList>(){

        public void save(@NotNull DataOutput out, TIntArrayList list2) throws IOException {
            if (out == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "out", "com/intellij/dupLocator/index/DuplicatesIndex$1", "save"));
            }
            if (list2.size() == 2) {
                DataInputOutputUtil.writeINT((DataOutput)out, (int)list2.getQuick(0));
                DataInputOutputUtil.writeINT((DataOutput)out, (int)list2.getQuick(1));
            } else {
                DataInputOutputUtil.writeINT((DataOutput)out, (int)(-list2.size()));
                int prev = 0;
                int len = list2.size();
                for (int i2 = 0; i2 < len; i2 += 2) {
                    int value2 = list2.getQuick(i2);
                    DataInputOutputUtil.writeINT((DataOutput)out, (int)(value2 - prev));
                    prev = value2;
                    DataInputOutputUtil.writeINT((DataOutput)out, (int)list2.getQuick(i2 + 1));
                }
            }
        }

        public TIntArrayList read(@NotNull DataInput in) throws IOException {
            if (in == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "in", "com/intellij/dupLocator/index/DuplicatesIndex$1", "read"));
            }
            int capacityOrValue = DataInputOutputUtil.readINT((DataInput)in);
            if (capacityOrValue >= 0) {
                TIntArrayList list2 = new TIntArrayList(2);
                list2.add(capacityOrValue);
                list2.add(DataInputOutputUtil.readINT((DataInput)in));
                return list2;
            }
            TIntArrayList list3 = new TIntArrayList(capacityOrValue);
            int prev = 0;
            for (capacityOrValue = -capacityOrValue; capacityOrValue > 0; capacityOrValue -= 2) {
                int value2 = DataInputOutputUtil.readINT((DataInput)in) + prev;
                list3.add(value2);
                prev = value2;
                list3.add(DataInputOutputUtil.readINT((DataInput)in));
            }
            return list3;
        }
    };
    private final DataIndexer<Integer, TIntArrayList, FileContent> myIndexer = new DataIndexer<Integer, TIntArrayList, FileContent>(){

        @NotNull
        public Map<Integer, TIntArrayList> map(@NotNull FileContent inputData) {
            FileContentImpl fileContent;
            DuplicatesProfile profile2;
            FileType type2;
            block9: {
                THashMap tHashMap;
                if (inputData == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inputData", "com/intellij/dupLocator/index/DuplicatesIndex$2", "map"));
                }
                type2 = inputData.getFileType();
                profile2 = DuplicatesIndex.findDuplicatesProfile(type2);
                if (profile2 == null || !profile2.acceptsContentForIndexing(inputData)) {
                    Map<Integer, TIntArrayList> map2 = Collections.emptyMap();
                    if (map2 == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dupLocator/index/DuplicatesIndex$2", "map"));
                    }
                    return map2;
                }
                try {
                    fileContent = (FileContentImpl)inputData;
                    if (!(profile2 instanceof LightDuplicateProfile)) break block9;
                    final THashMap result2 = new THashMap();
                    LighterAST ast = fileContent.getLighterASTForPsiDependentIndex();
                    ((LightDuplicateProfile)((Object)profile2)).process(ast, new LightDuplicateProfile.Callback(){

                        @Override
                        public void process(int hash, int hash2, @NotNull LighterAST ast, LighterASTNode ... nodes) {
                            if (ast == null) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ast", "com/intellij/dupLocator/index/DuplicatesIndex$2$1", "process"));
                            }
                            if (nodes == null) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodes", "com/intellij/dupLocator/index/DuplicatesIndex$2$1", "process"));
                            }
                            TIntArrayList list2 = (TIntArrayList)result2.get((Object)hash);
                            if (list2 == null) {
                                list2 = new TIntArrayList(2);
                                result2.put((Object)hash, (Object)list2);
                            }
                            list2.add(nodes[0].getStartOffset());
                            list2.add(hash2);
                        }
                    });
                    tHashMap = result2;
                }
                catch (StackOverflowError ae) {
                    Map<Integer, TIntArrayList> map3 = Collections.emptyMap();
                    if (map3 == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dupLocator/index/DuplicatesIndex$2", "map"));
                    }
                    return map3;
                }
                if (tHashMap == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dupLocator/index/DuplicatesIndex$2", "map"));
                }
                return tHashMap;
            }
            MyFragmentsCollector collector = new MyFragmentsCollector(profile2, ((LanguageFileType)type2).getLanguage());
            DuplocateVisitor visitor = profile2.createVisitor(collector, true);
            visitor.visitNode((PsiElement)fileContent.getPsiFileForPsiDependentIndex());
            THashMap<Integer, TIntArrayList> tHashMap = collector.getMap();
            if (tHashMap == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dupLocator/index/DuplicatesIndex$2", "map"));
            }
            return tHashMap;
        }
    };
    private static final TracingData myTracingData = null;

    @Nullable
    public static DuplicatesProfile findDuplicatesProfile(FileType fileType) {
        if (!(fileType instanceof LanguageFileType)) {
            return null;
        }
        Language language = ((LanguageFileType)fileType).getLanguage();
        DuplicatesProfile profile2 = DuplicatesProfile.findProfileForLanguage(language);
        return profile2 != null && (ourEnabledOldProfiles && profile2.supportDuplicatesIndex() || profile2 instanceof LightDuplicateProfile) ? profile2 : null;
    }

    public int getVersion() {
        return 25 + (ourEnabled ? 255 : 0) + 128 + (ourEnabledOldProfiles ? 33 : 0);
    }

    public boolean dependsOnFileContent() {
        return true;
    }

    @NotNull
    public ID<Integer, TIntArrayList> getName() {
        ID<Integer, TIntArrayList> iD = NAME;
        if (iD == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dupLocator/index/DuplicatesIndex", "getName"));
        }
        return iD;
    }

    @NotNull
    public DataIndexer<Integer, TIntArrayList, FileContent> getIndexer() {
        DataIndexer<Integer, TIntArrayList, FileContent> dataIndexer = this.myIndexer;
        if (dataIndexer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dupLocator/index/DuplicatesIndex", "getIndexer"));
        }
        return dataIndexer;
    }

    @NotNull
    public DataExternalizer<TIntArrayList> getValueExternalizer() {
        DataExternalizer<TIntArrayList> dataExternalizer = this.myValueExternalizer;
        if (dataExternalizer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dupLocator/index/DuplicatesIndex", "getValueExternalizer"));
        }
        return dataExternalizer;
    }

    @NotNull
    public KeyDescriptor<Integer> getKeyDescriptor() {
        EnumeratorIntegerDescriptor enumeratorIntegerDescriptor = EnumeratorIntegerDescriptor.INSTANCE;
        if (enumeratorIntegerDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dupLocator/index/DuplicatesIndex", "getKeyDescriptor"));
        }
        return enumeratorIntegerDescriptor;
    }

    @NotNull
    public FileBasedIndex.InputFilter getInputFilter() {
        FileBasedIndex.InputFilter inputFilter = this.myInputFilter;
        if (inputFilter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dupLocator/index/DuplicatesIndex", "getInputFilter"));
        }
        return inputFilter;
    }

    static boolean isIndexedFragment(@Nullable PsiFragment frag, int cost, DuplicatesProfile profile2, DuplocatorState duplocatorState) {
        if (frag == null) {
            return false;
        }
        return profile2.shouldPutInIndex(frag, cost, duplocatorState);
    }

    public static boolean setEnabled(boolean value2) {
        boolean old = ourEnabled;
        ourEnabled = value2;
        return old;
    }

    public static boolean setEnabledOldProfiles(boolean value2) {
        boolean old = ourEnabledOldProfiles;
        ourEnabledOldProfiles = value2;
        return old;
    }

    public boolean hasSnapshotMapping() {
        return true;
    }

    private static class MyFragmentsCollector
    implements FragmentsCollector {
        private final THashMap<Integer, TIntArrayList> myMap = new THashMap();
        private final DuplicatesProfile myProfile;
        private final DuplocatorState myDuplocatorState;

        public MyFragmentsCollector(DuplicatesProfile profile2, Language language) {
            this.myProfile = profile2;
            this.myDuplocatorState = profile2.getDuplocatorState(language);
        }

        @Override
        public void add(int hash, int cost, @Nullable PsiFragment frag) {
            TIntArrayList list2;
            if (!DuplicatesIndex.isIndexedFragment(frag, cost, this.myProfile, this.myDuplocatorState)) {
                return;
            }
            if (myTracingData != null) {
                myTracingData.record(hash, cost, frag);
            }
            if ((list2 = (TIntArrayList)this.myMap.get((Object)hash)) == null) {
                list2 = new TIntArrayList();
                this.myMap.put((Object)hash, (Object)list2);
            }
            list2.add(frag.getStartOffset());
            list2.add(0);
        }

        public THashMap<Integer, TIntArrayList> getMap() {
            return this.myMap;
        }
    }
}

